<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for beneficiaries StructType
 * @subpackage Structs
 */
class Beneficiaries extends AbstractStructBase
{
    /**
     * The beneficiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:beneficiary
     * @var \StructType\Beneficiary[]
     */
    public $beneficiary;
    /**
     * Constructor method for beneficiaries
     * @uses Beneficiaries::setBeneficiary()
     * @param \StructType\Beneficiary[] $beneficiary
     */
    public function __construct(array $beneficiary = array())
    {
        $this
            ->setBeneficiary($beneficiary);
    }
    /**
     * Get beneficiary value
     * @return \StructType\Beneficiary[]|null
     */
    public function getBeneficiary()
    {
        return $this->beneficiary;
    }
    /**
     * This method is responsible for validating the values passed to the setBeneficiary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeneficiary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeneficiaryForArrayConstraintsFromSetBeneficiary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $beneficiariesBeneficiaryItem) {
            // validation for constraint: itemType
            if (!$beneficiariesBeneficiaryItem instanceof \StructType\Beneficiary) {
                $invalidValues[] = is_object($beneficiariesBeneficiaryItem) ? get_class($beneficiariesBeneficiaryItem) : sprintf('%s(%s)', gettype($beneficiariesBeneficiaryItem), var_export($beneficiariesBeneficiaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beneficiary property can only contain items of type \StructType\Beneficiary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beneficiary value
     * @throws \InvalidArgumentException
     * @param \StructType\Beneficiary[] $beneficiary
     * @return \StructType\Beneficiaries
     */
    public function setBeneficiary(array $beneficiary = array())
    {
        // validation for constraint: array
        if ('' !== ($beneficiaryArrayErrorMessage = self::validateBeneficiaryForArrayConstraintsFromSetBeneficiary($beneficiary))) {
            throw new \InvalidArgumentException($beneficiaryArrayErrorMessage, __LINE__);
        }
        $this->beneficiary = $beneficiary;
        return $this;
    }
    /**
     * Add item to beneficiary value
     * @throws \InvalidArgumentException
     * @param \StructType\Beneficiary $item
     * @return \StructType\Beneficiaries
     */
    public function addToBeneficiary(\StructType\Beneficiary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Beneficiary) {
            throw new \InvalidArgumentException(sprintf('The beneficiary property can only contain items of type \StructType\Beneficiary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beneficiary[] = $item;
        return $this;
    }
}
