<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgentConract StructType
 * Meta information extracted from the WSDL
 * - type: tns:AgentConract
 * @subpackage Structs
 */
class AgentConract extends AbstractStructBase
{
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The departmentCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $departmentCode;
    /**
     * The ikp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ikp;
    /**
     * The ikpCurator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ikpCurator;
    /**
     * The salesChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesChannel;
    /**
     * The agent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectInfo
     */
    public $agent;
    /**
     * The agentProxy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentProxy;
    /**
     * Constructor method for AgentConract
     * @uses AgentConract::setNumber()
     * @uses AgentConract::setDate()
     * @uses AgentConract::setDepartmentCode()
     * @uses AgentConract::setIkp()
     * @uses AgentConract::setIkpCurator()
     * @uses AgentConract::setSalesChannel()
     * @uses AgentConract::setAgent()
     * @uses AgentConract::setAgentProxy()
     * @param string $number
     * @param string $date
     * @param string $departmentCode
     * @param string $ikp
     * @param string $ikpCurator
     * @param string $salesChannel
     * @param \StructType\SubjectInfo $agent
     * @param string $agentProxy
     */
    public function __construct($number = null, $date = null, $departmentCode = null, $ikp = null, $ikpCurator = null, $salesChannel = null, \StructType\SubjectInfo $agent = null, $agentProxy = null)
    {
        $this
            ->setNumber($number)
            ->setDate($date)
            ->setDepartmentCode($departmentCode)
            ->setIkp($ikp)
            ->setIkpCurator($ikpCurator)
            ->setSalesChannel($salesChannel)
            ->setAgent($agent)
            ->setAgentProxy($agentProxy);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\AgentConract
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\AgentConract
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get departmentCode value
     * @return string|null
     */
    public function getDepartmentCode()
    {
        return $this->departmentCode;
    }
    /**
     * Set departmentCode value
     * @param string $departmentCode
     * @return \StructType\AgentConract
     */
    public function setDepartmentCode($departmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($departmentCode) && !is_string($departmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departmentCode, true), gettype($departmentCode)), __LINE__);
        }
        $this->departmentCode = $departmentCode;
        return $this;
    }
    /**
     * Get ikp value
     * @return string|null
     */
    public function getIkp()
    {
        return $this->ikp;
    }
    /**
     * Set ikp value
     * @param string $ikp
     * @return \StructType\AgentConract
     */
    public function setIkp($ikp = null)
    {
        // validation for constraint: string
        if (!is_null($ikp) && !is_string($ikp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ikp, true), gettype($ikp)), __LINE__);
        }
        $this->ikp = $ikp;
        return $this;
    }
    /**
     * Get ikpCurator value
     * @return string|null
     */
    public function getIkpCurator()
    {
        return $this->ikpCurator;
    }
    /**
     * Set ikpCurator value
     * @param string $ikpCurator
     * @return \StructType\AgentConract
     */
    public function setIkpCurator($ikpCurator = null)
    {
        // validation for constraint: string
        if (!is_null($ikpCurator) && !is_string($ikpCurator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ikpCurator, true), gettype($ikpCurator)), __LINE__);
        }
        $this->ikpCurator = $ikpCurator;
        return $this;
    }
    /**
     * Get salesChannel value
     * @return string|null
     */
    public function getSalesChannel()
    {
        return $this->salesChannel;
    }
    /**
     * Set salesChannel value
     * @param string $salesChannel
     * @return \StructType\AgentConract
     */
    public function setSalesChannel($salesChannel = null)
    {
        // validation for constraint: string
        if (!is_null($salesChannel) && !is_string($salesChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesChannel, true), gettype($salesChannel)), __LINE__);
        }
        $this->salesChannel = $salesChannel;
        return $this;
    }
    /**
     * Get agent value
     * @return \StructType\SubjectInfo|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \StructType\SubjectInfo $agent
     * @return \StructType\AgentConract
     */
    public function setAgent(\StructType\SubjectInfo $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get agentProxy value
     * @return string|null
     */
    public function getAgentProxy()
    {
        return $this->agentProxy;
    }
    /**
     * Set agentProxy value
     * @param string $agentProxy
     * @return \StructType\AgentConract
     */
    public function setAgentProxy($agentProxy = null)
    {
        // validation for constraint: string
        if (!is_null($agentProxy) && !is_string($agentProxy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentProxy, true), gettype($agentProxy)), __LINE__);
        }
        $this->agentProxy = $agentProxy;
        return $this;
    }
}
