<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressInfo StructType
 * @subpackage Structs
 */
class AddressInfo extends AbstractStructBase
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The countryCodeOKSM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryCodeOKSM;
    /**
     * The postIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postIndex;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The district
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $district;
    /**
     * The locality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locality;
    /**
     * The localityCodeKLADR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localityCodeKLADR;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseCorps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $houseCorps;
    /**
     * The houseBuilding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $houseBuilding;
    /**
     * The flat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flat;
    /**
     * The addressText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressText;
    /**
     * The addressLat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressLat;
    /**
     * The okato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $okato;
    /**
     * Constructor method for AddressInfo
     * @uses AddressInfo::setCountry()
     * @uses AddressInfo::setCountryCodeOKSM()
     * @uses AddressInfo::setPostIndex()
     * @uses AddressInfo::setRegion()
     * @uses AddressInfo::setDistrict()
     * @uses AddressInfo::setLocality()
     * @uses AddressInfo::setLocalityCodeKLADR()
     * @uses AddressInfo::setStreet()
     * @uses AddressInfo::setHouseNumber()
     * @uses AddressInfo::setHouseCorps()
     * @uses AddressInfo::setHouseBuilding()
     * @uses AddressInfo::setFlat()
     * @uses AddressInfo::setAddressText()
     * @uses AddressInfo::setAddressLat()
     * @uses AddressInfo::setOkato()
     * @param string $country
     * @param string $countryCodeOKSM
     * @param string $postIndex
     * @param string $region
     * @param string $district
     * @param string $locality
     * @param string $localityCodeKLADR
     * @param string $street
     * @param string $houseNumber
     * @param string $houseCorps
     * @param int $houseBuilding
     * @param string $flat
     * @param string $addressText
     * @param string $addressLat
     * @param string $okato
     */
    public function __construct($country = null, $countryCodeOKSM = null, $postIndex = null, $region = null, $district = null, $locality = null, $localityCodeKLADR = null, $street = null, $houseNumber = null, $houseCorps = null, $houseBuilding = null, $flat = null, $addressText = null, $addressLat = null, $okato = null)
    {
        $this
            ->setCountry($country)
            ->setCountryCodeOKSM($countryCodeOKSM)
            ->setPostIndex($postIndex)
            ->setRegion($region)
            ->setDistrict($district)
            ->setLocality($locality)
            ->setLocalityCodeKLADR($localityCodeKLADR)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setHouseCorps($houseCorps)
            ->setHouseBuilding($houseBuilding)
            ->setFlat($flat)
            ->setAddressText($addressText)
            ->setAddressLat($addressLat)
            ->setOkato($okato);
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\AddressInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get countryCodeOKSM value
     * @return string|null
     */
    public function getCountryCodeOKSM()
    {
        return $this->countryCodeOKSM;
    }
    /**
     * Set countryCodeOKSM value
     * @param string $countryCodeOKSM
     * @return \StructType\AddressInfo
     */
    public function setCountryCodeOKSM($countryCodeOKSM = null)
    {
        // validation for constraint: string
        if (!is_null($countryCodeOKSM) && !is_string($countryCodeOKSM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCodeOKSM, true), gettype($countryCodeOKSM)), __LINE__);
        }
        $this->countryCodeOKSM = $countryCodeOKSM;
        return $this;
    }
    /**
     * Get postIndex value
     * @return string|null
     */
    public function getPostIndex()
    {
        return $this->postIndex;
    }
    /**
     * Set postIndex value
     * @param string $postIndex
     * @return \StructType\AddressInfo
     */
    public function setPostIndex($postIndex = null)
    {
        // validation for constraint: string
        if (!is_null($postIndex) && !is_string($postIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postIndex, true), gettype($postIndex)), __LINE__);
        }
        $this->postIndex = $postIndex;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\AddressInfo
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return \StructType\AddressInfo
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Get locality value
     * @return string|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @param string $locality
     * @return \StructType\AddressInfo
     */
    public function setLocality($locality = null)
    {
        // validation for constraint: string
        if (!is_null($locality) && !is_string($locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locality, true), gettype($locality)), __LINE__);
        }
        $this->locality = $locality;
        return $this;
    }
    /**
     * Get localityCodeKLADR value
     * @return string|null
     */
    public function getLocalityCodeKLADR()
    {
        return $this->localityCodeKLADR;
    }
    /**
     * Set localityCodeKLADR value
     * @param string $localityCodeKLADR
     * @return \StructType\AddressInfo
     */
    public function setLocalityCodeKLADR($localityCodeKLADR = null)
    {
        // validation for constraint: string
        if (!is_null($localityCodeKLADR) && !is_string($localityCodeKLADR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localityCodeKLADR, true), gettype($localityCodeKLADR)), __LINE__);
        }
        $this->localityCodeKLADR = $localityCodeKLADR;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\AddressInfo
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \StructType\AddressInfo
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseCorps value
     * @return string|null
     */
    public function getHouseCorps()
    {
        return $this->houseCorps;
    }
    /**
     * Set houseCorps value
     * @param string $houseCorps
     * @return \StructType\AddressInfo
     */
    public function setHouseCorps($houseCorps = null)
    {
        // validation for constraint: string
        if (!is_null($houseCorps) && !is_string($houseCorps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseCorps, true), gettype($houseCorps)), __LINE__);
        }
        $this->houseCorps = $houseCorps;
        return $this;
    }
    /**
     * Get houseBuilding value
     * @return int|null
     */
    public function getHouseBuilding()
    {
        return $this->houseBuilding;
    }
    /**
     * Set houseBuilding value
     * @param int $houseBuilding
     * @return \StructType\AddressInfo
     */
    public function setHouseBuilding($houseBuilding = null)
    {
        // validation for constraint: int
        if (!is_null($houseBuilding) && !(is_int($houseBuilding) || ctype_digit($houseBuilding))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($houseBuilding, true), gettype($houseBuilding)), __LINE__);
        }
        $this->houseBuilding = $houseBuilding;
        return $this;
    }
    /**
     * Get flat value
     * @return string|null
     */
    public function getFlat()
    {
        return $this->flat;
    }
    /**
     * Set flat value
     * @param string $flat
     * @return \StructType\AddressInfo
     */
    public function setFlat($flat = null)
    {
        // validation for constraint: string
        if (!is_null($flat) && !is_string($flat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flat, true), gettype($flat)), __LINE__);
        }
        $this->flat = $flat;
        return $this;
    }
    /**
     * Get addressText value
     * @return string|null
     */
    public function getAddressText()
    {
        return $this->addressText;
    }
    /**
     * Set addressText value
     * @param string $addressText
     * @return \StructType\AddressInfo
     */
    public function setAddressText($addressText = null)
    {
        // validation for constraint: string
        if (!is_null($addressText) && !is_string($addressText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressText, true), gettype($addressText)), __LINE__);
        }
        $this->addressText = $addressText;
        return $this;
    }
    /**
     * Get addressLat value
     * @return string|null
     */
    public function getAddressLat()
    {
        return $this->addressLat;
    }
    /**
     * Set addressLat value
     * @param string $addressLat
     * @return \StructType\AddressInfo
     */
    public function setAddressLat($addressLat = null)
    {
        // validation for constraint: string
        if (!is_null($addressLat) && !is_string($addressLat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLat, true), gettype($addressLat)), __LINE__);
        }
        $this->addressLat = $addressLat;
        return $this;
    }
    /**
     * Get okato value
     * @return string|null
     */
    public function getOkato()
    {
        return $this->okato;
    }
    /**
     * Set okato value
     * @param string $okato
     * @return \StructType\AddressInfo
     */
    public function setOkato($okato = null)
    {
        // validation for constraint: string
        if (!is_null($okato) && !is_string($okato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($okato, true), gettype($okato)), __LINE__);
        }
        $this->okato = $okato;
        return $this;
    }
}
