<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named searchPolicies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchPoliciesRequest $searchPolicies
     * @return \StructType\SearchPoliciesResponse|bool
     */
    public function searchPolicies(\StructType\SearchPoliciesRequest $searchPolicies)
    {
        try {
            $this->setResult($this->getSoapClient()->searchPolicies($searchPolicies));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SearchPoliciesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
