<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicySequence StructType
 * @subpackage Structs
 */
class PolicySequence extends AbstractStructBase
{
    /**
     * The prevId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $prevId;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * Constructor method for PolicySequence
     * @uses PolicySequence::setPrevId()
     * @uses PolicySequence::setType()
     * @param int $prevId
     * @param string $type
     */
    public function __construct($prevId = null, $type = null)
    {
        $this
            ->setPrevId($prevId)
            ->setType($type);
    }
    /**
     * Get prevId value
     * @return int|null
     */
    public function getPrevId()
    {
        return $this->prevId;
    }
    /**
     * Set prevId value
     * @param int $prevId
     * @return \StructType\PolicySequence
     */
    public function setPrevId($prevId = null)
    {
        // validation for constraint: int
        if (!is_null($prevId) && !(is_int($prevId) || ctype_digit($prevId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prevId, true), gettype($prevId)), __LINE__);
        }
        $this->prevId = $prevId;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\SequenceElementType::valueIsValid()
     * @uses \EnumType\SequenceElementType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\PolicySequence
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SequenceElementType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SequenceElementType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\SequenceElementType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
