<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Policy StructType
 * Meta information extracted from the WSDL
 * - type: tns:Policy
 * @subpackage Structs
 */
class Policy extends AbstractStructBase
{
    /**
     * The insCompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insCompanyName;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProductInfo
     */
    public $product;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The dateBeg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateBeg;
    /**
     * The dateEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateEnd;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentType;
    /**
     * The prolongation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $prolongation;
    /**
     * The prolongationPolicySeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prolongationPolicySeries;
    /**
     * The prolongationPolicyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prolongationPolicyNumber;
    /**
     * The previousInsurer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $previousInsurer;
    /**
     * The previousNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $previousNumber;
    /**
     * The previousInsComp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InsCompInfo
     */
    public $previousInsComp;
    /**
     * The prolongationPolicyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prolongationPolicyDate;
    /**
     * The policyReplacement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $policyReplacement;
    /**
     * The replacedPolicySeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacedPolicySeries;
    /**
     * The replacedPolicyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacedPolicyNumber;
    /**
     * The replacedPolicyDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacedPolicyDate;
    /**
     * The replacementDateConclusion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacementDateConclusion;
    /**
     * The replacedPolicyInsurant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacedPolicyInsurant;
    /**
     * The replacementDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replacementDate;
    /**
     * The durationDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $durationDays;
    /**
     * The insurant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectInfo
     */
    public $insurant;
    /**
     * The beneficiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectInfo
     */
    public $beneficiary;
    /**
     * The insuranceObjects
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InsuranceObjectList
     */
    public $insuranceObjects;
    /**
     * The riskInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RiskInfoList
     */
    public $riskInfo;
    /**
     * The insPremTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insPremTotal;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The specialNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specialNotes;
    /**
     * The departmentCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $departmentCode;
    /**
     * The representative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RepresentativeInfo
     */
    public $representative;
    /**
     * The currExchList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CurrencyExchList
     */
    public $currExchList;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The dealerConractInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DealerConractInfo
     */
    public $dealerConractInfo;
    /**
     * The pointOfSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PointOfSale
     */
    public $pointOfSale;
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserInfo
     */
    public $userInfo;
    /**
     * The currCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currCode;
    /**
     * The calcID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calcID;
    /**
     * The paymentsPlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentList
     */
    public $paymentsPlan;
    /**
     * The paymentsFact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentList
     */
    public $paymentsFact;
    /**
     * The discountAV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountAV;
    /**
     * The clientWithoutLoss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $clientWithoutLoss;
    /**
     * The discountUnderwriter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountUnderwriter;
    /**
     * The foulOfInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $foulOfInsurance;
    /**
     * The dateCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateCalc;
    /**
     * The internalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $internalID;
    /**
     * The insByPeriods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InsuranceByPeriodList
     */
    public $insByPeriods;
    /**
     * The manualRegistration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $manualRegistration;
    /**
     * The manualProlongation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $manualProlongation;
    /**
     * The procentAV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $procentAV;
    /**
     * The sellerSK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserInfo
     */
    public $sellerSK;
    /**
     * The sozdatelDogovora
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserInfo
     */
    public $sozdatelDogovora;
    /**
     * The marketProgrList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MarketProgrList
     */
    public $marketProgrList;
    /**
     * The additionPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $additionPayment;
    /**
     * The pechatNaBlanke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $pechatNaBlanke;
    /**
     * The reasonsForReplacement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReasonsForReplacementList
     */
    public $reasonsForReplacement;
    /**
     * The blankPolicaNomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankPolicaNomer;
    /**
     * The blankPolicaSeria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blankPolicaSeria;
    /**
     * The kvitanciaNomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kvitanciaNomer;
    /**
     * The kvitanciaSeria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kvitanciaSeria;
    /**
     * The prevWasInAnotherInsurer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $prevWasInAnotherInsurer;
    /**
     * The prevLossCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $prevLossCount;
    /**
     * The prevLossCount3dPartFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $prevLossCount3dPartFault;
    /**
     * The skidkaAvVProc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $skidkaAvVProc;
    /**
     * The skidkaKV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $skidkaKV;
    /**
     * The insurantDocType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insurantDocType;
    /**
     * The storeAvProc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $storeAvProc;
    /**
     * The additionalStoreAvProc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $additionalStoreAvProc;
    /**
     * The locality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locality;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The localityCodeKLADR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localityCodeKLADR;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PolicySequence
     */
    public $sequence;
    /**
     * The blanks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BlankList
     */
    public $blanks;
    /**
     * The policyCorrected
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $policyCorrected;
    /**
     * The correctedPolicySeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $correctedPolicySeries;
    /**
     * The correctedPolicyNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $correctedPolicyNumber;
    /**
     * The contractCreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contractCreationDate;
    /**
     * The correctedPolicyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $correctedPolicyId;
    /**
     * The replacedPolicyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $replacedPolicyId;
    /**
     * The dateIssue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateIssue;
    /**
     * The sellerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sellerCode;
    /**
     * The insurantChanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectChangesInfo
     */
    public $insurantChanges;
    /**
     * The prevWasInThisPartner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $prevWasInThisPartner;
    /**
     * The ksp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ksp;
    /**
     * The replacedPolicyNumberInChain
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $replacedPolicyNumberInChain;
    /**
     * The insurantRepresentative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectRepresentative
     */
    public $insurantRepresentative;
    /**
     * The insurantBankRequisites
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BankRequisitesList
     */
    public $insurantBankRequisites;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParametrList
     */
    public $parameters;
    /**
     * The subrogation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $subrogation;
    /**
     * The ikpCuratora
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ikpCuratora;
    /**
     * The cross
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Cross
     */
    public $cross;
    /**
     * The beneficiary2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectInfo
     */
    public $beneficiary2;
    /**
     * The signer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RepresentativeInfo
     */
    public $signer;
    /**
     * The periodOfInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $periodOfInsurance;
    /**
     * The timeUnitPeriodOfInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeUnitPeriodOfInsurance;
    /**
     * The beneficiaries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Beneficiaries
     */
    public $beneficiaries;
    /**
     * The countYearsWithoutLoss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $countYearsWithoutLoss;
    /**
     * The countInsEventsPrevPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $countInsEventsPrevPolicy;
    /**
     * The epolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $epolicy;
    /**
     * The onlinePayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $onlinePayment;
    /**
     * The stateHistoryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PolicyStateHistoryList
     */
    public $stateHistoryList;
    /**
     * The consentedToPersonalDataProcessing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $consentedToPersonalDataProcessing;
    /**
     * Constructor method for Policy
     * @uses Policy::setInsCompanyName()
     * @uses Policy::setProduct()
     * @uses Policy::setNumber()
     * @uses Policy::setDate()
     * @uses Policy::setDateBeg()
     * @uses Policy::setDateEnd()
     * @uses Policy::setState()
     * @uses Policy::setPaymentType()
     * @uses Policy::setProlongation()
     * @uses Policy::setProlongationPolicySeries()
     * @uses Policy::setProlongationPolicyNumber()
     * @uses Policy::setPreviousInsurer()
     * @uses Policy::setPreviousNumber()
     * @uses Policy::setPreviousInsComp()
     * @uses Policy::setProlongationPolicyDate()
     * @uses Policy::setPolicyReplacement()
     * @uses Policy::setReplacedPolicySeries()
     * @uses Policy::setReplacedPolicyNumber()
     * @uses Policy::setReplacedPolicyDate()
     * @uses Policy::setReplacementDateConclusion()
     * @uses Policy::setReplacedPolicyInsurant()
     * @uses Policy::setReplacementDate()
     * @uses Policy::setDurationDays()
     * @uses Policy::setInsurant()
     * @uses Policy::setBeneficiary()
     * @uses Policy::setInsuranceObjects()
     * @uses Policy::setRiskInfo()
     * @uses Policy::setInsPremTotal()
     * @uses Policy::setComment()
     * @uses Policy::setSpecialNotes()
     * @uses Policy::setDepartmentCode()
     * @uses Policy::setRepresentative()
     * @uses Policy::setCurrExchList()
     * @uses Policy::setID()
     * @uses Policy::setDealerConractInfo()
     * @uses Policy::setPointOfSale()
     * @uses Policy::setUserInfo()
     * @uses Policy::setCurrCode()
     * @uses Policy::setCalcID()
     * @uses Policy::setPaymentsPlan()
     * @uses Policy::setPaymentsFact()
     * @uses Policy::setDiscountAV()
     * @uses Policy::setClientWithoutLoss()
     * @uses Policy::setDiscountUnderwriter()
     * @uses Policy::setFoulOfInsurance()
     * @uses Policy::setDateCalc()
     * @uses Policy::setInternalID()
     * @uses Policy::setInsByPeriods()
     * @uses Policy::setManualRegistration()
     * @uses Policy::setManualProlongation()
     * @uses Policy::setProcentAV()
     * @uses Policy::setSellerSK()
     * @uses Policy::setSozdatelDogovora()
     * @uses Policy::setMarketProgrList()
     * @uses Policy::setAdditionPayment()
     * @uses Policy::setPechatNaBlanke()
     * @uses Policy::setReasonsForReplacement()
     * @uses Policy::setBlankPolicaNomer()
     * @uses Policy::setBlankPolicaSeria()
     * @uses Policy::setKvitanciaNomer()
     * @uses Policy::setKvitanciaSeria()
     * @uses Policy::setPrevWasInAnotherInsurer()
     * @uses Policy::setPrevLossCount()
     * @uses Policy::setPrevLossCount3dPartFault()
     * @uses Policy::setSkidkaAvVProc()
     * @uses Policy::setSkidkaKV()
     * @uses Policy::setInsurantDocType()
     * @uses Policy::setStoreAvProc()
     * @uses Policy::setAdditionalStoreAvProc()
     * @uses Policy::setLocality()
     * @uses Policy::setRegion()
     * @uses Policy::setLocalityCodeKLADR()
     * @uses Policy::setSequence()
     * @uses Policy::setBlanks()
     * @uses Policy::setPolicyCorrected()
     * @uses Policy::setCorrectedPolicySeries()
     * @uses Policy::setCorrectedPolicyNumber()
     * @uses Policy::setContractCreationDate()
     * @uses Policy::setCorrectedPolicyId()
     * @uses Policy::setReplacedPolicyId()
     * @uses Policy::setDateIssue()
     * @uses Policy::setSellerCode()
     * @uses Policy::setInsurantChanges()
     * @uses Policy::setPrevWasInThisPartner()
     * @uses Policy::setKsp()
     * @uses Policy::setReplacedPolicyNumberInChain()
     * @uses Policy::setInsurantRepresentative()
     * @uses Policy::setInsurantBankRequisites()
     * @uses Policy::setParameters()
     * @uses Policy::setSubrogation()
     * @uses Policy::setIkpCuratora()
     * @uses Policy::setCross()
     * @uses Policy::setBeneficiary2()
     * @uses Policy::setSigner()
     * @uses Policy::setPeriodOfInsurance()
     * @uses Policy::setTimeUnitPeriodOfInsurance()
     * @uses Policy::setBeneficiaries()
     * @uses Policy::setCountYearsWithoutLoss()
     * @uses Policy::setCountInsEventsPrevPolicy()
     * @uses Policy::setEpolicy()
     * @uses Policy::setOnlinePayment()
     * @uses Policy::setStateHistoryList()
     * @uses Policy::setConsentedToPersonalDataProcessing()
     * @param string $insCompanyName
     * @param \StructType\ProductInfo $product
     * @param string $number
     * @param string $date
     * @param string $dateBeg
     * @param string $dateEnd
     * @param string $state
     * @param string $paymentType
     * @param bool $prolongation
     * @param string $prolongationPolicySeries
     * @param string $prolongationPolicyNumber
     * @param string $previousInsurer
     * @param string $previousNumber
     * @param \StructType\InsCompInfo $previousInsComp
     * @param string $prolongationPolicyDate
     * @param bool $policyReplacement
     * @param string $replacedPolicySeries
     * @param string $replacedPolicyNumber
     * @param string $replacedPolicyDate
     * @param string $replacementDateConclusion
     * @param string $replacedPolicyInsurant
     * @param string $replacementDate
     * @param int $durationDays
     * @param \StructType\SubjectInfo $insurant
     * @param \StructType\SubjectInfo $beneficiary
     * @param \StructType\InsuranceObjectList $insuranceObjects
     * @param \StructType\RiskInfoList $riskInfo
     * @param float $insPremTotal
     * @param string $comment
     * @param string $specialNotes
     * @param string $departmentCode
     * @param \StructType\RepresentativeInfo $representative
     * @param \StructType\CurrencyExchList $currExchList
     * @param string $iD
     * @param \StructType\DealerConractInfo $dealerConractInfo
     * @param \StructType\PointOfSale $pointOfSale
     * @param \StructType\UserInfo $userInfo
     * @param string $currCode
     * @param string $calcID
     * @param \StructType\PaymentList $paymentsPlan
     * @param \StructType\PaymentList $paymentsFact
     * @param float $discountAV
     * @param bool $clientWithoutLoss
     * @param float $discountUnderwriter
     * @param bool $foulOfInsurance
     * @param string $dateCalc
     * @param int $internalID
     * @param \StructType\InsuranceByPeriodList $insByPeriods
     * @param bool $manualRegistration
     * @param bool $manualProlongation
     * @param float $procentAV
     * @param \StructType\UserInfo $sellerSK
     * @param \StructType\UserInfo $sozdatelDogovora
     * @param \StructType\MarketProgrList $marketProgrList
     * @param float $additionPayment
     * @param bool $pechatNaBlanke
     * @param \StructType\ReasonsForReplacementList $reasonsForReplacement
     * @param string $blankPolicaNomer
     * @param string $blankPolicaSeria
     * @param string $kvitanciaNomer
     * @param string $kvitanciaSeria
     * @param bool $prevWasInAnotherInsurer
     * @param int $prevLossCount
     * @param int $prevLossCount3dPartFault
     * @param bool $skidkaAvVProc
     * @param float $skidkaKV
     * @param string $insurantDocType
     * @param float $storeAvProc
     * @param float $additionalStoreAvProc
     * @param string $locality
     * @param string $region
     * @param string $localityCodeKLADR
     * @param \StructType\PolicySequence $sequence
     * @param \StructType\BlankList $blanks
     * @param bool $policyCorrected
     * @param string $correctedPolicySeries
     * @param string $correctedPolicyNumber
     * @param string $contractCreationDate
     * @param int $correctedPolicyId
     * @param int $replacedPolicyId
     * @param string $dateIssue
     * @param string $sellerCode
     * @param \StructType\SubjectChangesInfo $insurantChanges
     * @param bool $prevWasInThisPartner
     * @param float $ksp
     * @param int $replacedPolicyNumberInChain
     * @param \StructType\SubjectRepresentative $insurantRepresentative
     * @param \StructType\BankRequisitesList $insurantBankRequisites
     * @param \StructType\ParametrList $parameters
     * @param bool $subrogation
     * @param string $ikpCuratora
     * @param \StructType\Cross $cross
     * @param \StructType\SubjectInfo $beneficiary2
     * @param \StructType\RepresentativeInfo $signer
     * @param int $periodOfInsurance
     * @param string $timeUnitPeriodOfInsurance
     * @param \StructType\Beneficiaries $beneficiaries
     * @param int $countYearsWithoutLoss
     * @param int $countInsEventsPrevPolicy
     * @param bool $epolicy
     * @param bool $onlinePayment
     * @param \StructType\PolicyStateHistoryList $stateHistoryList
     * @param bool $consentedToPersonalDataProcessing
     */
    public function __construct($insCompanyName = null, \StructType\ProductInfo $product = null, $number = null, $date = null, $dateBeg = null, $dateEnd = null, $state = null, $paymentType = null, $prolongation = null, $prolongationPolicySeries = null, $prolongationPolicyNumber = null, $previousInsurer = null, $previousNumber = null, \StructType\InsCompInfo $previousInsComp = null, $prolongationPolicyDate = null, $policyReplacement = null, $replacedPolicySeries = null, $replacedPolicyNumber = null, $replacedPolicyDate = null, $replacementDateConclusion = null, $replacedPolicyInsurant = null, $replacementDate = null, $durationDays = null, \StructType\SubjectInfo $insurant = null, \StructType\SubjectInfo $beneficiary = null, \StructType\InsuranceObjectList $insuranceObjects = null, \StructType\RiskInfoList $riskInfo = null, $insPremTotal = null, $comment = null, $specialNotes = null, $departmentCode = null, \StructType\RepresentativeInfo $representative = null, \StructType\CurrencyExchList $currExchList = null, $iD = null, \StructType\DealerConractInfo $dealerConractInfo = null, \StructType\PointOfSale $pointOfSale = null, \StructType\UserInfo $userInfo = null, $currCode = null, $calcID = null, \StructType\PaymentList $paymentsPlan = null, \StructType\PaymentList $paymentsFact = null, $discountAV = null, $clientWithoutLoss = null, $discountUnderwriter = null, $foulOfInsurance = null, $dateCalc = null, $internalID = null, \StructType\InsuranceByPeriodList $insByPeriods = null, $manualRegistration = null, $manualProlongation = null, $procentAV = null, \StructType\UserInfo $sellerSK = null, \StructType\UserInfo $sozdatelDogovora = null, \StructType\MarketProgrList $marketProgrList = null, $additionPayment = null, $pechatNaBlanke = null, \StructType\ReasonsForReplacementList $reasonsForReplacement = null, $blankPolicaNomer = null, $blankPolicaSeria = null, $kvitanciaNomer = null, $kvitanciaSeria = null, $prevWasInAnotherInsurer = null, $prevLossCount = null, $prevLossCount3dPartFault = null, $skidkaAvVProc = null, $skidkaKV = null, $insurantDocType = null, $storeAvProc = null, $additionalStoreAvProc = null, $locality = null, $region = null, $localityCodeKLADR = null, \StructType\PolicySequence $sequence = null, \StructType\BlankList $blanks = null, $policyCorrected = null, $correctedPolicySeries = null, $correctedPolicyNumber = null, $contractCreationDate = null, $correctedPolicyId = null, $replacedPolicyId = null, $dateIssue = null, $sellerCode = null, \StructType\SubjectChangesInfo $insurantChanges = null, $prevWasInThisPartner = null, $ksp = null, $replacedPolicyNumberInChain = null, \StructType\SubjectRepresentative $insurantRepresentative = null, \StructType\BankRequisitesList $insurantBankRequisites = null, \StructType\ParametrList $parameters = null, $subrogation = null, $ikpCuratora = null, \StructType\Cross $cross = null, \StructType\SubjectInfo $beneficiary2 = null, \StructType\RepresentativeInfo $signer = null, $periodOfInsurance = null, $timeUnitPeriodOfInsurance = null, \StructType\Beneficiaries $beneficiaries = null, $countYearsWithoutLoss = null, $countInsEventsPrevPolicy = null, $epolicy = null, $onlinePayment = null, \StructType\PolicyStateHistoryList $stateHistoryList = null, $consentedToPersonalDataProcessing = null)
    {
        $this
            ->setInsCompanyName($insCompanyName)
            ->setProduct($product)
            ->setNumber($number)
            ->setDate($date)
            ->setDateBeg($dateBeg)
            ->setDateEnd($dateEnd)
            ->setState($state)
            ->setPaymentType($paymentType)
            ->setProlongation($prolongation)
            ->setProlongationPolicySeries($prolongationPolicySeries)
            ->setProlongationPolicyNumber($prolongationPolicyNumber)
            ->setPreviousInsurer($previousInsurer)
            ->setPreviousNumber($previousNumber)
            ->setPreviousInsComp($previousInsComp)
            ->setProlongationPolicyDate($prolongationPolicyDate)
            ->setPolicyReplacement($policyReplacement)
            ->setReplacedPolicySeries($replacedPolicySeries)
            ->setReplacedPolicyNumber($replacedPolicyNumber)
            ->setReplacedPolicyDate($replacedPolicyDate)
            ->setReplacementDateConclusion($replacementDateConclusion)
            ->setReplacedPolicyInsurant($replacedPolicyInsurant)
            ->setReplacementDate($replacementDate)
            ->setDurationDays($durationDays)
            ->setInsurant($insurant)
            ->setBeneficiary($beneficiary)
            ->setInsuranceObjects($insuranceObjects)
            ->setRiskInfo($riskInfo)
            ->setInsPremTotal($insPremTotal)
            ->setComment($comment)
            ->setSpecialNotes($specialNotes)
            ->setDepartmentCode($departmentCode)
            ->setRepresentative($representative)
            ->setCurrExchList($currExchList)
            ->setID($iD)
            ->setDealerConractInfo($dealerConractInfo)
            ->setPointOfSale($pointOfSale)
            ->setUserInfo($userInfo)
            ->setCurrCode($currCode)
            ->setCalcID($calcID)
            ->setPaymentsPlan($paymentsPlan)
            ->setPaymentsFact($paymentsFact)
            ->setDiscountAV($discountAV)
            ->setClientWithoutLoss($clientWithoutLoss)
            ->setDiscountUnderwriter($discountUnderwriter)
            ->setFoulOfInsurance($foulOfInsurance)
            ->setDateCalc($dateCalc)
            ->setInternalID($internalID)
            ->setInsByPeriods($insByPeriods)
            ->setManualRegistration($manualRegistration)
            ->setManualProlongation($manualProlongation)
            ->setProcentAV($procentAV)
            ->setSellerSK($sellerSK)
            ->setSozdatelDogovora($sozdatelDogovora)
            ->setMarketProgrList($marketProgrList)
            ->setAdditionPayment($additionPayment)
            ->setPechatNaBlanke($pechatNaBlanke)
            ->setReasonsForReplacement($reasonsForReplacement)
            ->setBlankPolicaNomer($blankPolicaNomer)
            ->setBlankPolicaSeria($blankPolicaSeria)
            ->setKvitanciaNomer($kvitanciaNomer)
            ->setKvitanciaSeria($kvitanciaSeria)
            ->setPrevWasInAnotherInsurer($prevWasInAnotherInsurer)
            ->setPrevLossCount($prevLossCount)
            ->setPrevLossCount3dPartFault($prevLossCount3dPartFault)
            ->setSkidkaAvVProc($skidkaAvVProc)
            ->setSkidkaKV($skidkaKV)
            ->setInsurantDocType($insurantDocType)
            ->setStoreAvProc($storeAvProc)
            ->setAdditionalStoreAvProc($additionalStoreAvProc)
            ->setLocality($locality)
            ->setRegion($region)
            ->setLocalityCodeKLADR($localityCodeKLADR)
            ->setSequence($sequence)
            ->setBlanks($blanks)
            ->setPolicyCorrected($policyCorrected)
            ->setCorrectedPolicySeries($correctedPolicySeries)
            ->setCorrectedPolicyNumber($correctedPolicyNumber)
            ->setContractCreationDate($contractCreationDate)
            ->setCorrectedPolicyId($correctedPolicyId)
            ->setReplacedPolicyId($replacedPolicyId)
            ->setDateIssue($dateIssue)
            ->setSellerCode($sellerCode)
            ->setInsurantChanges($insurantChanges)
            ->setPrevWasInThisPartner($prevWasInThisPartner)
            ->setKsp($ksp)
            ->setReplacedPolicyNumberInChain($replacedPolicyNumberInChain)
            ->setInsurantRepresentative($insurantRepresentative)
            ->setInsurantBankRequisites($insurantBankRequisites)
            ->setParameters($parameters)
            ->setSubrogation($subrogation)
            ->setIkpCuratora($ikpCuratora)
            ->setCross($cross)
            ->setBeneficiary2($beneficiary2)
            ->setSigner($signer)
            ->setPeriodOfInsurance($periodOfInsurance)
            ->setTimeUnitPeriodOfInsurance($timeUnitPeriodOfInsurance)
            ->setBeneficiaries($beneficiaries)
            ->setCountYearsWithoutLoss($countYearsWithoutLoss)
            ->setCountInsEventsPrevPolicy($countInsEventsPrevPolicy)
            ->setEpolicy($epolicy)
            ->setOnlinePayment($onlinePayment)
            ->setStateHistoryList($stateHistoryList)
            ->setConsentedToPersonalDataProcessing($consentedToPersonalDataProcessing);
    }
    /**
     * Get insCompanyName value
     * @return string|null
     */
    public function getInsCompanyName()
    {
        return $this->insCompanyName;
    }
    /**
     * Set insCompanyName value
     * @param string $insCompanyName
     * @return \StructType\Policy
     */
    public function setInsCompanyName($insCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($insCompanyName) && !is_string($insCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insCompanyName, true), gettype($insCompanyName)), __LINE__);
        }
        $this->insCompanyName = $insCompanyName;
        return $this;
    }
    /**
     * Get product value
     * @return \StructType\ProductInfo|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\ProductInfo $product
     * @return \StructType\Policy
     */
    public function setProduct(\StructType\ProductInfo $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\Policy
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\Policy
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get dateBeg value
     * @return string|null
     */
    public function getDateBeg()
    {
        return $this->dateBeg;
    }
    /**
     * Set dateBeg value
     * @param string $dateBeg
     * @return \StructType\Policy
     */
    public function setDateBeg($dateBeg = null)
    {
        // validation for constraint: string
        if (!is_null($dateBeg) && !is_string($dateBeg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateBeg, true), gettype($dateBeg)), __LINE__);
        }
        $this->dateBeg = $dateBeg;
        return $this;
    }
    /**
     * Get dateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->dateEnd;
    }
    /**
     * Set dateEnd value
     * @param string $dateEnd
     * @return \StructType\Policy
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEnd, true), gettype($dateEnd)), __LINE__);
        }
        $this->dateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\Policy
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get paymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param string $paymentType
     * @return \StructType\Policy
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get prolongation value
     * @return bool|null
     */
    public function getProlongation()
    {
        return $this->prolongation;
    }
    /**
     * Set prolongation value
     * @param bool $prolongation
     * @return \StructType\Policy
     */
    public function setProlongation($prolongation = null)
    {
        // validation for constraint: boolean
        if (!is_null($prolongation) && !is_bool($prolongation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prolongation, true), gettype($prolongation)), __LINE__);
        }
        $this->prolongation = $prolongation;
        return $this;
    }
    /**
     * Get prolongationPolicySeries value
     * @return string|null
     */
    public function getProlongationPolicySeries()
    {
        return $this->prolongationPolicySeries;
    }
    /**
     * Set prolongationPolicySeries value
     * @param string $prolongationPolicySeries
     * @return \StructType\Policy
     */
    public function setProlongationPolicySeries($prolongationPolicySeries = null)
    {
        // validation for constraint: string
        if (!is_null($prolongationPolicySeries) && !is_string($prolongationPolicySeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prolongationPolicySeries, true), gettype($prolongationPolicySeries)), __LINE__);
        }
        $this->prolongationPolicySeries = $prolongationPolicySeries;
        return $this;
    }
    /**
     * Get prolongationPolicyNumber value
     * @return string|null
     */
    public function getProlongationPolicyNumber()
    {
        return $this->prolongationPolicyNumber;
    }
    /**
     * Set prolongationPolicyNumber value
     * @param string $prolongationPolicyNumber
     * @return \StructType\Policy
     */
    public function setProlongationPolicyNumber($prolongationPolicyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($prolongationPolicyNumber) && !is_string($prolongationPolicyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prolongationPolicyNumber, true), gettype($prolongationPolicyNumber)), __LINE__);
        }
        $this->prolongationPolicyNumber = $prolongationPolicyNumber;
        return $this;
    }
    /**
     * Get previousInsurer value
     * @return string|null
     */
    public function getPreviousInsurer()
    {
        return $this->previousInsurer;
    }
    /**
     * Set previousInsurer value
     * @param string $previousInsurer
     * @return \StructType\Policy
     */
    public function setPreviousInsurer($previousInsurer = null)
    {
        // validation for constraint: string
        if (!is_null($previousInsurer) && !is_string($previousInsurer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousInsurer, true), gettype($previousInsurer)), __LINE__);
        }
        $this->previousInsurer = $previousInsurer;
        return $this;
    }
    /**
     * Get previousNumber value
     * @return string|null
     */
    public function getPreviousNumber()
    {
        return $this->previousNumber;
    }
    /**
     * Set previousNumber value
     * @param string $previousNumber
     * @return \StructType\Policy
     */
    public function setPreviousNumber($previousNumber = null)
    {
        // validation for constraint: string
        if (!is_null($previousNumber) && !is_string($previousNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousNumber, true), gettype($previousNumber)), __LINE__);
        }
        $this->previousNumber = $previousNumber;
        return $this;
    }
    /**
     * Get previousInsComp value
     * @return \StructType\InsCompInfo|null
     */
    public function getPreviousInsComp()
    {
        return $this->previousInsComp;
    }
    /**
     * Set previousInsComp value
     * @param \StructType\InsCompInfo $previousInsComp
     * @return \StructType\Policy
     */
    public function setPreviousInsComp(\StructType\InsCompInfo $previousInsComp = null)
    {
        $this->previousInsComp = $previousInsComp;
        return $this;
    }
    /**
     * Get prolongationPolicyDate value
     * @return string|null
     */
    public function getProlongationPolicyDate()
    {
        return $this->prolongationPolicyDate;
    }
    /**
     * Set prolongationPolicyDate value
     * @param string $prolongationPolicyDate
     * @return \StructType\Policy
     */
    public function setProlongationPolicyDate($prolongationPolicyDate = null)
    {
        // validation for constraint: string
        if (!is_null($prolongationPolicyDate) && !is_string($prolongationPolicyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prolongationPolicyDate, true), gettype($prolongationPolicyDate)), __LINE__);
        }
        $this->prolongationPolicyDate = $prolongationPolicyDate;
        return $this;
    }
    /**
     * Get policyReplacement value
     * @return bool|null
     */
    public function getPolicyReplacement()
    {
        return $this->policyReplacement;
    }
    /**
     * Set policyReplacement value
     * @param bool $policyReplacement
     * @return \StructType\Policy
     */
    public function setPolicyReplacement($policyReplacement = null)
    {
        // validation for constraint: boolean
        if (!is_null($policyReplacement) && !is_bool($policyReplacement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($policyReplacement, true), gettype($policyReplacement)), __LINE__);
        }
        $this->policyReplacement = $policyReplacement;
        return $this;
    }
    /**
     * Get replacedPolicySeries value
     * @return string|null
     */
    public function getReplacedPolicySeries()
    {
        return $this->replacedPolicySeries;
    }
    /**
     * Set replacedPolicySeries value
     * @param string $replacedPolicySeries
     * @return \StructType\Policy
     */
    public function setReplacedPolicySeries($replacedPolicySeries = null)
    {
        // validation for constraint: string
        if (!is_null($replacedPolicySeries) && !is_string($replacedPolicySeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replacedPolicySeries, true), gettype($replacedPolicySeries)), __LINE__);
        }
        $this->replacedPolicySeries = $replacedPolicySeries;
        return $this;
    }
    /**
     * Get replacedPolicyNumber value
     * @return string|null
     */
    public function getReplacedPolicyNumber()
    {
        return $this->replacedPolicyNumber;
    }
    /**
     * Set replacedPolicyNumber value
     * @param string $replacedPolicyNumber
     * @return \StructType\Policy
     */
    public function setReplacedPolicyNumber($replacedPolicyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($replacedPolicyNumber) && !is_string($replacedPolicyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replacedPolicyNumber, true), gettype($replacedPolicyNumber)), __LINE__);
        }
        $this->replacedPolicyNumber = $replacedPolicyNumber;
        return $this;
    }
    /**
     * Get replacedPolicyDate value
     * @return string|null
     */
    public function getReplacedPolicyDate()
    {
        return $this->replacedPolicyDate;
    }
    /**
     * Set replacedPolicyDate value
     * @param string $replacedPolicyDate
     * @return \StructType\Policy
     */
    public function setReplacedPolicyDate($replacedPolicyDate = null)
    {
        // validation for constraint: string
        if (!is_null($replacedPolicyDate) && !is_string($replacedPolicyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replacedPolicyDate, true), gettype($replacedPolicyDate)), __LINE__);
        }
        $this->replacedPolicyDate = $replacedPolicyDate;
        return $this;
    }
    /**
     * Get replacementDateConclusion value
     * @return string|null
     */
    public function getReplacementDateConclusion()
    {
        return $this->replacementDateConclusion;
    }
    /**
     * Set replacementDateConclusion value
     * @param string $replacementDateConclusion
     * @return \StructType\Policy
     */
    public function setReplacementDateConclusion($replacementDateConclusion = null)
    {
        // validation for constraint: string
        if (!is_null($replacementDateConclusion) && !is_string($replacementDateConclusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replacementDateConclusion, true), gettype($replacementDateConclusion)), __LINE__);
        }
        $this->replacementDateConclusion = $replacementDateConclusion;
        return $this;
    }
    /**
     * Get replacedPolicyInsurant value
     * @return string|null
     */
    public function getReplacedPolicyInsurant()
    {
        return $this->replacedPolicyInsurant;
    }
    /**
     * Set replacedPolicyInsurant value
     * @param string $replacedPolicyInsurant
     * @return \StructType\Policy
     */
    public function setReplacedPolicyInsurant($replacedPolicyInsurant = null)
    {
        // validation for constraint: string
        if (!is_null($replacedPolicyInsurant) && !is_string($replacedPolicyInsurant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replacedPolicyInsurant, true), gettype($replacedPolicyInsurant)), __LINE__);
        }
        $this->replacedPolicyInsurant = $replacedPolicyInsurant;
        return $this;
    }
    /**
     * Get replacementDate value
     * @return string|null
     */
    public function getReplacementDate()
    {
        return $this->replacementDate;
    }
    /**
     * Set replacementDate value
     * @param string $replacementDate
     * @return \StructType\Policy
     */
    public function setReplacementDate($replacementDate = null)
    {
        // validation for constraint: string
        if (!is_null($replacementDate) && !is_string($replacementDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replacementDate, true), gettype($replacementDate)), __LINE__);
        }
        $this->replacementDate = $replacementDate;
        return $this;
    }
    /**
     * Get durationDays value
     * @return int|null
     */
    public function getDurationDays()
    {
        return $this->durationDays;
    }
    /**
     * Set durationDays value
     * @param int $durationDays
     * @return \StructType\Policy
     */
    public function setDurationDays($durationDays = null)
    {
        // validation for constraint: int
        if (!is_null($durationDays) && !(is_int($durationDays) || ctype_digit($durationDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationDays, true), gettype($durationDays)), __LINE__);
        }
        $this->durationDays = $durationDays;
        return $this;
    }
    /**
     * Get insurant value
     * @return \StructType\SubjectInfo|null
     */
    public function getInsurant()
    {
        return $this->insurant;
    }
    /**
     * Set insurant value
     * @param \StructType\SubjectInfo $insurant
     * @return \StructType\Policy
     */
    public function setInsurant(\StructType\SubjectInfo $insurant = null)
    {
        $this->insurant = $insurant;
        return $this;
    }
    /**
     * Get beneficiary value
     * @return \StructType\SubjectInfo|null
     */
    public function getBeneficiary()
    {
        return $this->beneficiary;
    }
    /**
     * Set beneficiary value
     * @param \StructType\SubjectInfo $beneficiary
     * @return \StructType\Policy
     */
    public function setBeneficiary(\StructType\SubjectInfo $beneficiary = null)
    {
        $this->beneficiary = $beneficiary;
        return $this;
    }
    /**
     * Get insuranceObjects value
     * @return \StructType\InsuranceObjectList|null
     */
    public function getInsuranceObjects()
    {
        return $this->insuranceObjects;
    }
    /**
     * Set insuranceObjects value
     * @param \StructType\InsuranceObjectList $insuranceObjects
     * @return \StructType\Policy
     */
    public function setInsuranceObjects(\StructType\InsuranceObjectList $insuranceObjects = null)
    {
        $this->insuranceObjects = $insuranceObjects;
        return $this;
    }
    /**
     * Get riskInfo value
     * @return \StructType\RiskInfoList|null
     */
    public function getRiskInfo()
    {
        return $this->riskInfo;
    }
    /**
     * Set riskInfo value
     * @param \StructType\RiskInfoList $riskInfo
     * @return \StructType\Policy
     */
    public function setRiskInfo(\StructType\RiskInfoList $riskInfo = null)
    {
        $this->riskInfo = $riskInfo;
        return $this;
    }
    /**
     * Get insPremTotal value
     * @return float|null
     */
    public function getInsPremTotal()
    {
        return $this->insPremTotal;
    }
    /**
     * Set insPremTotal value
     * @param float $insPremTotal
     * @return \StructType\Policy
     */
    public function setInsPremTotal($insPremTotal = null)
    {
        // validation for constraint: float
        if (!is_null($insPremTotal) && !(is_float($insPremTotal) || is_numeric($insPremTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insPremTotal, true), gettype($insPremTotal)), __LINE__);
        }
        $this->insPremTotal = $insPremTotal;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\Policy
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get specialNotes value
     * @return string|null
     */
    public function getSpecialNotes()
    {
        return $this->specialNotes;
    }
    /**
     * Set specialNotes value
     * @param string $specialNotes
     * @return \StructType\Policy
     */
    public function setSpecialNotes($specialNotes = null)
    {
        // validation for constraint: string
        if (!is_null($specialNotes) && !is_string($specialNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialNotes, true), gettype($specialNotes)), __LINE__);
        }
        $this->specialNotes = $specialNotes;
        return $this;
    }
    /**
     * Get departmentCode value
     * @return string|null
     */
    public function getDepartmentCode()
    {
        return $this->departmentCode;
    }
    /**
     * Set departmentCode value
     * @param string $departmentCode
     * @return \StructType\Policy
     */
    public function setDepartmentCode($departmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($departmentCode) && !is_string($departmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departmentCode, true), gettype($departmentCode)), __LINE__);
        }
        $this->departmentCode = $departmentCode;
        return $this;
    }
    /**
     * Get representative value
     * @return \StructType\RepresentativeInfo|null
     */
    public function getRepresentative()
    {
        return $this->representative;
    }
    /**
     * Set representative value
     * @param \StructType\RepresentativeInfo $representative
     * @return \StructType\Policy
     */
    public function setRepresentative(\StructType\RepresentativeInfo $representative = null)
    {
        $this->representative = $representative;
        return $this;
    }
    /**
     * Get currExchList value
     * @return \StructType\CurrencyExchList|null
     */
    public function getCurrExchList()
    {
        return $this->currExchList;
    }
    /**
     * Set currExchList value
     * @param \StructType\CurrencyExchList $currExchList
     * @return \StructType\Policy
     */
    public function setCurrExchList(\StructType\CurrencyExchList $currExchList = null)
    {
        $this->currExchList = $currExchList;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Policy
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get dealerConractInfo value
     * @return \StructType\DealerConractInfo|null
     */
    public function getDealerConractInfo()
    {
        return $this->dealerConractInfo;
    }
    /**
     * Set dealerConractInfo value
     * @param \StructType\DealerConractInfo $dealerConractInfo
     * @return \StructType\Policy
     */
    public function setDealerConractInfo(\StructType\DealerConractInfo $dealerConractInfo = null)
    {
        $this->dealerConractInfo = $dealerConractInfo;
        return $this;
    }
    /**
     * Get pointOfSale value
     * @return \StructType\PointOfSale|null
     */
    public function getPointOfSale()
    {
        return $this->pointOfSale;
    }
    /**
     * Set pointOfSale value
     * @param \StructType\PointOfSale $pointOfSale
     * @return \StructType\Policy
     */
    public function setPointOfSale(\StructType\PointOfSale $pointOfSale = null)
    {
        $this->pointOfSale = $pointOfSale;
        return $this;
    }
    /**
     * Get userInfo value
     * @return \StructType\UserInfo|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \StructType\UserInfo $userInfo
     * @return \StructType\Policy
     */
    public function setUserInfo(\StructType\UserInfo $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get currCode value
     * @return string|null
     */
    public function getCurrCode()
    {
        return $this->currCode;
    }
    /**
     * Set currCode value
     * @param string $currCode
     * @return \StructType\Policy
     */
    public function setCurrCode($currCode = null)
    {
        // validation for constraint: string
        if (!is_null($currCode) && !is_string($currCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currCode, true), gettype($currCode)), __LINE__);
        }
        $this->currCode = $currCode;
        return $this;
    }
    /**
     * Get calcID value
     * @return string|null
     */
    public function getCalcID()
    {
        return $this->calcID;
    }
    /**
     * Set calcID value
     * @param string $calcID
     * @return \StructType\Policy
     */
    public function setCalcID($calcID = null)
    {
        // validation for constraint: string
        if (!is_null($calcID) && !is_string($calcID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calcID, true), gettype($calcID)), __LINE__);
        }
        $this->calcID = $calcID;
        return $this;
    }
    /**
     * Get paymentsPlan value
     * @return \StructType\PaymentList|null
     */
    public function getPaymentsPlan()
    {
        return $this->paymentsPlan;
    }
    /**
     * Set paymentsPlan value
     * @param \StructType\PaymentList $paymentsPlan
     * @return \StructType\Policy
     */
    public function setPaymentsPlan(\StructType\PaymentList $paymentsPlan = null)
    {
        $this->paymentsPlan = $paymentsPlan;
        return $this;
    }
    /**
     * Get paymentsFact value
     * @return \StructType\PaymentList|null
     */
    public function getPaymentsFact()
    {
        return $this->paymentsFact;
    }
    /**
     * Set paymentsFact value
     * @param \StructType\PaymentList $paymentsFact
     * @return \StructType\Policy
     */
    public function setPaymentsFact(\StructType\PaymentList $paymentsFact = null)
    {
        $this->paymentsFact = $paymentsFact;
        return $this;
    }
    /**
     * Get discountAV value
     * @return float|null
     */
    public function getDiscountAV()
    {
        return $this->discountAV;
    }
    /**
     * Set discountAV value
     * @param float $discountAV
     * @return \StructType\Policy
     */
    public function setDiscountAV($discountAV = null)
    {
        // validation for constraint: float
        if (!is_null($discountAV) && !(is_float($discountAV) || is_numeric($discountAV))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAV, true), gettype($discountAV)), __LINE__);
        }
        $this->discountAV = $discountAV;
        return $this;
    }
    /**
     * Get clientWithoutLoss value
     * @return bool|null
     */
    public function getClientWithoutLoss()
    {
        return $this->clientWithoutLoss;
    }
    /**
     * Set clientWithoutLoss value
     * @param bool $clientWithoutLoss
     * @return \StructType\Policy
     */
    public function setClientWithoutLoss($clientWithoutLoss = null)
    {
        // validation for constraint: boolean
        if (!is_null($clientWithoutLoss) && !is_bool($clientWithoutLoss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($clientWithoutLoss, true), gettype($clientWithoutLoss)), __LINE__);
        }
        $this->clientWithoutLoss = $clientWithoutLoss;
        return $this;
    }
    /**
     * Get discountUnderwriter value
     * @return float|null
     */
    public function getDiscountUnderwriter()
    {
        return $this->discountUnderwriter;
    }
    /**
     * Set discountUnderwriter value
     * @param float $discountUnderwriter
     * @return \StructType\Policy
     */
    public function setDiscountUnderwriter($discountUnderwriter = null)
    {
        // validation for constraint: float
        if (!is_null($discountUnderwriter) && !(is_float($discountUnderwriter) || is_numeric($discountUnderwriter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountUnderwriter, true), gettype($discountUnderwriter)), __LINE__);
        }
        $this->discountUnderwriter = $discountUnderwriter;
        return $this;
    }
    /**
     * Get foulOfInsurance value
     * @return bool|null
     */
    public function getFoulOfInsurance()
    {
        return $this->foulOfInsurance;
    }
    /**
     * Set foulOfInsurance value
     * @param bool $foulOfInsurance
     * @return \StructType\Policy
     */
    public function setFoulOfInsurance($foulOfInsurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($foulOfInsurance) && !is_bool($foulOfInsurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($foulOfInsurance, true), gettype($foulOfInsurance)), __LINE__);
        }
        $this->foulOfInsurance = $foulOfInsurance;
        return $this;
    }
    /**
     * Get dateCalc value
     * @return string|null
     */
    public function getDateCalc()
    {
        return $this->dateCalc;
    }
    /**
     * Set dateCalc value
     * @param string $dateCalc
     * @return \StructType\Policy
     */
    public function setDateCalc($dateCalc = null)
    {
        // validation for constraint: string
        if (!is_null($dateCalc) && !is_string($dateCalc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCalc, true), gettype($dateCalc)), __LINE__);
        }
        $this->dateCalc = $dateCalc;
        return $this;
    }
    /**
     * Get internalID value
     * @return int|null
     */
    public function getInternalID()
    {
        return $this->internalID;
    }
    /**
     * Set internalID value
     * @param int $internalID
     * @return \StructType\Policy
     */
    public function setInternalID($internalID = null)
    {
        // validation for constraint: int
        if (!is_null($internalID) && !(is_int($internalID) || ctype_digit($internalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalID, true), gettype($internalID)), __LINE__);
        }
        $this->internalID = $internalID;
        return $this;
    }
    /**
     * Get insByPeriods value
     * @return \StructType\InsuranceByPeriodList|null
     */
    public function getInsByPeriods()
    {
        return $this->insByPeriods;
    }
    /**
     * Set insByPeriods value
     * @param \StructType\InsuranceByPeriodList $insByPeriods
     * @return \StructType\Policy
     */
    public function setInsByPeriods(\StructType\InsuranceByPeriodList $insByPeriods = null)
    {
        $this->insByPeriods = $insByPeriods;
        return $this;
    }
    /**
     * Get manualRegistration value
     * @return bool|null
     */
    public function getManualRegistration()
    {
        return $this->manualRegistration;
    }
    /**
     * Set manualRegistration value
     * @param bool $manualRegistration
     * @return \StructType\Policy
     */
    public function setManualRegistration($manualRegistration = null)
    {
        // validation for constraint: boolean
        if (!is_null($manualRegistration) && !is_bool($manualRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manualRegistration, true), gettype($manualRegistration)), __LINE__);
        }
        $this->manualRegistration = $manualRegistration;
        return $this;
    }
    /**
     * Get manualProlongation value
     * @return bool|null
     */
    public function getManualProlongation()
    {
        return $this->manualProlongation;
    }
    /**
     * Set manualProlongation value
     * @param bool $manualProlongation
     * @return \StructType\Policy
     */
    public function setManualProlongation($manualProlongation = null)
    {
        // validation for constraint: boolean
        if (!is_null($manualProlongation) && !is_bool($manualProlongation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manualProlongation, true), gettype($manualProlongation)), __LINE__);
        }
        $this->manualProlongation = $manualProlongation;
        return $this;
    }
    /**
     * Get procentAV value
     * @return float|null
     */
    public function getProcentAV()
    {
        return $this->procentAV;
    }
    /**
     * Set procentAV value
     * @param float $procentAV
     * @return \StructType\Policy
     */
    public function setProcentAV($procentAV = null)
    {
        // validation for constraint: float
        if (!is_null($procentAV) && !(is_float($procentAV) || is_numeric($procentAV))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($procentAV, true), gettype($procentAV)), __LINE__);
        }
        $this->procentAV = $procentAV;
        return $this;
    }
    /**
     * Get sellerSK value
     * @return \StructType\UserInfo|null
     */
    public function getSellerSK()
    {
        return $this->sellerSK;
    }
    /**
     * Set sellerSK value
     * @param \StructType\UserInfo $sellerSK
     * @return \StructType\Policy
     */
    public function setSellerSK(\StructType\UserInfo $sellerSK = null)
    {
        $this->sellerSK = $sellerSK;
        return $this;
    }
    /**
     * Get sozdatelDogovora value
     * @return \StructType\UserInfo|null
     */
    public function getSozdatelDogovora()
    {
        return $this->sozdatelDogovora;
    }
    /**
     * Set sozdatelDogovora value
     * @param \StructType\UserInfo $sozdatelDogovora
     * @return \StructType\Policy
     */
    public function setSozdatelDogovora(\StructType\UserInfo $sozdatelDogovora = null)
    {
        $this->sozdatelDogovora = $sozdatelDogovora;
        return $this;
    }
    /**
     * Get marketProgrList value
     * @return \StructType\MarketProgrList|null
     */
    public function getMarketProgrList()
    {
        return $this->marketProgrList;
    }
    /**
     * Set marketProgrList value
     * @param \StructType\MarketProgrList $marketProgrList
     * @return \StructType\Policy
     */
    public function setMarketProgrList(\StructType\MarketProgrList $marketProgrList = null)
    {
        $this->marketProgrList = $marketProgrList;
        return $this;
    }
    /**
     * Get additionPayment value
     * @return float|null
     */
    public function getAdditionPayment()
    {
        return $this->additionPayment;
    }
    /**
     * Set additionPayment value
     * @param float $additionPayment
     * @return \StructType\Policy
     */
    public function setAdditionPayment($additionPayment = null)
    {
        // validation for constraint: float
        if (!is_null($additionPayment) && !(is_float($additionPayment) || is_numeric($additionPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($additionPayment, true), gettype($additionPayment)), __LINE__);
        }
        $this->additionPayment = $additionPayment;
        return $this;
    }
    /**
     * Get pechatNaBlanke value
     * @return bool|null
     */
    public function getPechatNaBlanke()
    {
        return $this->pechatNaBlanke;
    }
    /**
     * Set pechatNaBlanke value
     * @param bool $pechatNaBlanke
     * @return \StructType\Policy
     */
    public function setPechatNaBlanke($pechatNaBlanke = null)
    {
        // validation for constraint: boolean
        if (!is_null($pechatNaBlanke) && !is_bool($pechatNaBlanke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pechatNaBlanke, true), gettype($pechatNaBlanke)), __LINE__);
        }
        $this->pechatNaBlanke = $pechatNaBlanke;
        return $this;
    }
    /**
     * Get reasonsForReplacement value
     * @return \StructType\ReasonsForReplacementList|null
     */
    public function getReasonsForReplacement()
    {
        return $this->reasonsForReplacement;
    }
    /**
     * Set reasonsForReplacement value
     * @param \StructType\ReasonsForReplacementList $reasonsForReplacement
     * @return \StructType\Policy
     */
    public function setReasonsForReplacement(\StructType\ReasonsForReplacementList $reasonsForReplacement = null)
    {
        $this->reasonsForReplacement = $reasonsForReplacement;
        return $this;
    }
    /**
     * Get blankPolicaNomer value
     * @return string|null
     */
    public function getBlankPolicaNomer()
    {
        return $this->blankPolicaNomer;
    }
    /**
     * Set blankPolicaNomer value
     * @param string $blankPolicaNomer
     * @return \StructType\Policy
     */
    public function setBlankPolicaNomer($blankPolicaNomer = null)
    {
        // validation for constraint: string
        if (!is_null($blankPolicaNomer) && !is_string($blankPolicaNomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankPolicaNomer, true), gettype($blankPolicaNomer)), __LINE__);
        }
        $this->blankPolicaNomer = $blankPolicaNomer;
        return $this;
    }
    /**
     * Get blankPolicaSeria value
     * @return string|null
     */
    public function getBlankPolicaSeria()
    {
        return $this->blankPolicaSeria;
    }
    /**
     * Set blankPolicaSeria value
     * @param string $blankPolicaSeria
     * @return \StructType\Policy
     */
    public function setBlankPolicaSeria($blankPolicaSeria = null)
    {
        // validation for constraint: string
        if (!is_null($blankPolicaSeria) && !is_string($blankPolicaSeria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blankPolicaSeria, true), gettype($blankPolicaSeria)), __LINE__);
        }
        $this->blankPolicaSeria = $blankPolicaSeria;
        return $this;
    }
    /**
     * Get kvitanciaNomer value
     * @return string|null
     */
    public function getKvitanciaNomer()
    {
        return $this->kvitanciaNomer;
    }
    /**
     * Set kvitanciaNomer value
     * @param string $kvitanciaNomer
     * @return \StructType\Policy
     */
    public function setKvitanciaNomer($kvitanciaNomer = null)
    {
        // validation for constraint: string
        if (!is_null($kvitanciaNomer) && !is_string($kvitanciaNomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kvitanciaNomer, true), gettype($kvitanciaNomer)), __LINE__);
        }
        $this->kvitanciaNomer = $kvitanciaNomer;
        return $this;
    }
    /**
     * Get kvitanciaSeria value
     * @return string|null
     */
    public function getKvitanciaSeria()
    {
        return $this->kvitanciaSeria;
    }
    /**
     * Set kvitanciaSeria value
     * @param string $kvitanciaSeria
     * @return \StructType\Policy
     */
    public function setKvitanciaSeria($kvitanciaSeria = null)
    {
        // validation for constraint: string
        if (!is_null($kvitanciaSeria) && !is_string($kvitanciaSeria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kvitanciaSeria, true), gettype($kvitanciaSeria)), __LINE__);
        }
        $this->kvitanciaSeria = $kvitanciaSeria;
        return $this;
    }
    /**
     * Get prevWasInAnotherInsurer value
     * @return bool|null
     */
    public function getPrevWasInAnotherInsurer()
    {
        return $this->prevWasInAnotherInsurer;
    }
    /**
     * Set prevWasInAnotherInsurer value
     * @param bool $prevWasInAnotherInsurer
     * @return \StructType\Policy
     */
    public function setPrevWasInAnotherInsurer($prevWasInAnotherInsurer = null)
    {
        // validation for constraint: boolean
        if (!is_null($prevWasInAnotherInsurer) && !is_bool($prevWasInAnotherInsurer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prevWasInAnotherInsurer, true), gettype($prevWasInAnotherInsurer)), __LINE__);
        }
        $this->prevWasInAnotherInsurer = $prevWasInAnotherInsurer;
        return $this;
    }
    /**
     * Get prevLossCount value
     * @return int|null
     */
    public function getPrevLossCount()
    {
        return $this->prevLossCount;
    }
    /**
     * Set prevLossCount value
     * @param int $prevLossCount
     * @return \StructType\Policy
     */
    public function setPrevLossCount($prevLossCount = null)
    {
        // validation for constraint: int
        if (!is_null($prevLossCount) && !(is_int($prevLossCount) || ctype_digit($prevLossCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prevLossCount, true), gettype($prevLossCount)), __LINE__);
        }
        $this->prevLossCount = $prevLossCount;
        return $this;
    }
    /**
     * Get prevLossCount3dPartFault value
     * @return int|null
     */
    public function getPrevLossCount3dPartFault()
    {
        return $this->prevLossCount3dPartFault;
    }
    /**
     * Set prevLossCount3dPartFault value
     * @param int $prevLossCount3dPartFault
     * @return \StructType\Policy
     */
    public function setPrevLossCount3dPartFault($prevLossCount3dPartFault = null)
    {
        // validation for constraint: int
        if (!is_null($prevLossCount3dPartFault) && !(is_int($prevLossCount3dPartFault) || ctype_digit($prevLossCount3dPartFault))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prevLossCount3dPartFault, true), gettype($prevLossCount3dPartFault)), __LINE__);
        }
        $this->prevLossCount3dPartFault = $prevLossCount3dPartFault;
        return $this;
    }
    /**
     * Get skidkaAvVProc value
     * @return bool|null
     */
    public function getSkidkaAvVProc()
    {
        return $this->skidkaAvVProc;
    }
    /**
     * Set skidkaAvVProc value
     * @param bool $skidkaAvVProc
     * @return \StructType\Policy
     */
    public function setSkidkaAvVProc($skidkaAvVProc = null)
    {
        // validation for constraint: boolean
        if (!is_null($skidkaAvVProc) && !is_bool($skidkaAvVProc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skidkaAvVProc, true), gettype($skidkaAvVProc)), __LINE__);
        }
        $this->skidkaAvVProc = $skidkaAvVProc;
        return $this;
    }
    /**
     * Get skidkaKV value
     * @return float|null
     */
    public function getSkidkaKV()
    {
        return $this->skidkaKV;
    }
    /**
     * Set skidkaKV value
     * @param float $skidkaKV
     * @return \StructType\Policy
     */
    public function setSkidkaKV($skidkaKV = null)
    {
        // validation for constraint: float
        if (!is_null($skidkaKV) && !(is_float($skidkaKV) || is_numeric($skidkaKV))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($skidkaKV, true), gettype($skidkaKV)), __LINE__);
        }
        $this->skidkaKV = $skidkaKV;
        return $this;
    }
    /**
     * Get insurantDocType value
     * @return string|null
     */
    public function getInsurantDocType()
    {
        return $this->insurantDocType;
    }
    /**
     * Set insurantDocType value
     * @uses \EnumType\DocumentType::valueIsValid()
     * @uses \EnumType\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insurantDocType
     * @return \StructType\Policy
     */
    public function setInsurantDocType($insurantDocType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DocumentType::valueIsValid($insurantDocType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DocumentType', is_array($insurantDocType) ? implode(', ', $insurantDocType) : var_export($insurantDocType, true), implode(', ', \EnumType\DocumentType::getValidValues())), __LINE__);
        }
        $this->insurantDocType = $insurantDocType;
        return $this;
    }
    /**
     * Get storeAvProc value
     * @return float|null
     */
    public function getStoreAvProc()
    {
        return $this->storeAvProc;
    }
    /**
     * Set storeAvProc value
     * @param float $storeAvProc
     * @return \StructType\Policy
     */
    public function setStoreAvProc($storeAvProc = null)
    {
        // validation for constraint: float
        if (!is_null($storeAvProc) && !(is_float($storeAvProc) || is_numeric($storeAvProc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($storeAvProc, true), gettype($storeAvProc)), __LINE__);
        }
        $this->storeAvProc = $storeAvProc;
        return $this;
    }
    /**
     * Get additionalStoreAvProc value
     * @return float|null
     */
    public function getAdditionalStoreAvProc()
    {
        return $this->additionalStoreAvProc;
    }
    /**
     * Set additionalStoreAvProc value
     * @param float $additionalStoreAvProc
     * @return \StructType\Policy
     */
    public function setAdditionalStoreAvProc($additionalStoreAvProc = null)
    {
        // validation for constraint: float
        if (!is_null($additionalStoreAvProc) && !(is_float($additionalStoreAvProc) || is_numeric($additionalStoreAvProc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($additionalStoreAvProc, true), gettype($additionalStoreAvProc)), __LINE__);
        }
        $this->additionalStoreAvProc = $additionalStoreAvProc;
        return $this;
    }
    /**
     * Get locality value
     * @return string|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @param string $locality
     * @return \StructType\Policy
     */
    public function setLocality($locality = null)
    {
        // validation for constraint: string
        if (!is_null($locality) && !is_string($locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locality, true), gettype($locality)), __LINE__);
        }
        $this->locality = $locality;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\Policy
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get localityCodeKLADR value
     * @return string|null
     */
    public function getLocalityCodeKLADR()
    {
        return $this->localityCodeKLADR;
    }
    /**
     * Set localityCodeKLADR value
     * @param string $localityCodeKLADR
     * @return \StructType\Policy
     */
    public function setLocalityCodeKLADR($localityCodeKLADR = null)
    {
        // validation for constraint: string
        if (!is_null($localityCodeKLADR) && !is_string($localityCodeKLADR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localityCodeKLADR, true), gettype($localityCodeKLADR)), __LINE__);
        }
        $this->localityCodeKLADR = $localityCodeKLADR;
        return $this;
    }
    /**
     * Get sequence value
     * @return \StructType\PolicySequence|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param \StructType\PolicySequence $sequence
     * @return \StructType\Policy
     */
    public function setSequence(\StructType\PolicySequence $sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get blanks value
     * @return \StructType\BlankList|null
     */
    public function getBlanks()
    {
        return $this->blanks;
    }
    /**
     * Set blanks value
     * @param \StructType\BlankList $blanks
     * @return \StructType\Policy
     */
    public function setBlanks(\StructType\BlankList $blanks = null)
    {
        $this->blanks = $blanks;
        return $this;
    }
    /**
     * Get policyCorrected value
     * @return bool|null
     */
    public function getPolicyCorrected()
    {
        return $this->policyCorrected;
    }
    /**
     * Set policyCorrected value
     * @param bool $policyCorrected
     * @return \StructType\Policy
     */
    public function setPolicyCorrected($policyCorrected = null)
    {
        // validation for constraint: boolean
        if (!is_null($policyCorrected) && !is_bool($policyCorrected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($policyCorrected, true), gettype($policyCorrected)), __LINE__);
        }
        $this->policyCorrected = $policyCorrected;
        return $this;
    }
    /**
     * Get correctedPolicySeries value
     * @return string|null
     */
    public function getCorrectedPolicySeries()
    {
        return $this->correctedPolicySeries;
    }
    /**
     * Set correctedPolicySeries value
     * @param string $correctedPolicySeries
     * @return \StructType\Policy
     */
    public function setCorrectedPolicySeries($correctedPolicySeries = null)
    {
        // validation for constraint: string
        if (!is_null($correctedPolicySeries) && !is_string($correctedPolicySeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correctedPolicySeries, true), gettype($correctedPolicySeries)), __LINE__);
        }
        $this->correctedPolicySeries = $correctedPolicySeries;
        return $this;
    }
    /**
     * Get correctedPolicyNumber value
     * @return string|null
     */
    public function getCorrectedPolicyNumber()
    {
        return $this->correctedPolicyNumber;
    }
    /**
     * Set correctedPolicyNumber value
     * @param string $correctedPolicyNumber
     * @return \StructType\Policy
     */
    public function setCorrectedPolicyNumber($correctedPolicyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($correctedPolicyNumber) && !is_string($correctedPolicyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correctedPolicyNumber, true), gettype($correctedPolicyNumber)), __LINE__);
        }
        $this->correctedPolicyNumber = $correctedPolicyNumber;
        return $this;
    }
    /**
     * Get contractCreationDate value
     * @return string|null
     */
    public function getContractCreationDate()
    {
        return $this->contractCreationDate;
    }
    /**
     * Set contractCreationDate value
     * @param string $contractCreationDate
     * @return \StructType\Policy
     */
    public function setContractCreationDate($contractCreationDate = null)
    {
        // validation for constraint: string
        if (!is_null($contractCreationDate) && !is_string($contractCreationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractCreationDate, true), gettype($contractCreationDate)), __LINE__);
        }
        $this->contractCreationDate = $contractCreationDate;
        return $this;
    }
    /**
     * Get correctedPolicyId value
     * @return int|null
     */
    public function getCorrectedPolicyId()
    {
        return $this->correctedPolicyId;
    }
    /**
     * Set correctedPolicyId value
     * @param int $correctedPolicyId
     * @return \StructType\Policy
     */
    public function setCorrectedPolicyId($correctedPolicyId = null)
    {
        // validation for constraint: int
        if (!is_null($correctedPolicyId) && !(is_int($correctedPolicyId) || ctype_digit($correctedPolicyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($correctedPolicyId, true), gettype($correctedPolicyId)), __LINE__);
        }
        $this->correctedPolicyId = $correctedPolicyId;
        return $this;
    }
    /**
     * Get replacedPolicyId value
     * @return int|null
     */
    public function getReplacedPolicyId()
    {
        return $this->replacedPolicyId;
    }
    /**
     * Set replacedPolicyId value
     * @param int $replacedPolicyId
     * @return \StructType\Policy
     */
    public function setReplacedPolicyId($replacedPolicyId = null)
    {
        // validation for constraint: int
        if (!is_null($replacedPolicyId) && !(is_int($replacedPolicyId) || ctype_digit($replacedPolicyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($replacedPolicyId, true), gettype($replacedPolicyId)), __LINE__);
        }
        $this->replacedPolicyId = $replacedPolicyId;
        return $this;
    }
    /**
     * Get dateIssue value
     * @return string|null
     */
    public function getDateIssue()
    {
        return $this->dateIssue;
    }
    /**
     * Set dateIssue value
     * @param string $dateIssue
     * @return \StructType\Policy
     */
    public function setDateIssue($dateIssue = null)
    {
        // validation for constraint: string
        if (!is_null($dateIssue) && !is_string($dateIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateIssue, true), gettype($dateIssue)), __LINE__);
        }
        $this->dateIssue = $dateIssue;
        return $this;
    }
    /**
     * Get sellerCode value
     * @return string|null
     */
    public function getSellerCode()
    {
        return $this->sellerCode;
    }
    /**
     * Set sellerCode value
     * @param string $sellerCode
     * @return \StructType\Policy
     */
    public function setSellerCode($sellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerCode) && !is_string($sellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerCode, true), gettype($sellerCode)), __LINE__);
        }
        $this->sellerCode = $sellerCode;
        return $this;
    }
    /**
     * Get insurantChanges value
     * @return \StructType\SubjectChangesInfo|null
     */
    public function getInsurantChanges()
    {
        return $this->insurantChanges;
    }
    /**
     * Set insurantChanges value
     * @param \StructType\SubjectChangesInfo $insurantChanges
     * @return \StructType\Policy
     */
    public function setInsurantChanges(\StructType\SubjectChangesInfo $insurantChanges = null)
    {
        $this->insurantChanges = $insurantChanges;
        return $this;
    }
    /**
     * Get prevWasInThisPartner value
     * @return bool|null
     */
    public function getPrevWasInThisPartner()
    {
        return $this->prevWasInThisPartner;
    }
    /**
     * Set prevWasInThisPartner value
     * @param bool $prevWasInThisPartner
     * @return \StructType\Policy
     */
    public function setPrevWasInThisPartner($prevWasInThisPartner = null)
    {
        // validation for constraint: boolean
        if (!is_null($prevWasInThisPartner) && !is_bool($prevWasInThisPartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prevWasInThisPartner, true), gettype($prevWasInThisPartner)), __LINE__);
        }
        $this->prevWasInThisPartner = $prevWasInThisPartner;
        return $this;
    }
    /**
     * Get ksp value
     * @return float|null
     */
    public function getKsp()
    {
        return $this->ksp;
    }
    /**
     * Set ksp value
     * @param float $ksp
     * @return \StructType\Policy
     */
    public function setKsp($ksp = null)
    {
        // validation for constraint: float
        if (!is_null($ksp) && !(is_float($ksp) || is_numeric($ksp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ksp, true), gettype($ksp)), __LINE__);
        }
        $this->ksp = $ksp;
        return $this;
    }
    /**
     * Get replacedPolicyNumberInChain value
     * @return int|null
     */
    public function getReplacedPolicyNumberInChain()
    {
        return $this->replacedPolicyNumberInChain;
    }
    /**
     * Set replacedPolicyNumberInChain value
     * @param int $replacedPolicyNumberInChain
     * @return \StructType\Policy
     */
    public function setReplacedPolicyNumberInChain($replacedPolicyNumberInChain = null)
    {
        // validation for constraint: int
        if (!is_null($replacedPolicyNumberInChain) && !(is_int($replacedPolicyNumberInChain) || ctype_digit($replacedPolicyNumberInChain))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($replacedPolicyNumberInChain, true), gettype($replacedPolicyNumberInChain)), __LINE__);
        }
        $this->replacedPolicyNumberInChain = $replacedPolicyNumberInChain;
        return $this;
    }
    /**
     * Get insurantRepresentative value
     * @return \StructType\SubjectRepresentative|null
     */
    public function getInsurantRepresentative()
    {
        return $this->insurantRepresentative;
    }
    /**
     * Set insurantRepresentative value
     * @param \StructType\SubjectRepresentative $insurantRepresentative
     * @return \StructType\Policy
     */
    public function setInsurantRepresentative(\StructType\SubjectRepresentative $insurantRepresentative = null)
    {
        $this->insurantRepresentative = $insurantRepresentative;
        return $this;
    }
    /**
     * Get insurantBankRequisites value
     * @return \StructType\BankRequisitesList|null
     */
    public function getInsurantBankRequisites()
    {
        return $this->insurantBankRequisites;
    }
    /**
     * Set insurantBankRequisites value
     * @param \StructType\BankRequisitesList $insurantBankRequisites
     * @return \StructType\Policy
     */
    public function setInsurantBankRequisites(\StructType\BankRequisitesList $insurantBankRequisites = null)
    {
        $this->insurantBankRequisites = $insurantBankRequisites;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\ParametrList|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\ParametrList $parameters
     * @return \StructType\Policy
     */
    public function setParameters(\StructType\ParametrList $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get subrogation value
     * @return bool|null
     */
    public function getSubrogation()
    {
        return $this->subrogation;
    }
    /**
     * Set subrogation value
     * @param bool $subrogation
     * @return \StructType\Policy
     */
    public function setSubrogation($subrogation = null)
    {
        // validation for constraint: boolean
        if (!is_null($subrogation) && !is_bool($subrogation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subrogation, true), gettype($subrogation)), __LINE__);
        }
        $this->subrogation = $subrogation;
        return $this;
    }
    /**
     * Get ikpCuratora value
     * @return string|null
     */
    public function getIkpCuratora()
    {
        return $this->ikpCuratora;
    }
    /**
     * Set ikpCuratora value
     * @param string $ikpCuratora
     * @return \StructType\Policy
     */
    public function setIkpCuratora($ikpCuratora = null)
    {
        // validation for constraint: string
        if (!is_null($ikpCuratora) && !is_string($ikpCuratora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ikpCuratora, true), gettype($ikpCuratora)), __LINE__);
        }
        $this->ikpCuratora = $ikpCuratora;
        return $this;
    }
    /**
     * Get cross value
     * @return \StructType\Cross|null
     */
    public function getCross()
    {
        return $this->cross;
    }
    /**
     * Set cross value
     * @param \StructType\Cross $cross
     * @return \StructType\Policy
     */
    public function setCross(\StructType\Cross $cross = null)
    {
        $this->cross = $cross;
        return $this;
    }
    /**
     * Get beneficiary2 value
     * @return \StructType\SubjectInfo|null
     */
    public function getBeneficiary2()
    {
        return $this->beneficiary2;
    }
    /**
     * Set beneficiary2 value
     * @param \StructType\SubjectInfo $beneficiary2
     * @return \StructType\Policy
     */
    public function setBeneficiary2(\StructType\SubjectInfo $beneficiary2 = null)
    {
        $this->beneficiary2 = $beneficiary2;
        return $this;
    }
    /**
     * Get signer value
     * @return \StructType\RepresentativeInfo|null
     */
    public function getSigner()
    {
        return $this->signer;
    }
    /**
     * Set signer value
     * @param \StructType\RepresentativeInfo $signer
     * @return \StructType\Policy
     */
    public function setSigner(\StructType\RepresentativeInfo $signer = null)
    {
        $this->signer = $signer;
        return $this;
    }
    /**
     * Get periodOfInsurance value
     * @return int|null
     */
    public function getPeriodOfInsurance()
    {
        return $this->periodOfInsurance;
    }
    /**
     * Set periodOfInsurance value
     * @param int $periodOfInsurance
     * @return \StructType\Policy
     */
    public function setPeriodOfInsurance($periodOfInsurance = null)
    {
        // validation for constraint: int
        if (!is_null($periodOfInsurance) && !(is_int($periodOfInsurance) || ctype_digit($periodOfInsurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($periodOfInsurance, true), gettype($periodOfInsurance)), __LINE__);
        }
        $this->periodOfInsurance = $periodOfInsurance;
        return $this;
    }
    /**
     * Get timeUnitPeriodOfInsurance value
     * @return string|null
     */
    public function getTimeUnitPeriodOfInsurance()
    {
        return $this->timeUnitPeriodOfInsurance;
    }
    /**
     * Set timeUnitPeriodOfInsurance value
     * @uses \EnumType\TimeUnitPeriodOfInsurance::valueIsValid()
     * @uses \EnumType\TimeUnitPeriodOfInsurance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeUnitPeriodOfInsurance
     * @return \StructType\Policy
     */
    public function setTimeUnitPeriodOfInsurance($timeUnitPeriodOfInsurance = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitPeriodOfInsurance::valueIsValid($timeUnitPeriodOfInsurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitPeriodOfInsurance', is_array($timeUnitPeriodOfInsurance) ? implode(', ', $timeUnitPeriodOfInsurance) : var_export($timeUnitPeriodOfInsurance, true), implode(', ', \EnumType\TimeUnitPeriodOfInsurance::getValidValues())), __LINE__);
        }
        $this->timeUnitPeriodOfInsurance = $timeUnitPeriodOfInsurance;
        return $this;
    }
    /**
     * Get beneficiaries value
     * @return \StructType\Beneficiaries|null
     */
    public function getBeneficiaries()
    {
        return $this->beneficiaries;
    }
    /**
     * Set beneficiaries value
     * @param \StructType\Beneficiaries $beneficiaries
     * @return \StructType\Policy
     */
    public function setBeneficiaries(\StructType\Beneficiaries $beneficiaries = null)
    {
        $this->beneficiaries = $beneficiaries;
        return $this;
    }
    /**
     * Get countYearsWithoutLoss value
     * @return int|null
     */
    public function getCountYearsWithoutLoss()
    {
        return $this->countYearsWithoutLoss;
    }
    /**
     * Set countYearsWithoutLoss value
     * @param int $countYearsWithoutLoss
     * @return \StructType\Policy
     */
    public function setCountYearsWithoutLoss($countYearsWithoutLoss = null)
    {
        // validation for constraint: int
        if (!is_null($countYearsWithoutLoss) && !(is_int($countYearsWithoutLoss) || ctype_digit($countYearsWithoutLoss))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countYearsWithoutLoss, true), gettype($countYearsWithoutLoss)), __LINE__);
        }
        $this->countYearsWithoutLoss = $countYearsWithoutLoss;
        return $this;
    }
    /**
     * Get countInsEventsPrevPolicy value
     * @return int|null
     */
    public function getCountInsEventsPrevPolicy()
    {
        return $this->countInsEventsPrevPolicy;
    }
    /**
     * Set countInsEventsPrevPolicy value
     * @param int $countInsEventsPrevPolicy
     * @return \StructType\Policy
     */
    public function setCountInsEventsPrevPolicy($countInsEventsPrevPolicy = null)
    {
        // validation for constraint: int
        if (!is_null($countInsEventsPrevPolicy) && !(is_int($countInsEventsPrevPolicy) || ctype_digit($countInsEventsPrevPolicy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countInsEventsPrevPolicy, true), gettype($countInsEventsPrevPolicy)), __LINE__);
        }
        $this->countInsEventsPrevPolicy = $countInsEventsPrevPolicy;
        return $this;
    }
    /**
     * Get epolicy value
     * @return bool|null
     */
    public function getEpolicy()
    {
        return $this->epolicy;
    }
    /**
     * Set epolicy value
     * @param bool $epolicy
     * @return \StructType\Policy
     */
    public function setEpolicy($epolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($epolicy) && !is_bool($epolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($epolicy, true), gettype($epolicy)), __LINE__);
        }
        $this->epolicy = $epolicy;
        return $this;
    }
    /**
     * Get onlinePayment value
     * @return bool|null
     */
    public function getOnlinePayment()
    {
        return $this->onlinePayment;
    }
    /**
     * Set onlinePayment value
     * @param bool $onlinePayment
     * @return \StructType\Policy
     */
    public function setOnlinePayment($onlinePayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlinePayment) && !is_bool($onlinePayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlinePayment, true), gettype($onlinePayment)), __LINE__);
        }
        $this->onlinePayment = $onlinePayment;
        return $this;
    }
    /**
     * Get stateHistoryList value
     * @return \StructType\PolicyStateHistoryList|null
     */
    public function getStateHistoryList()
    {
        return $this->stateHistoryList;
    }
    /**
     * Set stateHistoryList value
     * @param \StructType\PolicyStateHistoryList $stateHistoryList
     * @return \StructType\Policy
     */
    public function setStateHistoryList(\StructType\PolicyStateHistoryList $stateHistoryList = null)
    {
        $this->stateHistoryList = $stateHistoryList;
        return $this;
    }
    /**
     * Get consentedToPersonalDataProcessing value
     * @return bool|null
     */
    public function getConsentedToPersonalDataProcessing()
    {
        return $this->consentedToPersonalDataProcessing;
    }
    /**
     * Set consentedToPersonalDataProcessing value
     * @param bool $consentedToPersonalDataProcessing
     * @return \StructType\Policy
     */
    public function setConsentedToPersonalDataProcessing($consentedToPersonalDataProcessing = null)
    {
        // validation for constraint: boolean
        if (!is_null($consentedToPersonalDataProcessing) && !is_bool($consentedToPersonalDataProcessing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($consentedToPersonalDataProcessing, true), gettype($consentedToPersonalDataProcessing)), __LINE__);
        }
        $this->consentedToPersonalDataProcessing = $consentedToPersonalDataProcessing;
        return $this;
    }
}
