<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalIdentificationDataInfo StructType
 * @subpackage Structs
 */
class PhysicalIdentificationDataInfo extends AbstractStructBase
{
    /**
     * The relatedPDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RelatedPdlInfo
     */
    public $relatedPDL;
    /**
     * The typePDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TypePdlInfo
     */
    public $typePDL;
    /**
     * The postPDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postPDL;
    /**
     * The degreeOfKinshipPDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $degreeOfKinshipPDL;
    /**
     * The sourceOfIncomePDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceOfIncomePDL;
    /**
     * The relativeSurnamePDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relativeSurnamePDL;
    /**
     * The relativeFirstnamePDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relativeFirstnamePDL;
    /**
     * The relativePatronymicPDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relativePatronymicPDL;
    /**
     * The linkedToTerrorist
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $linkedToTerrorist;
    /**
     * The dateCheckTerrosist
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateCheckTerrosist;
    /**
     * The fullNameCheckerTerrorist
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fullNameCheckerTerrorist;
    /**
     * The degreeOfRisk
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $degreeOfRisk;
    /**
     * The justificationRisk
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JustificationRiskInfo
     */
    public $justificationRisk;
    /**
     * The financInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FinancInformation
     */
    public $financInfo;
    /**
     * The businessReputationInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessReputationInfo
     */
    public $businessReputationInfo;
    /**
     * The notIdentificBeneficiars
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $notIdentificBeneficiars;
    /**
     * The justificationNotIdentBenef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JustificationNotIdentBenefInfo
     */
    public $justificationNotIdentBenef;
    /**
     * The verificationBeneficiar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VerificationBenefiziarInfo
     */
    public $verificationBeneficiar;
    /**
     * The isDirectOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDirectOwner;
    /**
     * The notIdentificVigod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $notIdentificVigod;
    /**
     * The fullNameFillInQuestionnaire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fullNameFillInQuestionnaire;
    /**
     * The postFillInQuestionnaire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postFillInQuestionnaire;
    /**
     * The fullNameResponsible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fullNameResponsible;
    /**
     * The postResponsible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postResponsible;
    /**
     * The dateFillInQuestionnaire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $dateFillInQuestionnaire;
    /**
     * The dateUpdateQuestionnaire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $dateUpdateQuestionnaire;
    /**
     * The startDateRelations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $startDateRelations;
    /**
     * The justificationNotIdentVigod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JustificationNotIdentVigodInfo
     */
    public $justificationNotIdentVigod;
    /**
     * The beneficiari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IdentifBeneficiarListInfo
     */
    public $beneficiari;
    /**
     * The representatives
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PredstavitelListInfo
     */
    public $representatives;
    /**
     * The isOneTimeBusinessRelationship
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOneTimeBusinessRelationship;
    /**
     * The informationConfirmingControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $informationConfirmingControl;
    /**
     * The fullNameEmployerPDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fullNameEmployerPDL;
    /**
     * The postEmployerPDL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postEmployerPDL;
    /**
     * The docResponsible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocumentInfo
     */
    public $docResponsible;
    /**
     * The dateOfTerminationOfRelations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $dateOfTerminationOfRelations;
    /**
     * The sourceOfIncome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sourceOfIncome;
    /**
     * The numberSolutionsConfessionsOfTerrorists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numberSolutionsConfessionsOfTerrorists;
    /**
     * The dateSolutionsConfessionsOfTerrorists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $dateSolutionsConfessionsOfTerrorists;
    /**
     * The businessLicense
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessLicenseList
     */
    public $businessLicense;
    /**
     * The finAndEconomicActivityPurposes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $finAndEconomicActivityPurposes;
    /**
     * The insolvencyProceedings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $insolvencyProceedings;
    /**
     * The sourcesOfIncomeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SourcesOfIncome
     */
    public $sourcesOfIncomeList;
    /**
     * The sourcesOfIncomePDLList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SourcesOfIncome
     */
    public $sourcesOfIncomePDLList;
    /**
     * The engagedInPrivatePractice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $engagedInPrivatePractice;
    /**
     * The typeOfPrivatePractice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $typeOfPrivatePractice;
    /**
     * The registrationNumberOfPrivatePractice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $registrationNumberOfPrivatePractice;
    /**
     * Constructor method for PhysicalIdentificationDataInfo
     * @uses PhysicalIdentificationDataInfo::setRelatedPDL()
     * @uses PhysicalIdentificationDataInfo::setTypePDL()
     * @uses PhysicalIdentificationDataInfo::setPostPDL()
     * @uses PhysicalIdentificationDataInfo::setDegreeOfKinshipPDL()
     * @uses PhysicalIdentificationDataInfo::setSourceOfIncomePDL()
     * @uses PhysicalIdentificationDataInfo::setRelativeSurnamePDL()
     * @uses PhysicalIdentificationDataInfo::setRelativeFirstnamePDL()
     * @uses PhysicalIdentificationDataInfo::setRelativePatronymicPDL()
     * @uses PhysicalIdentificationDataInfo::setLinkedToTerrorist()
     * @uses PhysicalIdentificationDataInfo::setDateCheckTerrosist()
     * @uses PhysicalIdentificationDataInfo::setFullNameCheckerTerrorist()
     * @uses PhysicalIdentificationDataInfo::setDegreeOfRisk()
     * @uses PhysicalIdentificationDataInfo::setJustificationRisk()
     * @uses PhysicalIdentificationDataInfo::setFinancInfo()
     * @uses PhysicalIdentificationDataInfo::setBusinessReputationInfo()
     * @uses PhysicalIdentificationDataInfo::setNotIdentificBeneficiars()
     * @uses PhysicalIdentificationDataInfo::setJustificationNotIdentBenef()
     * @uses PhysicalIdentificationDataInfo::setVerificationBeneficiar()
     * @uses PhysicalIdentificationDataInfo::setIsDirectOwner()
     * @uses PhysicalIdentificationDataInfo::setNotIdentificVigod()
     * @uses PhysicalIdentificationDataInfo::setFullNameFillInQuestionnaire()
     * @uses PhysicalIdentificationDataInfo::setPostFillInQuestionnaire()
     * @uses PhysicalIdentificationDataInfo::setFullNameResponsible()
     * @uses PhysicalIdentificationDataInfo::setPostResponsible()
     * @uses PhysicalIdentificationDataInfo::setDateFillInQuestionnaire()
     * @uses PhysicalIdentificationDataInfo::setDateUpdateQuestionnaire()
     * @uses PhysicalIdentificationDataInfo::setStartDateRelations()
     * @uses PhysicalIdentificationDataInfo::setJustificationNotIdentVigod()
     * @uses PhysicalIdentificationDataInfo::setBeneficiari()
     * @uses PhysicalIdentificationDataInfo::setRepresentatives()
     * @uses PhysicalIdentificationDataInfo::setIsOneTimeBusinessRelationship()
     * @uses PhysicalIdentificationDataInfo::setInformationConfirmingControl()
     * @uses PhysicalIdentificationDataInfo::setFullNameEmployerPDL()
     * @uses PhysicalIdentificationDataInfo::setPostEmployerPDL()
     * @uses PhysicalIdentificationDataInfo::setDocResponsible()
     * @uses PhysicalIdentificationDataInfo::setDateOfTerminationOfRelations()
     * @uses PhysicalIdentificationDataInfo::setSourceOfIncome()
     * @uses PhysicalIdentificationDataInfo::setNumberSolutionsConfessionsOfTerrorists()
     * @uses PhysicalIdentificationDataInfo::setDateSolutionsConfessionsOfTerrorists()
     * @uses PhysicalIdentificationDataInfo::setBusinessLicense()
     * @uses PhysicalIdentificationDataInfo::setFinAndEconomicActivityPurposes()
     * @uses PhysicalIdentificationDataInfo::setInsolvencyProceedings()
     * @uses PhysicalIdentificationDataInfo::setSourcesOfIncomeList()
     * @uses PhysicalIdentificationDataInfo::setSourcesOfIncomePDLList()
     * @uses PhysicalIdentificationDataInfo::setEngagedInPrivatePractice()
     * @uses PhysicalIdentificationDataInfo::setTypeOfPrivatePractice()
     * @uses PhysicalIdentificationDataInfo::setRegistrationNumberOfPrivatePractice()
     * @param \StructType\RelatedPdlInfo $relatedPDL
     * @param \StructType\TypePdlInfo $typePDL
     * @param string $postPDL
     * @param string $degreeOfKinshipPDL
     * @param string $sourceOfIncomePDL
     * @param string $relativeSurnamePDL
     * @param string $relativeFirstnamePDL
     * @param string $relativePatronymicPDL
     * @param bool $linkedToTerrorist
     * @param string $dateCheckTerrosist
     * @param string $fullNameCheckerTerrorist
     * @param bool $degreeOfRisk
     * @param \StructType\JustificationRiskInfo $justificationRisk
     * @param \StructType\FinancInformation $financInfo
     * @param \StructType\BusinessReputationInfo $businessReputationInfo
     * @param bool $notIdentificBeneficiars
     * @param \StructType\JustificationNotIdentBenefInfo $justificationNotIdentBenef
     * @param \StructType\VerificationBenefiziarInfo $verificationBeneficiar
     * @param bool $isDirectOwner
     * @param bool $notIdentificVigod
     * @param string $fullNameFillInQuestionnaire
     * @param string $postFillInQuestionnaire
     * @param string $fullNameResponsible
     * @param string $postResponsible
     * @param anySimpleType $dateFillInQuestionnaire
     * @param anySimpleType $dateUpdateQuestionnaire
     * @param anySimpleType $startDateRelations
     * @param \StructType\JustificationNotIdentVigodInfo $justificationNotIdentVigod
     * @param \StructType\IdentifBeneficiarListInfo $beneficiari
     * @param \StructType\PredstavitelListInfo $representatives
     * @param bool $isOneTimeBusinessRelationship
     * @param string $informationConfirmingControl
     * @param string $fullNameEmployerPDL
     * @param string $postEmployerPDL
     * @param \StructType\DocumentInfo $docResponsible
     * @param anySimpleType $dateOfTerminationOfRelations
     * @param string $sourceOfIncome
     * @param string $numberSolutionsConfessionsOfTerrorists
     * @param anySimpleType $dateSolutionsConfessionsOfTerrorists
     * @param \StructType\BusinessLicenseList $businessLicense
     * @param string $finAndEconomicActivityPurposes
     * @param bool $insolvencyProceedings
     * @param \StructType\SourcesOfIncome $sourcesOfIncomeList
     * @param \StructType\SourcesOfIncome $sourcesOfIncomePDLList
     * @param bool $engagedInPrivatePractice
     * @param string $typeOfPrivatePractice
     * @param string $registrationNumberOfPrivatePractice
     */
    public function __construct(\StructType\RelatedPdlInfo $relatedPDL = null, \StructType\TypePdlInfo $typePDL = null, $postPDL = null, $degreeOfKinshipPDL = null, $sourceOfIncomePDL = null, $relativeSurnamePDL = null, $relativeFirstnamePDL = null, $relativePatronymicPDL = null, $linkedToTerrorist = null, $dateCheckTerrosist = null, $fullNameCheckerTerrorist = null, $degreeOfRisk = null, \StructType\JustificationRiskInfo $justificationRisk = null, \StructType\FinancInformation $financInfo = null, \StructType\BusinessReputationInfo $businessReputationInfo = null, $notIdentificBeneficiars = null, \StructType\JustificationNotIdentBenefInfo $justificationNotIdentBenef = null, \StructType\VerificationBenefiziarInfo $verificationBeneficiar = null, $isDirectOwner = null, $notIdentificVigod = null, $fullNameFillInQuestionnaire = null, $postFillInQuestionnaire = null, $fullNameResponsible = null, $postResponsible = null, anySimpleType $dateFillInQuestionnaire = null, anySimpleType $dateUpdateQuestionnaire = null, anySimpleType $startDateRelations = null, \StructType\JustificationNotIdentVigodInfo $justificationNotIdentVigod = null, \StructType\IdentifBeneficiarListInfo $beneficiari = null, \StructType\PredstavitelListInfo $representatives = null, $isOneTimeBusinessRelationship = null, $informationConfirmingControl = null, $fullNameEmployerPDL = null, $postEmployerPDL = null, \StructType\DocumentInfo $docResponsible = null, anySimpleType $dateOfTerminationOfRelations = null, $sourceOfIncome = null, $numberSolutionsConfessionsOfTerrorists = null, anySimpleType $dateSolutionsConfessionsOfTerrorists = null, \StructType\BusinessLicenseList $businessLicense = null, $finAndEconomicActivityPurposes = null, $insolvencyProceedings = null, \StructType\SourcesOfIncome $sourcesOfIncomeList = null, \StructType\SourcesOfIncome $sourcesOfIncomePDLList = null, $engagedInPrivatePractice = null, $typeOfPrivatePractice = null, $registrationNumberOfPrivatePractice = null)
    {
        $this
            ->setRelatedPDL($relatedPDL)
            ->setTypePDL($typePDL)
            ->setPostPDL($postPDL)
            ->setDegreeOfKinshipPDL($degreeOfKinshipPDL)
            ->setSourceOfIncomePDL($sourceOfIncomePDL)
            ->setRelativeSurnamePDL($relativeSurnamePDL)
            ->setRelativeFirstnamePDL($relativeFirstnamePDL)
            ->setRelativePatronymicPDL($relativePatronymicPDL)
            ->setLinkedToTerrorist($linkedToTerrorist)
            ->setDateCheckTerrosist($dateCheckTerrosist)
            ->setFullNameCheckerTerrorist($fullNameCheckerTerrorist)
            ->setDegreeOfRisk($degreeOfRisk)
            ->setJustificationRisk($justificationRisk)
            ->setFinancInfo($financInfo)
            ->setBusinessReputationInfo($businessReputationInfo)
            ->setNotIdentificBeneficiars($notIdentificBeneficiars)
            ->setJustificationNotIdentBenef($justificationNotIdentBenef)
            ->setVerificationBeneficiar($verificationBeneficiar)
            ->setIsDirectOwner($isDirectOwner)
            ->setNotIdentificVigod($notIdentificVigod)
            ->setFullNameFillInQuestionnaire($fullNameFillInQuestionnaire)
            ->setPostFillInQuestionnaire($postFillInQuestionnaire)
            ->setFullNameResponsible($fullNameResponsible)
            ->setPostResponsible($postResponsible)
            ->setDateFillInQuestionnaire($dateFillInQuestionnaire)
            ->setDateUpdateQuestionnaire($dateUpdateQuestionnaire)
            ->setStartDateRelations($startDateRelations)
            ->setJustificationNotIdentVigod($justificationNotIdentVigod)
            ->setBeneficiari($beneficiari)
            ->setRepresentatives($representatives)
            ->setIsOneTimeBusinessRelationship($isOneTimeBusinessRelationship)
            ->setInformationConfirmingControl($informationConfirmingControl)
            ->setFullNameEmployerPDL($fullNameEmployerPDL)
            ->setPostEmployerPDL($postEmployerPDL)
            ->setDocResponsible($docResponsible)
            ->setDateOfTerminationOfRelations($dateOfTerminationOfRelations)
            ->setSourceOfIncome($sourceOfIncome)
            ->setNumberSolutionsConfessionsOfTerrorists($numberSolutionsConfessionsOfTerrorists)
            ->setDateSolutionsConfessionsOfTerrorists($dateSolutionsConfessionsOfTerrorists)
            ->setBusinessLicense($businessLicense)
            ->setFinAndEconomicActivityPurposes($finAndEconomicActivityPurposes)
            ->setInsolvencyProceedings($insolvencyProceedings)
            ->setSourcesOfIncomeList($sourcesOfIncomeList)
            ->setSourcesOfIncomePDLList($sourcesOfIncomePDLList)
            ->setEngagedInPrivatePractice($engagedInPrivatePractice)
            ->setTypeOfPrivatePractice($typeOfPrivatePractice)
            ->setRegistrationNumberOfPrivatePractice($registrationNumberOfPrivatePractice);
    }
    /**
     * Get relatedPDL value
     * @return \StructType\RelatedPdlInfo|null
     */
    public function getRelatedPDL()
    {
        return $this->relatedPDL;
    }
    /**
     * Set relatedPDL value
     * @param \StructType\RelatedPdlInfo $relatedPDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setRelatedPDL(\StructType\RelatedPdlInfo $relatedPDL = null)
    {
        $this->relatedPDL = $relatedPDL;
        return $this;
    }
    /**
     * Get typePDL value
     * @return \StructType\TypePdlInfo|null
     */
    public function getTypePDL()
    {
        return $this->typePDL;
    }
    /**
     * Set typePDL value
     * @param \StructType\TypePdlInfo $typePDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setTypePDL(\StructType\TypePdlInfo $typePDL = null)
    {
        $this->typePDL = $typePDL;
        return $this;
    }
    /**
     * Get postPDL value
     * @return string|null
     */
    public function getPostPDL()
    {
        return $this->postPDL;
    }
    /**
     * Set postPDL value
     * @param string $postPDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setPostPDL($postPDL = null)
    {
        // validation for constraint: string
        if (!is_null($postPDL) && !is_string($postPDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postPDL, true), gettype($postPDL)), __LINE__);
        }
        $this->postPDL = $postPDL;
        return $this;
    }
    /**
     * Get degreeOfKinshipPDL value
     * @return string|null
     */
    public function getDegreeOfKinshipPDL()
    {
        return $this->degreeOfKinshipPDL;
    }
    /**
     * Set degreeOfKinshipPDL value
     * @param string $degreeOfKinshipPDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setDegreeOfKinshipPDL($degreeOfKinshipPDL = null)
    {
        // validation for constraint: string
        if (!is_null($degreeOfKinshipPDL) && !is_string($degreeOfKinshipPDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($degreeOfKinshipPDL, true), gettype($degreeOfKinshipPDL)), __LINE__);
        }
        $this->degreeOfKinshipPDL = $degreeOfKinshipPDL;
        return $this;
    }
    /**
     * Get sourceOfIncomePDL value
     * @return string|null
     */
    public function getSourceOfIncomePDL()
    {
        return $this->sourceOfIncomePDL;
    }
    /**
     * Set sourceOfIncomePDL value
     * @param string $sourceOfIncomePDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setSourceOfIncomePDL($sourceOfIncomePDL = null)
    {
        // validation for constraint: string
        if (!is_null($sourceOfIncomePDL) && !is_string($sourceOfIncomePDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceOfIncomePDL, true), gettype($sourceOfIncomePDL)), __LINE__);
        }
        $this->sourceOfIncomePDL = $sourceOfIncomePDL;
        return $this;
    }
    /**
     * Get relativeSurnamePDL value
     * @return string|null
     */
    public function getRelativeSurnamePDL()
    {
        return $this->relativeSurnamePDL;
    }
    /**
     * Set relativeSurnamePDL value
     * @param string $relativeSurnamePDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setRelativeSurnamePDL($relativeSurnamePDL = null)
    {
        // validation for constraint: string
        if (!is_null($relativeSurnamePDL) && !is_string($relativeSurnamePDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relativeSurnamePDL, true), gettype($relativeSurnamePDL)), __LINE__);
        }
        $this->relativeSurnamePDL = $relativeSurnamePDL;
        return $this;
    }
    /**
     * Get relativeFirstnamePDL value
     * @return string|null
     */
    public function getRelativeFirstnamePDL()
    {
        return $this->relativeFirstnamePDL;
    }
    /**
     * Set relativeFirstnamePDL value
     * @param string $relativeFirstnamePDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setRelativeFirstnamePDL($relativeFirstnamePDL = null)
    {
        // validation for constraint: string
        if (!is_null($relativeFirstnamePDL) && !is_string($relativeFirstnamePDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relativeFirstnamePDL, true), gettype($relativeFirstnamePDL)), __LINE__);
        }
        $this->relativeFirstnamePDL = $relativeFirstnamePDL;
        return $this;
    }
    /**
     * Get relativePatronymicPDL value
     * @return string|null
     */
    public function getRelativePatronymicPDL()
    {
        return $this->relativePatronymicPDL;
    }
    /**
     * Set relativePatronymicPDL value
     * @param string $relativePatronymicPDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setRelativePatronymicPDL($relativePatronymicPDL = null)
    {
        // validation for constraint: string
        if (!is_null($relativePatronymicPDL) && !is_string($relativePatronymicPDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relativePatronymicPDL, true), gettype($relativePatronymicPDL)), __LINE__);
        }
        $this->relativePatronymicPDL = $relativePatronymicPDL;
        return $this;
    }
    /**
     * Get linkedToTerrorist value
     * @return bool|null
     */
    public function getLinkedToTerrorist()
    {
        return $this->linkedToTerrorist;
    }
    /**
     * Set linkedToTerrorist value
     * @param bool $linkedToTerrorist
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setLinkedToTerrorist($linkedToTerrorist = null)
    {
        // validation for constraint: boolean
        if (!is_null($linkedToTerrorist) && !is_bool($linkedToTerrorist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($linkedToTerrorist, true), gettype($linkedToTerrorist)), __LINE__);
        }
        $this->linkedToTerrorist = $linkedToTerrorist;
        return $this;
    }
    /**
     * Get dateCheckTerrosist value
     * @return string|null
     */
    public function getDateCheckTerrosist()
    {
        return $this->dateCheckTerrosist;
    }
    /**
     * Set dateCheckTerrosist value
     * @param string $dateCheckTerrosist
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setDateCheckTerrosist($dateCheckTerrosist = null)
    {
        // validation for constraint: string
        if (!is_null($dateCheckTerrosist) && !is_string($dateCheckTerrosist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCheckTerrosist, true), gettype($dateCheckTerrosist)), __LINE__);
        }
        $this->dateCheckTerrosist = $dateCheckTerrosist;
        return $this;
    }
    /**
     * Get fullNameCheckerTerrorist value
     * @return string|null
     */
    public function getFullNameCheckerTerrorist()
    {
        return $this->fullNameCheckerTerrorist;
    }
    /**
     * Set fullNameCheckerTerrorist value
     * @param string $fullNameCheckerTerrorist
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setFullNameCheckerTerrorist($fullNameCheckerTerrorist = null)
    {
        // validation for constraint: string
        if (!is_null($fullNameCheckerTerrorist) && !is_string($fullNameCheckerTerrorist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullNameCheckerTerrorist, true), gettype($fullNameCheckerTerrorist)), __LINE__);
        }
        $this->fullNameCheckerTerrorist = $fullNameCheckerTerrorist;
        return $this;
    }
    /**
     * Get degreeOfRisk value
     * @return bool|null
     */
    public function getDegreeOfRisk()
    {
        return $this->degreeOfRisk;
    }
    /**
     * Set degreeOfRisk value
     * @param bool $degreeOfRisk
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setDegreeOfRisk($degreeOfRisk = null)
    {
        // validation for constraint: boolean
        if (!is_null($degreeOfRisk) && !is_bool($degreeOfRisk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($degreeOfRisk, true), gettype($degreeOfRisk)), __LINE__);
        }
        $this->degreeOfRisk = $degreeOfRisk;
        return $this;
    }
    /**
     * Get justificationRisk value
     * @return \StructType\JustificationRiskInfo|null
     */
    public function getJustificationRisk()
    {
        return $this->justificationRisk;
    }
    /**
     * Set justificationRisk value
     * @param \StructType\JustificationRiskInfo $justificationRisk
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setJustificationRisk(\StructType\JustificationRiskInfo $justificationRisk = null)
    {
        $this->justificationRisk = $justificationRisk;
        return $this;
    }
    /**
     * Get financInfo value
     * @return \StructType\FinancInformation|null
     */
    public function getFinancInfo()
    {
        return $this->financInfo;
    }
    /**
     * Set financInfo value
     * @param \StructType\FinancInformation $financInfo
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setFinancInfo(\StructType\FinancInformation $financInfo = null)
    {
        $this->financInfo = $financInfo;
        return $this;
    }
    /**
     * Get businessReputationInfo value
     * @return \StructType\BusinessReputationInfo|null
     */
    public function getBusinessReputationInfo()
    {
        return $this->businessReputationInfo;
    }
    /**
     * Set businessReputationInfo value
     * @param \StructType\BusinessReputationInfo $businessReputationInfo
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setBusinessReputationInfo(\StructType\BusinessReputationInfo $businessReputationInfo = null)
    {
        $this->businessReputationInfo = $businessReputationInfo;
        return $this;
    }
    /**
     * Get notIdentificBeneficiars value
     * @return bool|null
     */
    public function getNotIdentificBeneficiars()
    {
        return $this->notIdentificBeneficiars;
    }
    /**
     * Set notIdentificBeneficiars value
     * @param bool $notIdentificBeneficiars
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setNotIdentificBeneficiars($notIdentificBeneficiars = null)
    {
        // validation for constraint: boolean
        if (!is_null($notIdentificBeneficiars) && !is_bool($notIdentificBeneficiars)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notIdentificBeneficiars, true), gettype($notIdentificBeneficiars)), __LINE__);
        }
        $this->notIdentificBeneficiars = $notIdentificBeneficiars;
        return $this;
    }
    /**
     * Get justificationNotIdentBenef value
     * @return \StructType\JustificationNotIdentBenefInfo|null
     */
    public function getJustificationNotIdentBenef()
    {
        return $this->justificationNotIdentBenef;
    }
    /**
     * Set justificationNotIdentBenef value
     * @param \StructType\JustificationNotIdentBenefInfo $justificationNotIdentBenef
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setJustificationNotIdentBenef(\StructType\JustificationNotIdentBenefInfo $justificationNotIdentBenef = null)
    {
        $this->justificationNotIdentBenef = $justificationNotIdentBenef;
        return $this;
    }
    /**
     * Get verificationBeneficiar value
     * @return \StructType\VerificationBenefiziarInfo|null
     */
    public function getVerificationBeneficiar()
    {
        return $this->verificationBeneficiar;
    }
    /**
     * Set verificationBeneficiar value
     * @param \StructType\VerificationBenefiziarInfo $verificationBeneficiar
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setVerificationBeneficiar(\StructType\VerificationBenefiziarInfo $verificationBeneficiar = null)
    {
        $this->verificationBeneficiar = $verificationBeneficiar;
        return $this;
    }
    /**
     * Get isDirectOwner value
     * @return bool|null
     */
    public function getIsDirectOwner()
    {
        return $this->isDirectOwner;
    }
    /**
     * Set isDirectOwner value
     * @param bool $isDirectOwner
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setIsDirectOwner($isDirectOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDirectOwner) && !is_bool($isDirectOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDirectOwner, true), gettype($isDirectOwner)), __LINE__);
        }
        $this->isDirectOwner = $isDirectOwner;
        return $this;
    }
    /**
     * Get notIdentificVigod value
     * @return bool|null
     */
    public function getNotIdentificVigod()
    {
        return $this->notIdentificVigod;
    }
    /**
     * Set notIdentificVigod value
     * @param bool $notIdentificVigod
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setNotIdentificVigod($notIdentificVigod = null)
    {
        // validation for constraint: boolean
        if (!is_null($notIdentificVigod) && !is_bool($notIdentificVigod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notIdentificVigod, true), gettype($notIdentificVigod)), __LINE__);
        }
        $this->notIdentificVigod = $notIdentificVigod;
        return $this;
    }
    /**
     * Get fullNameFillInQuestionnaire value
     * @return string|null
     */
    public function getFullNameFillInQuestionnaire()
    {
        return $this->fullNameFillInQuestionnaire;
    }
    /**
     * Set fullNameFillInQuestionnaire value
     * @param string $fullNameFillInQuestionnaire
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setFullNameFillInQuestionnaire($fullNameFillInQuestionnaire = null)
    {
        // validation for constraint: string
        if (!is_null($fullNameFillInQuestionnaire) && !is_string($fullNameFillInQuestionnaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullNameFillInQuestionnaire, true), gettype($fullNameFillInQuestionnaire)), __LINE__);
        }
        $this->fullNameFillInQuestionnaire = $fullNameFillInQuestionnaire;
        return $this;
    }
    /**
     * Get postFillInQuestionnaire value
     * @return string|null
     */
    public function getPostFillInQuestionnaire()
    {
        return $this->postFillInQuestionnaire;
    }
    /**
     * Set postFillInQuestionnaire value
     * @param string $postFillInQuestionnaire
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setPostFillInQuestionnaire($postFillInQuestionnaire = null)
    {
        // validation for constraint: string
        if (!is_null($postFillInQuestionnaire) && !is_string($postFillInQuestionnaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postFillInQuestionnaire, true), gettype($postFillInQuestionnaire)), __LINE__);
        }
        $this->postFillInQuestionnaire = $postFillInQuestionnaire;
        return $this;
    }
    /**
     * Get fullNameResponsible value
     * @return string|null
     */
    public function getFullNameResponsible()
    {
        return $this->fullNameResponsible;
    }
    /**
     * Set fullNameResponsible value
     * @param string $fullNameResponsible
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setFullNameResponsible($fullNameResponsible = null)
    {
        // validation for constraint: string
        if (!is_null($fullNameResponsible) && !is_string($fullNameResponsible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullNameResponsible, true), gettype($fullNameResponsible)), __LINE__);
        }
        $this->fullNameResponsible = $fullNameResponsible;
        return $this;
    }
    /**
     * Get postResponsible value
     * @return string|null
     */
    public function getPostResponsible()
    {
        return $this->postResponsible;
    }
    /**
     * Set postResponsible value
     * @param string $postResponsible
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setPostResponsible($postResponsible = null)
    {
        // validation for constraint: string
        if (!is_null($postResponsible) && !is_string($postResponsible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postResponsible, true), gettype($postResponsible)), __LINE__);
        }
        $this->postResponsible = $postResponsible;
        return $this;
    }
    /**
     * Get dateFillInQuestionnaire value
     * @return anySimpleType|null
     */
    public function getDateFillInQuestionnaire()
    {
        return $this->dateFillInQuestionnaire;
    }
    /**
     * Set dateFillInQuestionnaire value
     * @param anySimpleType $dateFillInQuestionnaire
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setDateFillInQuestionnaire(anySimpleType $dateFillInQuestionnaire = null)
    {
        $this->dateFillInQuestionnaire = $dateFillInQuestionnaire;
        return $this;
    }
    /**
     * Get dateUpdateQuestionnaire value
     * @return anySimpleType|null
     */
    public function getDateUpdateQuestionnaire()
    {
        return $this->dateUpdateQuestionnaire;
    }
    /**
     * Set dateUpdateQuestionnaire value
     * @param anySimpleType $dateUpdateQuestionnaire
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setDateUpdateQuestionnaire(anySimpleType $dateUpdateQuestionnaire = null)
    {
        $this->dateUpdateQuestionnaire = $dateUpdateQuestionnaire;
        return $this;
    }
    /**
     * Get startDateRelations value
     * @return anySimpleType|null
     */
    public function getStartDateRelations()
    {
        return $this->startDateRelations;
    }
    /**
     * Set startDateRelations value
     * @param anySimpleType $startDateRelations
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setStartDateRelations(anySimpleType $startDateRelations = null)
    {
        $this->startDateRelations = $startDateRelations;
        return $this;
    }
    /**
     * Get justificationNotIdentVigod value
     * @return \StructType\JustificationNotIdentVigodInfo|null
     */
    public function getJustificationNotIdentVigod()
    {
        return $this->justificationNotIdentVigod;
    }
    /**
     * Set justificationNotIdentVigod value
     * @param \StructType\JustificationNotIdentVigodInfo $justificationNotIdentVigod
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setJustificationNotIdentVigod(\StructType\JustificationNotIdentVigodInfo $justificationNotIdentVigod = null)
    {
        $this->justificationNotIdentVigod = $justificationNotIdentVigod;
        return $this;
    }
    /**
     * Get beneficiari value
     * @return \StructType\IdentifBeneficiarListInfo|null
     */
    public function getBeneficiari()
    {
        return $this->beneficiari;
    }
    /**
     * Set beneficiari value
     * @param \StructType\IdentifBeneficiarListInfo $beneficiari
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setBeneficiari(\StructType\IdentifBeneficiarListInfo $beneficiari = null)
    {
        $this->beneficiari = $beneficiari;
        return $this;
    }
    /**
     * Get representatives value
     * @return \StructType\PredstavitelListInfo|null
     */
    public function getRepresentatives()
    {
        return $this->representatives;
    }
    /**
     * Set representatives value
     * @param \StructType\PredstavitelListInfo $representatives
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setRepresentatives(\StructType\PredstavitelListInfo $representatives = null)
    {
        $this->representatives = $representatives;
        return $this;
    }
    /**
     * Get isOneTimeBusinessRelationship value
     * @return bool|null
     */
    public function getIsOneTimeBusinessRelationship()
    {
        return $this->isOneTimeBusinessRelationship;
    }
    /**
     * Set isOneTimeBusinessRelationship value
     * @param bool $isOneTimeBusinessRelationship
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setIsOneTimeBusinessRelationship($isOneTimeBusinessRelationship = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOneTimeBusinessRelationship) && !is_bool($isOneTimeBusinessRelationship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOneTimeBusinessRelationship, true), gettype($isOneTimeBusinessRelationship)), __LINE__);
        }
        $this->isOneTimeBusinessRelationship = $isOneTimeBusinessRelationship;
        return $this;
    }
    /**
     * Get informationConfirmingControl value
     * @return string|null
     */
    public function getInformationConfirmingControl()
    {
        return $this->informationConfirmingControl;
    }
    /**
     * Set informationConfirmingControl value
     * @param string $informationConfirmingControl
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setInformationConfirmingControl($informationConfirmingControl = null)
    {
        // validation for constraint: string
        if (!is_null($informationConfirmingControl) && !is_string($informationConfirmingControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($informationConfirmingControl, true), gettype($informationConfirmingControl)), __LINE__);
        }
        $this->informationConfirmingControl = $informationConfirmingControl;
        return $this;
    }
    /**
     * Get fullNameEmployerPDL value
     * @return string|null
     */
    public function getFullNameEmployerPDL()
    {
        return $this->fullNameEmployerPDL;
    }
    /**
     * Set fullNameEmployerPDL value
     * @param string $fullNameEmployerPDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setFullNameEmployerPDL($fullNameEmployerPDL = null)
    {
        // validation for constraint: string
        if (!is_null($fullNameEmployerPDL) && !is_string($fullNameEmployerPDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullNameEmployerPDL, true), gettype($fullNameEmployerPDL)), __LINE__);
        }
        $this->fullNameEmployerPDL = $fullNameEmployerPDL;
        return $this;
    }
    /**
     * Get postEmployerPDL value
     * @return string|null
     */
    public function getPostEmployerPDL()
    {
        return $this->postEmployerPDL;
    }
    /**
     * Set postEmployerPDL value
     * @param string $postEmployerPDL
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setPostEmployerPDL($postEmployerPDL = null)
    {
        // validation for constraint: string
        if (!is_null($postEmployerPDL) && !is_string($postEmployerPDL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postEmployerPDL, true), gettype($postEmployerPDL)), __LINE__);
        }
        $this->postEmployerPDL = $postEmployerPDL;
        return $this;
    }
    /**
     * Get docResponsible value
     * @return \StructType\DocumentInfo|null
     */
    public function getDocResponsible()
    {
        return $this->docResponsible;
    }
    /**
     * Set docResponsible value
     * @param \StructType\DocumentInfo $docResponsible
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setDocResponsible(\StructType\DocumentInfo $docResponsible = null)
    {
        $this->docResponsible = $docResponsible;
        return $this;
    }
    /**
     * Get dateOfTerminationOfRelations value
     * @return anySimpleType|null
     */
    public function getDateOfTerminationOfRelations()
    {
        return $this->dateOfTerminationOfRelations;
    }
    /**
     * Set dateOfTerminationOfRelations value
     * @param anySimpleType $dateOfTerminationOfRelations
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setDateOfTerminationOfRelations(anySimpleType $dateOfTerminationOfRelations = null)
    {
        $this->dateOfTerminationOfRelations = $dateOfTerminationOfRelations;
        return $this;
    }
    /**
     * Get sourceOfIncome value
     * @return string|null
     */
    public function getSourceOfIncome()
    {
        return $this->sourceOfIncome;
    }
    /**
     * Set sourceOfIncome value
     * @param string $sourceOfIncome
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setSourceOfIncome($sourceOfIncome = null)
    {
        // validation for constraint: string
        if (!is_null($sourceOfIncome) && !is_string($sourceOfIncome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceOfIncome, true), gettype($sourceOfIncome)), __LINE__);
        }
        $this->sourceOfIncome = $sourceOfIncome;
        return $this;
    }
    /**
     * Get numberSolutionsConfessionsOfTerrorists value
     * @return string|null
     */
    public function getNumberSolutionsConfessionsOfTerrorists()
    {
        return $this->numberSolutionsConfessionsOfTerrorists;
    }
    /**
     * Set numberSolutionsConfessionsOfTerrorists value
     * @param string $numberSolutionsConfessionsOfTerrorists
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setNumberSolutionsConfessionsOfTerrorists($numberSolutionsConfessionsOfTerrorists = null)
    {
        // validation for constraint: string
        if (!is_null($numberSolutionsConfessionsOfTerrorists) && !is_string($numberSolutionsConfessionsOfTerrorists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberSolutionsConfessionsOfTerrorists, true), gettype($numberSolutionsConfessionsOfTerrorists)), __LINE__);
        }
        $this->numberSolutionsConfessionsOfTerrorists = $numberSolutionsConfessionsOfTerrorists;
        return $this;
    }
    /**
     * Get dateSolutionsConfessionsOfTerrorists value
     * @return anySimpleType|null
     */
    public function getDateSolutionsConfessionsOfTerrorists()
    {
        return $this->dateSolutionsConfessionsOfTerrorists;
    }
    /**
     * Set dateSolutionsConfessionsOfTerrorists value
     * @param anySimpleType $dateSolutionsConfessionsOfTerrorists
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setDateSolutionsConfessionsOfTerrorists(anySimpleType $dateSolutionsConfessionsOfTerrorists = null)
    {
        $this->dateSolutionsConfessionsOfTerrorists = $dateSolutionsConfessionsOfTerrorists;
        return $this;
    }
    /**
     * Get businessLicense value
     * @return \StructType\BusinessLicenseList|null
     */
    public function getBusinessLicense()
    {
        return $this->businessLicense;
    }
    /**
     * Set businessLicense value
     * @param \StructType\BusinessLicenseList $businessLicense
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setBusinessLicense(\StructType\BusinessLicenseList $businessLicense = null)
    {
        $this->businessLicense = $businessLicense;
        return $this;
    }
    /**
     * Get finAndEconomicActivityPurposes value
     * @return string|null
     */
    public function getFinAndEconomicActivityPurposes()
    {
        return $this->finAndEconomicActivityPurposes;
    }
    /**
     * Set finAndEconomicActivityPurposes value
     * @param string $finAndEconomicActivityPurposes
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setFinAndEconomicActivityPurposes($finAndEconomicActivityPurposes = null)
    {
        // validation for constraint: string
        if (!is_null($finAndEconomicActivityPurposes) && !is_string($finAndEconomicActivityPurposes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finAndEconomicActivityPurposes, true), gettype($finAndEconomicActivityPurposes)), __LINE__);
        }
        $this->finAndEconomicActivityPurposes = $finAndEconomicActivityPurposes;
        return $this;
    }
    /**
     * Get insolvencyProceedings value
     * @return bool|null
     */
    public function getInsolvencyProceedings()
    {
        return $this->insolvencyProceedings;
    }
    /**
     * Set insolvencyProceedings value
     * @param bool $insolvencyProceedings
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setInsolvencyProceedings($insolvencyProceedings = null)
    {
        // validation for constraint: boolean
        if (!is_null($insolvencyProceedings) && !is_bool($insolvencyProceedings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($insolvencyProceedings, true), gettype($insolvencyProceedings)), __LINE__);
        }
        $this->insolvencyProceedings = $insolvencyProceedings;
        return $this;
    }
    /**
     * Get sourcesOfIncomeList value
     * @return \StructType\SourcesOfIncome|null
     */
    public function getSourcesOfIncomeList()
    {
        return $this->sourcesOfIncomeList;
    }
    /**
     * Set sourcesOfIncomeList value
     * @param \StructType\SourcesOfIncome $sourcesOfIncomeList
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setSourcesOfIncomeList(\StructType\SourcesOfIncome $sourcesOfIncomeList = null)
    {
        $this->sourcesOfIncomeList = $sourcesOfIncomeList;
        return $this;
    }
    /**
     * Get sourcesOfIncomePDLList value
     * @return \StructType\SourcesOfIncome|null
     */
    public function getSourcesOfIncomePDLList()
    {
        return $this->sourcesOfIncomePDLList;
    }
    /**
     * Set sourcesOfIncomePDLList value
     * @param \StructType\SourcesOfIncome $sourcesOfIncomePDLList
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setSourcesOfIncomePDLList(\StructType\SourcesOfIncome $sourcesOfIncomePDLList = null)
    {
        $this->sourcesOfIncomePDLList = $sourcesOfIncomePDLList;
        return $this;
    }
    /**
     * Get engagedInPrivatePractice value
     * @return bool|null
     */
    public function getEngagedInPrivatePractice()
    {
        return $this->engagedInPrivatePractice;
    }
    /**
     * Set engagedInPrivatePractice value
     * @param bool $engagedInPrivatePractice
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setEngagedInPrivatePractice($engagedInPrivatePractice = null)
    {
        // validation for constraint: boolean
        if (!is_null($engagedInPrivatePractice) && !is_bool($engagedInPrivatePractice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($engagedInPrivatePractice, true), gettype($engagedInPrivatePractice)), __LINE__);
        }
        $this->engagedInPrivatePractice = $engagedInPrivatePractice;
        return $this;
    }
    /**
     * Get typeOfPrivatePractice value
     * @return string|null
     */
    public function getTypeOfPrivatePractice()
    {
        return $this->typeOfPrivatePractice;
    }
    /**
     * Set typeOfPrivatePractice value
     * @uses \EnumType\TypeOfPrivatePractice::valueIsValid()
     * @uses \EnumType\TypeOfPrivatePractice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfPrivatePractice
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setTypeOfPrivatePractice($typeOfPrivatePractice = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeOfPrivatePractice::valueIsValid($typeOfPrivatePractice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeOfPrivatePractice', is_array($typeOfPrivatePractice) ? implode(', ', $typeOfPrivatePractice) : var_export($typeOfPrivatePractice, true), implode(', ', \EnumType\TypeOfPrivatePractice::getValidValues())), __LINE__);
        }
        $this->typeOfPrivatePractice = $typeOfPrivatePractice;
        return $this;
    }
    /**
     * Get registrationNumberOfPrivatePractice value
     * @return string|null
     */
    public function getRegistrationNumberOfPrivatePractice()
    {
        return $this->registrationNumberOfPrivatePractice;
    }
    /**
     * Set registrationNumberOfPrivatePractice value
     * @param string $registrationNumberOfPrivatePractice
     * @return \StructType\PhysicalIdentificationDataInfo
     */
    public function setRegistrationNumberOfPrivatePractice($registrationNumberOfPrivatePractice = null)
    {
        // validation for constraint: string
        if (!is_null($registrationNumberOfPrivatePractice) && !is_string($registrationNumberOfPrivatePractice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationNumberOfPrivatePractice, true), gettype($registrationNumberOfPrivatePractice)), __LINE__);
        }
        $this->registrationNumberOfPrivatePractice = $registrationNumberOfPrivatePractice;
        return $this;
    }
}
