<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParamDefaultValuesList StructType
 * @subpackage Structs
 */
class ParamDefaultValuesList extends AbstractStructBase
{
    /**
     * The parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParametrInfo[]
     */
    public $parameter;
    /**
     * Constructor method for ParamDefaultValuesList
     * @uses ParamDefaultValuesList::setParameter()
     * @param \StructType\ParametrInfo[] $parameter
     */
    public function __construct(array $parameter = array())
    {
        $this
            ->setParameter($parameter);
    }
    /**
     * Get parameter value
     * @return \StructType\ParametrInfo[]|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * This method is responsible for validating the values passed to the setParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParameterForArrayConstraintsFromSetParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paramDefaultValuesListParameterItem) {
            // validation for constraint: itemType
            if (!$paramDefaultValuesListParameterItem instanceof \StructType\ParametrInfo) {
                $invalidValues[] = is_object($paramDefaultValuesListParameterItem) ? get_class($paramDefaultValuesListParameterItem) : sprintf('%s(%s)', gettype($paramDefaultValuesListParameterItem), var_export($paramDefaultValuesListParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parameter property can only contain items of type \StructType\ParametrInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\ParametrInfo[] $parameter
     * @return \StructType\ParamDefaultValuesList
     */
    public function setParameter(array $parameter = array())
    {
        // validation for constraint: array
        if ('' !== ($parameterArrayErrorMessage = self::validateParameterForArrayConstraintsFromSetParameter($parameter))) {
            throw new \InvalidArgumentException($parameterArrayErrorMessage, __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Add item to parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\ParametrInfo $item
     * @return \StructType\ParamDefaultValuesList
     */
    public function addToParameter(\StructType\ParametrInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParametrInfo) {
            throw new \InvalidArgumentException(sprintf('The parameter property can only contain items of type \StructType\ParametrInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parameter[] = $item;
        return $this;
    }
}
