<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketProgrList StructType
 * @subpackage Structs
 */
class MarketProgrList extends AbstractStructBase
{
    /**
     * The marketProgr
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $marketProgr;
    /**
     * Constructor method for MarketProgrList
     * @uses MarketProgrList::setMarketProgr()
     * @param string[] $marketProgr
     */
    public function __construct(array $marketProgr = array())
    {
        $this
            ->setMarketProgr($marketProgr);
    }
    /**
     * Get marketProgr value
     * @return string[]|null
     */
    public function getMarketProgr()
    {
        return $this->marketProgr;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketProgr method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketProgr method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketProgrForArrayConstraintsFromSetMarketProgr(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $marketProgrListMarketProgrItem) {
            // validation for constraint: itemType
            if (!is_string($marketProgrListMarketProgrItem)) {
                $invalidValues[] = is_object($marketProgrListMarketProgrItem) ? get_class($marketProgrListMarketProgrItem) : sprintf('%s(%s)', gettype($marketProgrListMarketProgrItem), var_export($marketProgrListMarketProgrItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The marketProgr property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set marketProgr value
     * @throws \InvalidArgumentException
     * @param string[] $marketProgr
     * @return \StructType\MarketProgrList
     */
    public function setMarketProgr(array $marketProgr = array())
    {
        // validation for constraint: array
        if ('' !== ($marketProgrArrayErrorMessage = self::validateMarketProgrForArrayConstraintsFromSetMarketProgr($marketProgr))) {
            throw new \InvalidArgumentException($marketProgrArrayErrorMessage, __LINE__);
        }
        $this->marketProgr = $marketProgr;
        return $this;
    }
    /**
     * Add item to marketProgr value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MarketProgrList
     */
    public function addToMarketProgr($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The marketProgr property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->marketProgr[] = $item;
        return $this;
    }
}
