<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPaymentURLRequest StructType
 * @subpackage Structs
 */
class GetPaymentURLRequest extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The paymentSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentSystem;
    /**
     * The successUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $successUrl;
    /**
     * The failUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $failUrl;
    /**
     * Constructor method for GetPaymentURLRequest
     * @uses GetPaymentURLRequest::setAccID()
     * @uses GetPaymentURLRequest::setPolicyID()
     * @uses GetPaymentURLRequest::setPaymentSystem()
     * @uses GetPaymentURLRequest::setSuccessUrl()
     * @uses GetPaymentURLRequest::setFailUrl()
     * @param string $accID
     * @param string $policyID
     * @param string $paymentSystem
     * @param string $successUrl
     * @param string $failUrl
     */
    public function __construct($accID = null, $policyID = null, $paymentSystem = null, $successUrl = null, $failUrl = null)
    {
        $this
            ->setAccID($accID)
            ->setPolicyID($policyID)
            ->setPaymentSystem($paymentSystem)
            ->setSuccessUrl($successUrl)
            ->setFailUrl($failUrl);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\GetPaymentURLRequest
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \StructType\GetPaymentURLRequest
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: string
        if (!is_null($policyID) && !is_string($policyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get paymentSystem value
     * @return string|null
     */
    public function getPaymentSystem()
    {
        return $this->paymentSystem;
    }
    /**
     * Set paymentSystem value
     * @param string $paymentSystem
     * @return \StructType\GetPaymentURLRequest
     */
    public function setPaymentSystem($paymentSystem = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSystem) && !is_string($paymentSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSystem, true), gettype($paymentSystem)), __LINE__);
        }
        $this->paymentSystem = $paymentSystem;
        return $this;
    }
    /**
     * Get successUrl value
     * @return string|null
     */
    public function getSuccessUrl()
    {
        return $this->successUrl;
    }
    /**
     * Set successUrl value
     * @param string $successUrl
     * @return \StructType\GetPaymentURLRequest
     */
    public function setSuccessUrl($successUrl = null)
    {
        // validation for constraint: string
        if (!is_null($successUrl) && !is_string($successUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($successUrl, true), gettype($successUrl)), __LINE__);
        }
        $this->successUrl = $successUrl;
        return $this;
    }
    /**
     * Get failUrl value
     * @return string|null
     */
    public function getFailUrl()
    {
        return $this->failUrl;
    }
    /**
     * Set failUrl value
     * @param string $failUrl
     * @return \StructType\GetPaymentURLRequest
     */
    public function setFailUrl($failUrl = null)
    {
        // validation for constraint: string
        if (!is_null($failUrl) && !is_string($failUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failUrl, true), gettype($failUrl)), __LINE__);
        }
        $this->failUrl = $failUrl;
        return $this;
    }
}
