<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The detailMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $detailMessage;
    /**
     * Constructor method for Error
     * @uses Error::setMessage()
     * @uses Error::setType()
     * @uses Error::setDetailMessage()
     * @param string $message
     * @param string $type
     * @param string $detailMessage
     */
    public function __construct($message = null, $type = null, $detailMessage = null)
    {
        $this
            ->setMessage($message)
            ->setType($type)
            ->setDetailMessage($detailMessage);
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Error
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Error
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get detailMessage value
     * @return string|null
     */
    public function getDetailMessage()
    {
        return $this->detailMessage;
    }
    /**
     * Set detailMessage value
     * @param string $detailMessage
     * @return \StructType\Error
     */
    public function setDetailMessage($detailMessage = null)
    {
        // validation for constraint: string
        if (!is_null($detailMessage) && !is_string($detailMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailMessage, true), gettype($detailMessage)), __LINE__);
        }
        $this->detailMessage = $detailMessage;
        return $this;
    }
}
