<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentList StructType
 * @subpackage Structs
 */
class DocumentList extends AbstractStructBase
{
    /**
     * The document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentInfo[]
     */
    public $document;
    /**
     * Constructor method for DocumentList
     * @uses DocumentList::setDocument()
     * @param \StructType\DocumentInfo[] $document
     */
    public function __construct(array $document = array())
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get document value
     * @return \StructType\DocumentInfo[]|null
     */
    public function getDocument()
    {
        return $this->document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentListDocumentItem) {
            // validation for constraint: itemType
            if (!$documentListDocumentItem instanceof \StructType\DocumentInfo) {
                $invalidValues[] = is_object($documentListDocumentItem) ? get_class($documentListDocumentItem) : sprintf('%s(%s)', gettype($documentListDocumentItem), var_export($documentListDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The document property can only contain items of type \StructType\DocumentInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentInfo[] $document
     * @return \StructType\DocumentList
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->document = $document;
        return $this;
    }
    /**
     * Add item to document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentInfo $item
     * @return \StructType\DocumentList
     */
    public function addToDocument(\StructType\DocumentInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentInfo) {
            throw new \InvalidArgumentException(sprintf('The document property can only contain items of type \StructType\DocumentInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->document[] = $item;
        return $this;
    }
}
