<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dissolution StructType
 * Meta information extracted from the WSDL
 * - type: tns:Dissolution
 * @subpackage Structs
 */
class Dissolution extends AbstractStructBase
{
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The seriaPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seriaPolicy;
    /**
     * The numberPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numberPolicy;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The dateOfEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateOfEvent;
    /**
     * The refundSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $refundSum;
    /**
     * Constructor method for Dissolution
     * @uses Dissolution::setPolicyID()
     * @uses Dissolution::setProductType()
     * @uses Dissolution::setSeriaPolicy()
     * @uses Dissolution::setNumberPolicy()
     * @uses Dissolution::setReason()
     * @uses Dissolution::setDate()
     * @uses Dissolution::setDateOfEvent()
     * @uses Dissolution::setRefundSum()
     * @param string $policyID
     * @param string $productType
     * @param string $seriaPolicy
     * @param string $numberPolicy
     * @param string $reason
     * @param string $date
     * @param string $dateOfEvent
     * @param float $refundSum
     */
    public function __construct($policyID = null, $productType = null, $seriaPolicy = null, $numberPolicy = null, $reason = null, $date = null, $dateOfEvent = null, $refundSum = null)
    {
        $this
            ->setPolicyID($policyID)
            ->setProductType($productType)
            ->setSeriaPolicy($seriaPolicy)
            ->setNumberPolicy($numberPolicy)
            ->setReason($reason)
            ->setDate($date)
            ->setDateOfEvent($dateOfEvent)
            ->setRefundSum($refundSum);
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \StructType\Dissolution
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: string
        if (!is_null($policyID) && !is_string($policyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \StructType\Dissolution
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get seriaPolicy value
     * @return string|null
     */
    public function getSeriaPolicy()
    {
        return $this->seriaPolicy;
    }
    /**
     * Set seriaPolicy value
     * @param string $seriaPolicy
     * @return \StructType\Dissolution
     */
    public function setSeriaPolicy($seriaPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($seriaPolicy) && !is_string($seriaPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriaPolicy, true), gettype($seriaPolicy)), __LINE__);
        }
        $this->seriaPolicy = $seriaPolicy;
        return $this;
    }
    /**
     * Get numberPolicy value
     * @return string|null
     */
    public function getNumberPolicy()
    {
        return $this->numberPolicy;
    }
    /**
     * Set numberPolicy value
     * @param string $numberPolicy
     * @return \StructType\Dissolution
     */
    public function setNumberPolicy($numberPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($numberPolicy) && !is_string($numberPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberPolicy, true), gettype($numberPolicy)), __LINE__);
        }
        $this->numberPolicy = $numberPolicy;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\Dissolution
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\Dissolution
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get dateOfEvent value
     * @return string|null
     */
    public function getDateOfEvent()
    {
        return $this->dateOfEvent;
    }
    /**
     * Set dateOfEvent value
     * @param string $dateOfEvent
     * @return \StructType\Dissolution
     */
    public function setDateOfEvent($dateOfEvent = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfEvent) && !is_string($dateOfEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfEvent, true), gettype($dateOfEvent)), __LINE__);
        }
        $this->dateOfEvent = $dateOfEvent;
        return $this;
    }
    /**
     * Get refundSum value
     * @return float|null
     */
    public function getRefundSum()
    {
        return $this->refundSum;
    }
    /**
     * Set refundSum value
     * @param float $refundSum
     * @return \StructType\Dissolution
     */
    public function setRefundSum($refundSum = null)
    {
        // validation for constraint: float
        if (!is_null($refundSum) && !(is_float($refundSum) || is_numeric($refundSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refundSum, true), gettype($refundSum)), __LINE__);
        }
        $this->refundSum = $refundSum;
        return $this;
    }
}
