<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryTypeList StructType
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryTypeList
 * @subpackage Structs
 */
class DictionaryTypeList extends AbstractStructBase
{
    /**
     * The DictionaryType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:DictionaryType
     * @var \StructType\DictionaryType[]
     */
    public $DictionaryType;
    /**
     * Constructor method for DictionaryTypeList
     * @uses DictionaryTypeList::setDictionaryType()
     * @param \StructType\DictionaryType[] $dictionaryType
     */
    public function __construct(array $dictionaryType = array())
    {
        $this
            ->setDictionaryType($dictionaryType);
    }
    /**
     * Get DictionaryType value
     * @return \StructType\DictionaryType[]|null
     */
    public function getDictionaryType()
    {
        return $this->DictionaryType;
    }
    /**
     * This method is responsible for validating the values passed to the setDictionaryType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDictionaryType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDictionaryTypeForArrayConstraintsFromSetDictionaryType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dictionaryTypeListDictionaryTypeItem) {
            // validation for constraint: itemType
            if (!$dictionaryTypeListDictionaryTypeItem instanceof \StructType\DictionaryType) {
                $invalidValues[] = is_object($dictionaryTypeListDictionaryTypeItem) ? get_class($dictionaryTypeListDictionaryTypeItem) : sprintf('%s(%s)', gettype($dictionaryTypeListDictionaryTypeItem), var_export($dictionaryTypeListDictionaryTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DictionaryType property can only contain items of type \StructType\DictionaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DictionaryType value
     * @throws \InvalidArgumentException
     * @param \StructType\DictionaryType[] $dictionaryType
     * @return \StructType\DictionaryTypeList
     */
    public function setDictionaryType(array $dictionaryType = array())
    {
        // validation for constraint: array
        if ('' !== ($dictionaryTypeArrayErrorMessage = self::validateDictionaryTypeForArrayConstraintsFromSetDictionaryType($dictionaryType))) {
            throw new \InvalidArgumentException($dictionaryTypeArrayErrorMessage, __LINE__);
        }
        $this->DictionaryType = $dictionaryType;
        return $this;
    }
    /**
     * Add item to DictionaryType value
     * @throws \InvalidArgumentException
     * @param \StructType\DictionaryType $item
     * @return \StructType\DictionaryTypeList
     */
    public function addToDictionaryType(\StructType\DictionaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DictionaryType) {
            throw new \InvalidArgumentException(sprintf('The DictionaryType property can only contain items of type \StructType\DictionaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DictionaryType[] = $item;
        return $this;
    }
}
