<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryList StructType
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryList
 * @subpackage Structs
 */
class DictionaryList extends AbstractStructBase
{
    /**
     * The Types
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DictionaryTypeList
     */
    public $Types;
    /**
     * The Dictionary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Dictionary
     * @var \StructType\Dictionary[]
     */
    public $Dictionary;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $Errors;
    /**
     * Constructor method for DictionaryList
     * @uses DictionaryList::setTypes()
     * @uses DictionaryList::setDictionary()
     * @uses DictionaryList::setErrors()
     * @param \StructType\DictionaryTypeList $types
     * @param \StructType\Dictionary[] $dictionary
     * @param \StructType\ErrorList $errors
     */
    public function __construct(\StructType\DictionaryTypeList $types = null, array $dictionary = array(), \StructType\ErrorList $errors = null)
    {
        $this
            ->setTypes($types)
            ->setDictionary($dictionary)
            ->setErrors($errors);
    }
    /**
     * Get Types value
     * @return \StructType\DictionaryTypeList|null
     */
    public function getTypes()
    {
        return $this->Types;
    }
    /**
     * Set Types value
     * @param \StructType\DictionaryTypeList $types
     * @return \StructType\DictionaryList
     */
    public function setTypes(\StructType\DictionaryTypeList $types = null)
    {
        $this->Types = $types;
        return $this;
    }
    /**
     * Get Dictionary value
     * @return \StructType\Dictionary[]|null
     */
    public function getDictionary()
    {
        return $this->Dictionary;
    }
    /**
     * This method is responsible for validating the values passed to the setDictionary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDictionary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDictionaryForArrayConstraintsFromSetDictionary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dictionaryListDictionaryItem) {
            // validation for constraint: itemType
            if (!$dictionaryListDictionaryItem instanceof \StructType\Dictionary) {
                $invalidValues[] = is_object($dictionaryListDictionaryItem) ? get_class($dictionaryListDictionaryItem) : sprintf('%s(%s)', gettype($dictionaryListDictionaryItem), var_export($dictionaryListDictionaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dictionary property can only contain items of type \StructType\Dictionary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dictionary value
     * @throws \InvalidArgumentException
     * @param \StructType\Dictionary[] $dictionary
     * @return \StructType\DictionaryList
     */
    public function setDictionary(array $dictionary = array())
    {
        // validation for constraint: array
        if ('' !== ($dictionaryArrayErrorMessage = self::validateDictionaryForArrayConstraintsFromSetDictionary($dictionary))) {
            throw new \InvalidArgumentException($dictionaryArrayErrorMessage, __LINE__);
        }
        $this->Dictionary = $dictionary;
        return $this;
    }
    /**
     * Add item to Dictionary value
     * @throws \InvalidArgumentException
     * @param \StructType\Dictionary $item
     * @return \StructType\DictionaryList
     */
    public function addToDictionary(\StructType\Dictionary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dictionary) {
            throw new \InvalidArgumentException(sprintf('The Dictionary property can only contain items of type \StructType\Dictionary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dictionary[] = $item;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\DictionaryList
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
}
