<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalcListCodes StructType
 * Meta information extracted from the WSDL
 * - type: tns:CalcListCodes
 * @subpackage Structs
 */
class CalcListCodes extends AbstractStructBase
{
    /**
     * The CalcCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CalcCode;
    /**
     * Constructor method for CalcListCodes
     * @uses CalcListCodes::setCalcCode()
     * @param string[] $calcCode
     */
    public function __construct(array $calcCode = array())
    {
        $this
            ->setCalcCode($calcCode);
    }
    /**
     * Get CalcCode value
     * @return string[]|null
     */
    public function getCalcCode()
    {
        return $this->CalcCode;
    }
    /**
     * This method is responsible for validating the values passed to the setCalcCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCalcCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCalcCodeForArrayConstraintsFromSetCalcCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calcListCodesCalcCodeItem) {
            // validation for constraint: itemType
            if (!is_string($calcListCodesCalcCodeItem)) {
                $invalidValues[] = is_object($calcListCodesCalcCodeItem) ? get_class($calcListCodesCalcCodeItem) : sprintf('%s(%s)', gettype($calcListCodesCalcCodeItem), var_export($calcListCodesCalcCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CalcCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CalcCode value
     * @throws \InvalidArgumentException
     * @param string[] $calcCode
     * @return \StructType\CalcListCodes
     */
    public function setCalcCode(array $calcCode = array())
    {
        // validation for constraint: array
        if ('' !== ($calcCodeArrayErrorMessage = self::validateCalcCodeForArrayConstraintsFromSetCalcCode($calcCode))) {
            throw new \InvalidArgumentException($calcCodeArrayErrorMessage, __LINE__);
        }
        $this->CalcCode = $calcCode;
        return $this;
    }
    /**
     * Add item to CalcCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CalcListCodes
     */
    public function addToCalcCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CalcCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CalcCode[] = $item;
        return $this;
    }
}
