<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankRequisites StructType
 * @subpackage Structs
 */
class BankRequisites extends AbstractStructBase
{
    /**
     * The bank
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bank;
    /**
     * The bankBIK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankBIK;
    /**
     * The paymentAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentAccount;
    /**
     * The personalAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $personalAccount;
    /**
     * The correspAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $correspAccount;
    /**
     * The bankKPP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankKPP;
    /**
     * Constructor method for BankRequisites
     * @uses BankRequisites::setBank()
     * @uses BankRequisites::setBankBIK()
     * @uses BankRequisites::setPaymentAccount()
     * @uses BankRequisites::setPersonalAccount()
     * @uses BankRequisites::setCorrespAccount()
     * @uses BankRequisites::setBankKPP()
     * @param string $bank
     * @param string $bankBIK
     * @param string $paymentAccount
     * @param string $personalAccount
     * @param string $correspAccount
     * @param string $bankKPP
     */
    public function __construct($bank = null, $bankBIK = null, $paymentAccount = null, $personalAccount = null, $correspAccount = null, $bankKPP = null)
    {
        $this
            ->setBank($bank)
            ->setBankBIK($bankBIK)
            ->setPaymentAccount($paymentAccount)
            ->setPersonalAccount($personalAccount)
            ->setCorrespAccount($correspAccount)
            ->setBankKPP($bankKPP);
    }
    /**
     * Get bank value
     * @return string|null
     */
    public function getBank()
    {
        return $this->bank;
    }
    /**
     * Set bank value
     * @param string $bank
     * @return \StructType\BankRequisites
     */
    public function setBank($bank = null)
    {
        // validation for constraint: string
        if (!is_null($bank) && !is_string($bank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank, true), gettype($bank)), __LINE__);
        }
        $this->bank = $bank;
        return $this;
    }
    /**
     * Get bankBIK value
     * @return string|null
     */
    public function getBankBIK()
    {
        return $this->bankBIK;
    }
    /**
     * Set bankBIK value
     * @param string $bankBIK
     * @return \StructType\BankRequisites
     */
    public function setBankBIK($bankBIK = null)
    {
        // validation for constraint: string
        if (!is_null($bankBIK) && !is_string($bankBIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankBIK, true), gettype($bankBIK)), __LINE__);
        }
        $this->bankBIK = $bankBIK;
        return $this;
    }
    /**
     * Get paymentAccount value
     * @return string|null
     */
    public function getPaymentAccount()
    {
        return $this->paymentAccount;
    }
    /**
     * Set paymentAccount value
     * @param string $paymentAccount
     * @return \StructType\BankRequisites
     */
    public function setPaymentAccount($paymentAccount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAccount) && !is_string($paymentAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentAccount, true), gettype($paymentAccount)), __LINE__);
        }
        $this->paymentAccount = $paymentAccount;
        return $this;
    }
    /**
     * Get personalAccount value
     * @return string|null
     */
    public function getPersonalAccount()
    {
        return $this->personalAccount;
    }
    /**
     * Set personalAccount value
     * @param string $personalAccount
     * @return \StructType\BankRequisites
     */
    public function setPersonalAccount($personalAccount = null)
    {
        // validation for constraint: string
        if (!is_null($personalAccount) && !is_string($personalAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personalAccount, true), gettype($personalAccount)), __LINE__);
        }
        $this->personalAccount = $personalAccount;
        return $this;
    }
    /**
     * Get correspAccount value
     * @return string|null
     */
    public function getCorrespAccount()
    {
        return $this->correspAccount;
    }
    /**
     * Set correspAccount value
     * @param string $correspAccount
     * @return \StructType\BankRequisites
     */
    public function setCorrespAccount($correspAccount = null)
    {
        // validation for constraint: string
        if (!is_null($correspAccount) && !is_string($correspAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correspAccount, true), gettype($correspAccount)), __LINE__);
        }
        $this->correspAccount = $correspAccount;
        return $this;
    }
    /**
     * Get bankKPP value
     * @return string|null
     */
    public function getBankKPP()
    {
        return $this->bankKPP;
    }
    /**
     * Set bankKPP value
     * @param string $bankKPP
     * @return \StructType\BankRequisites
     */
    public function setBankKPP($bankKPP = null)
    {
        // validation for constraint: string
        if (!is_null($bankKPP) && !is_string($bankKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankKPP, true), gettype($bankKPP)), __LINE__);
        }
        $this->bankKPP = $bankKPP;
        return $this;
    }
}
