<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Log ServiceType
 * @subpackage Services
 */
class Log extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named logOut
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $logOut
     * @return \StructType\LogOutResponse|bool
     */
    public function logOut($logOut)
    {
        try {
            $this->setResult($this->getSoapClient()->logOut($logOut));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named logIn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoginRequest $logIn
     * @return \StructType\LoginResponse|bool
     */
    public function logIn(\StructType\LoginRequest $logIn)
    {
        try {
            $this->setResult($this->getSoapClient()->logIn($logIn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoginResponse|\StructType\LogOutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
