<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportPolicyRequest $importPolicy
     * @return \StructType\ImportPolicyResponse|bool
     */
    public function importPolicy(\StructType\ImportPolicyRequest $importPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->importPolicy($importPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importPolicyWOValidation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportPolicyRequest $importPolicyWOValidation
     * @return \StructType\ImportPolicyWOValidateResponse|bool
     */
    public function importPolicyWOValidation(\StructType\ImportPolicyRequest $importPolicyWOValidation)
    {
        try {
            $this->setResult($this->getSoapClient()->importPolicyWOValidation($importPolicyWOValidation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImportPolicyResponse|\StructType\ImportPolicyWOValidateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
