<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calc ServiceType
 * @subpackage Services
 */
class Calc extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named calcByProductType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalcInsPremRequest $calcByProductType
     * @return \StructType\CalcInsPremResponse|bool
     */
    public function calcByProductType(\StructType\CalcInsPremRequest $calcByProductType)
    {
        try {
            $this->setResult($this->getSoapClient()->calcByProductType($calcByProductType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CalcInsPremResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
