<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Annul ServiceType
 * @subpackage Services
 */
class Annul extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named annulPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AnnulPolicyRequest $annulPolicy
     * @return \StructType\AnnulPolicyResponse|bool
     */
    public function annulPolicy(\StructType\AnnulPolicyRequest $annulPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->annulPolicy($annulPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AnnulPolicyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
