<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DocumentType EnumType
 * @subpackage Enumerations
 */
class DocumentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Паспорт гражданина РФ'
     * @return string 'Паспорт гражданина РФ'
     */
    const VALUE_ПАСПОРТ_ГРАЖДАНИНА_РФ = 'Паспорт гражданина РФ';
    /**
     * Constant for value 'Загранпаспорт гражданина РФ'
     * @return string 'Загранпаспорт гражданина РФ'
     */
    const VALUE_ЗАГРАНПАСПОРТ_ГРАЖДАНИНА_РФ = 'Загранпаспорт гражданина РФ';
    /**
     * Constant for value 'Свидетельство о рождении'
     * @return string 'Свидетельство о рождении'
     */
    const VALUE_СВИДЕТЕЛЬСТВО_О_РОЖДЕНИИ = 'Свидетельство о рождении';
    /**
     * Constant for value 'Удостоверение личности офицера'
     * @return string 'Удостоверение личности офицера'
     */
    const VALUE_УДОСТОВЕРЕНИЕ_ЛИЧНОСТИ_ОФИЦЕРА = 'Удостоверение личности офицера';
    /**
     * Constant for value 'Справка об освобождении из мест
     * лишения свободы'
     * @return string 'Справка об освобождении из мест лишения свободы'
     */
    const VALUE_СПРАВКА_ОБ_ОСВОБОЖДЕНИИ_ИЗ_МЕСТ_ЛИШЕНИЯ_СВОБОДЫ = 'Справка об освобождении из мест лишения свободы';
    /**
     * Constant for value 'Паспорт Минморфлота'
     * @return string 'Паспорт Минморфлота'
     */
    const VALUE_ПАСПОРТ_МИНМОРФЛОТА = 'Паспорт Минморфлота';
    /**
     * Constant for value 'Военный билет солдата (матроса,
     * сержанта, старшины)'
     * @return string 'Военный билет солдата (матроса, сержанта, старшины)'
     */
    const VALUE_ВОЕННЫЙ_БИЛЕТ_СОЛДАТА_МАТРОСА_СЕРЖАНТА_СТАРШИНЫ = 'Военный билет солдата (матроса, сержанта, старшины)';
    /**
     * Constant for value 'Дипломатический паспорт
     * гражданина РФ'
     * @return string 'Дипломатический паспорт гражданина РФ'
     */
    const VALUE_ДИПЛОМАТИЧЕСКИЙ_ПАСПОРТ_ГРАЖДАНИНА_РФ = 'Дипломатический паспорт гражданина РФ';
    /**
     * Constant for value 'Иностранный паспорт'
     * @return string 'Иностранный паспорт'
     */
    const VALUE_ИНОСТРАННЫЙ_ПАСПОРТ = 'Иностранный паспорт';
    /**
     * Constant for value 'Свидетельство о регистрации
     * ходатайства иммигранта о признании его
     * беженцем'
     * @return string 'Свидетельство о регистрации ходатайства иммигранта о признании его беженцем'
     */
    const VALUE_СВИДЕТЕЛЬСТВО_О_РЕГИСТРАЦИИ_ХОДАТАЙСТВА_ИММИГРАНТА_О_ПРИЗНАНИИ_ЕГО_БЕЖЕНЦЕМ = 'Свидетельство о регистрации ходатайства иммигранта о признании его беженцем';
    /**
     * Constant for value 'Вид на жительство'
     * @return string 'Вид на жительство'
     */
    const VALUE_ВИД_НА_ЖИТЕЛЬСТВО = 'Вид на жительство';
    /**
     * Constant for value 'Удостоверение беженца в РФ'
     * @return string 'Удостоверение беженца в РФ'
     */
    const VALUE_УДОСТОВЕРЕНИЕ_БЕЖЕНЦА_В_РФ = 'Удостоверение беженца в РФ';
    /**
     * Constant for value 'Временное удостоверение
     * личности гражданина РФ'
     * @return string 'Временное удостоверение личности гражданина РФ'
     */
    const VALUE_ВРЕМЕННОЕ_УДОСТОВЕРЕНИЕ_ЛИЧНОСТИ_ГРАЖДАНИНА_РФ = 'Временное удостоверение личности гражданина РФ';
    /**
     * Constant for value 'Свидетельство о рождении,
     * выданное уполномоченным органом
     * иностранного государства'
     * @return string 'Свидетельство о рождении, выданное уполномоченным органом иностранного государства'
     */
    const VALUE_СВИДЕТЕЛЬСТВО_О_РОЖДЕНИИ_ВЫДАННОЕ_УПОЛНОМОЧЕННЫМ_ОРГАНОМ_ИНОСТРАННОГО_ГОСУДАРСТВА = 'Свидетельство о рождении, выданное уполномоченным органом иностранного государства';
    /**
     * Constant for value 'Паспорт моряка'
     * @return string 'Паспорт моряка'
     */
    const VALUE_ПАСПОРТ_МОРЯКА = 'Паспорт моряка';
    /**
     * Constant for value 'Военный билет офицера запаса'
     * @return string 'Военный билет офицера запаса'
     */
    const VALUE_ВОЕННЫЙ_БИЛЕТ_ОФИЦЕРА_ЗАПАСА = 'Военный билет офицера запаса';
    /**
     * Constant for value 'Справка о регистрации в органах
     * МВД России'
     * @return string 'Справка о регистрации в органах МВД России'
     */
    const VALUE_СПРАВКА_О_РЕГИСТРАЦИИ_В_ОРГАНАХ_МВД_РОССИИ = 'Справка о регистрации в органах МВД России';
    /**
     * Constant for value 'Паспорт гражданина СССР'
     * @return string 'Паспорт гражданина СССР'
     */
    const VALUE_ПАСПОРТ_ГРАЖДАНИНА_СССР = 'Паспорт гражданина СССР';
    /**
     * Constant for value 'Загранпаспорт гражданина СССР'
     * @return string 'Загранпаспорт гражданина СССР'
     */
    const VALUE_ЗАГРАНПАСПОРТ_ГРАЖДАНИНА_СССР = 'Загранпаспорт гражданина СССР';
    /**
     * Constant for value 'Водительское удостоверение РФ'
     * @return string 'Водительское удостоверение РФ'
     */
    const VALUE_ВОДИТЕЛЬСКОЕ_УДОСТОВЕРЕНИЕ_РФ = 'Водительское удостоверение РФ';
    /**
     * Constant for value 'Водительское удостоверение
     * тракториста-машиниста РФ'
     * @return string 'Водительское удостоверение тракториста-машиниста РФ'
     */
    const VALUE_ВОДИТЕЛЬСКОЕ_УДОСТОВЕРЕНИЕ_ТРАКТОРИСТА_МАШИНИСТА_РФ = 'Водительское удостоверение тракториста-машиниста РФ';
    /**
     * Constant for value 'Свидетельство о смерти'
     * @return string 'Свидетельство о смерти'
     */
    const VALUE_СВИДЕТЕЛЬСТВО_О_СМЕРТИ = 'Свидетельство о смерти';
    /**
     * Constant for value 'Водительское удостоверение
     * иностранного государства'
     * @return string 'Водительское удостоверение иностранного государства'
     */
    const VALUE_ВОДИТЕЛЬСКОЕ_УДОСТОВЕРЕНИЕ_ИНОСТРАННОГО_ГОСУДАРСТВА = 'Водительское удостоверение иностранного государства';
    /**
     * Constant for value 'Другие документы'
     * @return string 'Другие документы'
     */
    const VALUE_ДРУГИЕ_ДОКУМЕНТЫ = 'Другие документы';
    /**
     * Constant for value 'Свидетельство о регистрации ЮЛ'
     * @return string 'Свидетельство о регистрации ЮЛ'
     */
    const VALUE_СВИДЕТЕЛЬСТВО_О_РЕГИСТРАЦИИ_ЮЛ = 'Свидетельство о регистрации ЮЛ';
    /**
     * Constant for value 'Свидетельство о государственной
     * регистрации физического лица в качестве
     * индивидуального предпринимателя'
     * @return string 'Свидетельство о государственной регистрации физического лица в качестве индивидуального предпринимателя'
     */
    const VALUE_СВИДЕТЕЛЬСТВО_О_ГОСУДАРСТВЕННОЙ_РЕГИСТРАЦИИ_ФИЗИЧЕСКОГО_ЛИЦА_В_КАЧЕСТВЕ_ИНДИВИДУАЛЬНОГО_ПРЕДПРИНИМАТЕЛЯ = 'Свидетельство о государственной регистрации физического лица в качестве индивидуального предпринимателя';
    /**
     * Constant for value 'Миграционная карта'
     * @return string 'Миграционная карта'
     */
    const VALUE_МИГРАЦИОННАЯ_КАРТА = 'Миграционная карта';
    /**
     * Constant for value 'Лист записи ЕГРЮЛ о регистрации
     * ЮЛ'
     * @return string 'Лист записи ЕГРЮЛ о регистрации ЮЛ'
     */
    const VALUE_ЛИСТ_ЗАПИСИ_ЕГРЮЛ_О_РЕГИСТРАЦИИ_ЮЛ = 'Лист записи ЕГРЮЛ о регистрации ЮЛ';
    /**
     * Constant for value 'Документ, подтверждающий право
     * на пребывание в РФ'
     * @return string 'Документ, подтверждающий право на пребывание в РФ'
     */
    const VALUE_ДОКУМЕНТ_ПОДТВЕРЖДАЮЩИЙ_ПРАВО_НА_ПРЕБЫВАНИЕ_В_РФ = 'Документ, подтверждающий право на пребывание в РФ';
    /**
     * Constant for value 'Информационное письмо Росстата
     * о включении организации в состав ЕГРПО'
     * @return string 'Информационное письмо Росстата о включении организации в состав ЕГРПО'
     */
    const VALUE_ИНФОРМАЦИОННОЕ_ПИСЬМО_РОССТАТА_О_ВКЛЮЧЕНИИ_ОРГАНИЗАЦИИ_В_СОСТАВ_ЕГРПО = 'Информационное письмо Росстата о включении организации в состав ЕГРПО';
    /**
     * Constant for value 'Выписка из единого
     * государственного реестра юридических лиц
     * (ЕГРЮЛ)'
     * @return string 'Выписка из единого государственного реестра юридических лиц (ЕГРЮЛ)'
     */
    const VALUE_ВЫПИСКА_ИЗ_ЕДИНОГО_ГОСУДАРСТВЕННОГО_РЕЕСТРА_ЮРИДИЧЕСКИХ_ЛИЦ_ЕГРЮЛ = 'Выписка из единого государственного реестра юридических лиц (ЕГРЮЛ)';
    /**
     * Return allowed values
     * @uses self::VALUE_ПАСПОРТ_ГРАЖДАНИНА_РФ
     * @uses self::VALUE_ЗАГРАНПАСПОРТ_ГРАЖДАНИНА_РФ
     * @uses self::VALUE_СВИДЕТЕЛЬСТВО_О_РОЖДЕНИИ
     * @uses self::VALUE_УДОСТОВЕРЕНИЕ_ЛИЧНОСТИ_ОФИЦЕРА
     * @uses self::VALUE_СПРАВКА_ОБ_ОСВОБОЖДЕНИИ_ИЗ_МЕСТ_ЛИШЕНИЯ_СВОБОДЫ
     * @uses self::VALUE_ПАСПОРТ_МИНМОРФЛОТА
     * @uses self::VALUE_ВОЕННЫЙ_БИЛЕТ_СОЛДАТА_МАТРОСА_СЕРЖАНТА_СТАРШИНЫ
     * @uses self::VALUE_ДИПЛОМАТИЧЕСКИЙ_ПАСПОРТ_ГРАЖДАНИНА_РФ
     * @uses self::VALUE_ИНОСТРАННЫЙ_ПАСПОРТ
     * @uses self::VALUE_СВИДЕТЕЛЬСТВО_О_РЕГИСТРАЦИИ_ХОДАТАЙСТВА_ИММИГРАНТА_О_ПРИЗНАНИИ_ЕГО_БЕЖЕНЦЕМ
     * @uses self::VALUE_ВИД_НА_ЖИТЕЛЬСТВО
     * @uses self::VALUE_УДОСТОВЕРЕНИЕ_БЕЖЕНЦА_В_РФ
     * @uses self::VALUE_ВРЕМЕННОЕ_УДОСТОВЕРЕНИЕ_ЛИЧНОСТИ_ГРАЖДАНИНА_РФ
     * @uses self::VALUE_СВИДЕТЕЛЬСТВО_О_РОЖДЕНИИ_ВЫДАННОЕ_УПОЛНОМОЧЕННЫМ_ОРГАНОМ_ИНОСТРАННОГО_ГОСУДАРСТВА
     * @uses self::VALUE_ПАСПОРТ_МОРЯКА
     * @uses self::VALUE_ВОЕННЫЙ_БИЛЕТ_ОФИЦЕРА_ЗАПАСА
     * @uses self::VALUE_СПРАВКА_О_РЕГИСТРАЦИИ_В_ОРГАНАХ_МВД_РОССИИ
     * @uses self::VALUE_ПАСПОРТ_ГРАЖДАНИНА_СССР
     * @uses self::VALUE_ЗАГРАНПАСПОРТ_ГРАЖДАНИНА_СССР
     * @uses self::VALUE_ВОДИТЕЛЬСКОЕ_УДОСТОВЕРЕНИЕ_РФ
     * @uses self::VALUE_ВОДИТЕЛЬСКОЕ_УДОСТОВЕРЕНИЕ_ТРАКТОРИСТА_МАШИНИСТА_РФ
     * @uses self::VALUE_СВИДЕТЕЛЬСТВО_О_СМЕРТИ
     * @uses self::VALUE_ВОДИТЕЛЬСКОЕ_УДОСТОВЕРЕНИЕ_ИНОСТРАННОГО_ГОСУДАРСТВА
     * @uses self::VALUE_ДРУГИЕ_ДОКУМЕНТЫ
     * @uses self::VALUE_СВИДЕТЕЛЬСТВО_О_РЕГИСТРАЦИИ_ЮЛ
     * @uses self::VALUE_СВИДЕТЕЛЬСТВО_О_ГОСУДАРСТВЕННОЙ_РЕГИСТРАЦИИ_ФИЗИЧЕСКОГО_ЛИЦА_В_КАЧЕСТВЕ_ИНДИВИДУАЛЬНОГО_ПРЕДПРИНИМАТЕЛЯ
     * @uses self::VALUE_МИГРАЦИОННАЯ_КАРТА
     * @uses self::VALUE_ЛИСТ_ЗАПИСИ_ЕГРЮЛ_О_РЕГИСТРАЦИИ_ЮЛ
     * @uses self::VALUE_ДОКУМЕНТ_ПОДТВЕРЖДАЮЩИЙ_ПРАВО_НА_ПРЕБЫВАНИЕ_В_РФ
     * @uses self::VALUE_ИНФОРМАЦИОННОЕ_ПИСЬМО_РОССТАТА_О_ВКЛЮЧЕНИИ_ОРГАНИЗАЦИИ_В_СОСТАВ_ЕГРПО
     * @uses self::VALUE_ВЫПИСКА_ИЗ_ЕДИНОГО_ГОСУДАРСТВЕННОГО_РЕЕСТРА_ЮРИДИЧЕСКИХ_ЛИЦ_ЕГРЮЛ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ПАСПОРТ_ГРАЖДАНИНА_РФ,
            self::VALUE_ЗАГРАНПАСПОРТ_ГРАЖДАНИНА_РФ,
            self::VALUE_СВИДЕТЕЛЬСТВО_О_РОЖДЕНИИ,
            self::VALUE_УДОСТОВЕРЕНИЕ_ЛИЧНОСТИ_ОФИЦЕРА,
            self::VALUE_СПРАВКА_ОБ_ОСВОБОЖДЕНИИ_ИЗ_МЕСТ_ЛИШЕНИЯ_СВОБОДЫ,
            self::VALUE_ПАСПОРТ_МИНМОРФЛОТА,
            self::VALUE_ВОЕННЫЙ_БИЛЕТ_СОЛДАТА_МАТРОСА_СЕРЖАНТА_СТАРШИНЫ,
            self::VALUE_ДИПЛОМАТИЧЕСКИЙ_ПАСПОРТ_ГРАЖДАНИНА_РФ,
            self::VALUE_ИНОСТРАННЫЙ_ПАСПОРТ,
            self::VALUE_СВИДЕТЕЛЬСТВО_О_РЕГИСТРАЦИИ_ХОДАТАЙСТВА_ИММИГРАНТА_О_ПРИЗНАНИИ_ЕГО_БЕЖЕНЦЕМ,
            self::VALUE_ВИД_НА_ЖИТЕЛЬСТВО,
            self::VALUE_УДОСТОВЕРЕНИЕ_БЕЖЕНЦА_В_РФ,
            self::VALUE_ВРЕМЕННОЕ_УДОСТОВЕРЕНИЕ_ЛИЧНОСТИ_ГРАЖДАНИНА_РФ,
            self::VALUE_СВИДЕТЕЛЬСТВО_О_РОЖДЕНИИ_ВЫДАННОЕ_УПОЛНОМОЧЕННЫМ_ОРГАНОМ_ИНОСТРАННОГО_ГОСУДАРСТВА,
            self::VALUE_ПАСПОРТ_МОРЯКА,
            self::VALUE_ВОЕННЫЙ_БИЛЕТ_ОФИЦЕРА_ЗАПАСА,
            self::VALUE_СПРАВКА_О_РЕГИСТРАЦИИ_В_ОРГАНАХ_МВД_РОССИИ,
            self::VALUE_ПАСПОРТ_ГРАЖДАНИНА_СССР,
            self::VALUE_ЗАГРАНПАСПОРТ_ГРАЖДАНИНА_СССР,
            self::VALUE_ВОДИТЕЛЬСКОЕ_УДОСТОВЕРЕНИЕ_РФ,
            self::VALUE_ВОДИТЕЛЬСКОЕ_УДОСТОВЕРЕНИЕ_ТРАКТОРИСТА_МАШИНИСТА_РФ,
            self::VALUE_СВИДЕТЕЛЬСТВО_О_СМЕРТИ,
            self::VALUE_ВОДИТЕЛЬСКОЕ_УДОСТОВЕРЕНИЕ_ИНОСТРАННОГО_ГОСУДАРСТВА,
            self::VALUE_ДРУГИЕ_ДОКУМЕНТЫ,
            self::VALUE_СВИДЕТЕЛЬСТВО_О_РЕГИСТРАЦИИ_ЮЛ,
            self::VALUE_СВИДЕТЕЛЬСТВО_О_ГОСУДАРСТВЕННОЙ_РЕГИСТРАЦИИ_ФИЗИЧЕСКОГО_ЛИЦА_В_КАЧЕСТВЕ_ИНДИВИДУАЛЬНОГО_ПРЕДПРИНИМАТЕЛЯ,
            self::VALUE_МИГРАЦИОННАЯ_КАРТА,
            self::VALUE_ЛИСТ_ЗАПИСИ_ЕГРЮЛ_О_РЕГИСТРАЦИИ_ЮЛ,
            self::VALUE_ДОКУМЕНТ_ПОДТВЕРЖДАЮЩИЙ_ПРАВО_НА_ПРЕБЫВАНИЕ_В_РФ,
            self::VALUE_ИНФОРМАЦИОННОЕ_ПИСЬМО_РОССТАТА_О_ВКЛЮЧЕНИИ_ОРГАНИЗАЦИИ_В_СОСТАВ_ЕГРПО,
            self::VALUE_ВЫПИСКА_ИЗ_ЕДИНОГО_ГОСУДАРСТВЕННОГО_РЕЕСТРА_ЮРИДИЧЕСКИХ_ЛИЦ_ЕГРЮЛ,
        );
    }
}
