<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://testfo.allianz.ru/PO.Insurance/POInsuranceService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://testfo.allianz.ru/PO.Insurance/POInsuranceService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for searchPolicies operation/method
 */
if ($search->searchPolicies(new \StructType\SearchPoliciesRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getDictionaries operation/method
 */
if ($get->getDictionaries(new \StructType\GetDictionaries()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPolicy operation/method
 */
if ($get->getPolicy(new \StructType\GetPolicyRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPaymentURL operation/method
 */
if ($get->getPaymentURL(new \StructType\GetPaymentURLRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDictionaryAttributeValueByCode operation/method
 */
if ($get->getDictionaryAttributeValueByCode(new \StructType\GetDictionaryAttributeValueByCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDictionaryValueCodesByAttribute operation/method
 */
if ($get->getDictionaryValueCodesByAttribute(new \StructType\GetDictionaryValueCodesByAttribute()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getIssueProcessStatus operation/method
 */
if ($get->getIssueProcessStatus(new \StructType\GetIssueProcessStatusRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getHashByPolicyCalcId operation/method
 */
if ($get->getHashByPolicyCalcId(new \StructType\RequestsReplacePolicyOwnerRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllDictionariesExcel operation/method
 */
if ($get->getAllDictionariesExcel(new \StructType\GetAllDictionariesExcel()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDictionaryByCode operation/method
 */
if ($get->getDictionaryByCode(new \StructType\GetDictionaryByCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Log ServiceType
 */
$log = new \ServiceType\Log($options);
/**
 * Sample call for logOut operation/method
 */
if ($log->logOut($logOut) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Sample call for logIn operation/method
 */
if ($log->logIn(new \StructType\LoginRequest()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Samples for Issue ServiceType
 */
$issue = new \ServiceType\Issue($options);
/**
 * Sample call for issuePolicy operation/method
 */
if ($issue->issuePolicy(new \StructType\IssuePolicyRequest()) !== false) {
    print_r($issue->getResult());
} else {
    print_r($issue->getLastError());
}
/**
 * Sample call for issuePolicyAsync operation/method
 */
if ($issue->issuePolicyAsync(new \StructType\IssuePolicyAsyncRequest()) !== false) {
    print_r($issue->getResult());
} else {
    print_r($issue->getLastError());
}
/**
 * Samples for Annul ServiceType
 */
$annul = new \ServiceType\Annul($options);
/**
 * Sample call for annulPolicy operation/method
 */
if ($annul->annulPolicy(new \StructType\AnnulPolicyRequest()) !== false) {
    print_r($annul->getResult());
} else {
    print_r($annul->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
/**
 * Sample call for importPolicy operation/method
 */
if ($import->importPolicy(new \StructType\ImportPolicyRequest()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for importPolicyWOValidation operation/method
 */
if ($import->importPolicyWOValidation(new \StructType\ImportPolicyRequest()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Attach ServiceType
 */
$attach = new \ServiceType\Attach($options);
/**
 * Sample call for attachDocument operation/method
 */
if ($attach->attachDocument(new \StructType\AttachDocumentRequest()) !== false) {
    print_r($attach->getResult());
} else {
    print_r($attach->getLastError());
}
/**
 * Samples for Print ServiceType
 */
$print = new \ServiceType\_Print($options);
/**
 * Sample call for printPolicy operation/method
 */
if ($print->printPolicy(new \StructType\PrintPolicyRequest()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Sample call for printPolicyByState operation/method
 */
if ($print->printPolicyByState(new \StructType\PrintPolicyRequest()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Samples for Hide ServiceType
 */
$hide = new \ServiceType\Hide($options);
/**
 * Sample call for hideLogin operation/method
 */
if ($hide->hideLogin(new \StructType\HideLoginRequest()) !== false) {
    print_r($hide->getResult());
} else {
    print_r($hide->getLastError());
}
/**
 * Samples for Calc ServiceType
 */
$calc = new \ServiceType\Calc($options);
/**
 * Sample call for calcByProductType operation/method
 */
if ($calc->calcByProductType(new \StructType\CalcInsPremRequest()) !== false) {
    print_r($calc->getResult());
} else {
    print_r($calc->getLastError());
}
/**
 * Samples for Dissolution ServiceType
 */
$dissolution = new \ServiceType\Dissolution($options);
/**
 * Sample call for dissolutionPolicy operation/method
 */
if ($dissolution->dissolutionPolicy(new \StructType\DissolutionPolicyRequest()) !== false) {
    print_r($dissolution->getResult());
} else {
    print_r($dissolution->getLastError());
}
