<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UchreditelInfo StructType
 * @subpackage Structs
 */
class UchreditelInfo extends AbstractStructBase
{
    /**
     * The share
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $share;
    /**
     * The constitutor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectInfo
     */
    public $constitutor;
    /**
     * Constructor method for UchreditelInfo
     * @uses UchreditelInfo::setShare()
     * @uses UchreditelInfo::setConstitutor()
     * @param float $share
     * @param \StructType\SubjectInfo $constitutor
     */
    public function __construct($share = null, \StructType\SubjectInfo $constitutor = null)
    {
        $this
            ->setShare($share)
            ->setConstitutor($constitutor);
    }
    /**
     * Get share value
     * @return float|null
     */
    public function getShare()
    {
        return $this->share;
    }
    /**
     * Set share value
     * @param float $share
     * @return \StructType\UchreditelInfo
     */
    public function setShare($share = null)
    {
        // validation for constraint: float
        if (!is_null($share) && !(is_float($share) || is_numeric($share))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($share, true), gettype($share)), __LINE__);
        }
        $this->share = $share;
        return $this;
    }
    /**
     * Get constitutor value
     * @return \StructType\SubjectInfo|null
     */
    public function getConstitutor()
    {
        return $this->constitutor;
    }
    /**
     * Set constitutor value
     * @param \StructType\SubjectInfo $constitutor
     * @return \StructType\UchreditelInfo
     */
    public function setConstitutor(\StructType\SubjectInfo $constitutor = null)
    {
        $this->constitutor = $constitutor;
        return $this;
    }
}
