<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubjectListInfo StructType
 * @subpackage Structs
 */
class SubjectListInfo extends AbstractStructBase
{
    /**
     * The subject
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubjectInfo[]
     */
    public $subject;
    /**
     * Constructor method for SubjectListInfo
     * @uses SubjectListInfo::setSubject()
     * @param \StructType\SubjectInfo[] $subject
     */
    public function __construct(array $subject = array())
    {
        $this
            ->setSubject($subject);
    }
    /**
     * Get subject value
     * @return \StructType\SubjectInfo[]|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * This method is responsible for validating the values passed to the setSubject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubjectForArrayConstraintsFromSetSubject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subjectListInfoSubjectItem) {
            // validation for constraint: itemType
            if (!$subjectListInfoSubjectItem instanceof \StructType\SubjectInfo) {
                $invalidValues[] = is_object($subjectListInfoSubjectItem) ? get_class($subjectListInfoSubjectItem) : sprintf('%s(%s)', gettype($subjectListInfoSubjectItem), var_export($subjectListInfoSubjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subject property can only contain items of type \StructType\SubjectInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subject value
     * @throws \InvalidArgumentException
     * @param \StructType\SubjectInfo[] $subject
     * @return \StructType\SubjectListInfo
     */
    public function setSubject(array $subject = array())
    {
        // validation for constraint: array
        if ('' !== ($subjectArrayErrorMessage = self::validateSubjectForArrayConstraintsFromSetSubject($subject))) {
            throw new \InvalidArgumentException($subjectArrayErrorMessage, __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Add item to subject value
     * @throws \InvalidArgumentException
     * @param \StructType\SubjectInfo $item
     * @return \StructType\SubjectListInfo
     */
    public function addToSubject(\StructType\SubjectInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubjectInfo) {
            throw new \InvalidArgumentException(sprintf('The subject property can only contain items of type \StructType\SubjectInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subject[] = $item;
        return $this;
    }
}
