<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RiskInfo StructType
 * @subpackage Structs
 */
class RiskInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The insured
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $insured;
    /**
     * The insSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insSum;
    /**
     * The insSumCurrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insSumCurrCode;
    /**
     * The insPrem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insPrem;
    /**
     * The insPremCurrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insPremCurrCode;
    /**
     * The fransiza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fransiza;
    /**
     * The fransizaCurrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fransizaCurrCode;
    /**
     * The koefficients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\KoeffInfoList
     */
    public $koefficients;
    /**
     * The franchiseType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $franchiseType;
    /**
     * Constructor method for RiskInfo
     * @uses RiskInfo::setName()
     * @uses RiskInfo::setInsured()
     * @uses RiskInfo::setInsSum()
     * @uses RiskInfo::setInsSumCurrCode()
     * @uses RiskInfo::setInsPrem()
     * @uses RiskInfo::setInsPremCurrCode()
     * @uses RiskInfo::setFransiza()
     * @uses RiskInfo::setFransizaCurrCode()
     * @uses RiskInfo::setKoefficients()
     * @uses RiskInfo::setFranchiseType()
     * @param string $name
     * @param bool $insured
     * @param float $insSum
     * @param string $insSumCurrCode
     * @param float $insPrem
     * @param string $insPremCurrCode
     * @param float $fransiza
     * @param string $fransizaCurrCode
     * @param \StructType\KoeffInfoList $koefficients
     * @param string $franchiseType
     */
    public function __construct($name = null, $insured = null, $insSum = null, $insSumCurrCode = null, $insPrem = null, $insPremCurrCode = null, $fransiza = null, $fransizaCurrCode = null, \StructType\KoeffInfoList $koefficients = null, $franchiseType = null)
    {
        $this
            ->setName($name)
            ->setInsured($insured)
            ->setInsSum($insSum)
            ->setInsSumCurrCode($insSumCurrCode)
            ->setInsPrem($insPrem)
            ->setInsPremCurrCode($insPremCurrCode)
            ->setFransiza($fransiza)
            ->setFransizaCurrCode($fransizaCurrCode)
            ->setKoefficients($koefficients)
            ->setFranchiseType($franchiseType);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RiskInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get insured value
     * @return bool|null
     */
    public function getInsured()
    {
        return $this->insured;
    }
    /**
     * Set insured value
     * @param bool $insured
     * @return \StructType\RiskInfo
     */
    public function setInsured($insured = null)
    {
        // validation for constraint: boolean
        if (!is_null($insured) && !is_bool($insured)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($insured, true), gettype($insured)), __LINE__);
        }
        $this->insured = $insured;
        return $this;
    }
    /**
     * Get insSum value
     * @return float|null
     */
    public function getInsSum()
    {
        return $this->insSum;
    }
    /**
     * Set insSum value
     * @param float $insSum
     * @return \StructType\RiskInfo
     */
    public function setInsSum($insSum = null)
    {
        // validation for constraint: float
        if (!is_null($insSum) && !(is_float($insSum) || is_numeric($insSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insSum, true), gettype($insSum)), __LINE__);
        }
        $this->insSum = $insSum;
        return $this;
    }
    /**
     * Get insSumCurrCode value
     * @return string|null
     */
    public function getInsSumCurrCode()
    {
        return $this->insSumCurrCode;
    }
    /**
     * Set insSumCurrCode value
     * @param string $insSumCurrCode
     * @return \StructType\RiskInfo
     */
    public function setInsSumCurrCode($insSumCurrCode = null)
    {
        // validation for constraint: string
        if (!is_null($insSumCurrCode) && !is_string($insSumCurrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insSumCurrCode, true), gettype($insSumCurrCode)), __LINE__);
        }
        $this->insSumCurrCode = $insSumCurrCode;
        return $this;
    }
    /**
     * Get insPrem value
     * @return float|null
     */
    public function getInsPrem()
    {
        return $this->insPrem;
    }
    /**
     * Set insPrem value
     * @param float $insPrem
     * @return \StructType\RiskInfo
     */
    public function setInsPrem($insPrem = null)
    {
        // validation for constraint: float
        if (!is_null($insPrem) && !(is_float($insPrem) || is_numeric($insPrem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insPrem, true), gettype($insPrem)), __LINE__);
        }
        $this->insPrem = $insPrem;
        return $this;
    }
    /**
     * Get insPremCurrCode value
     * @return string|null
     */
    public function getInsPremCurrCode()
    {
        return $this->insPremCurrCode;
    }
    /**
     * Set insPremCurrCode value
     * @param string $insPremCurrCode
     * @return \StructType\RiskInfo
     */
    public function setInsPremCurrCode($insPremCurrCode = null)
    {
        // validation for constraint: string
        if (!is_null($insPremCurrCode) && !is_string($insPremCurrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insPremCurrCode, true), gettype($insPremCurrCode)), __LINE__);
        }
        $this->insPremCurrCode = $insPremCurrCode;
        return $this;
    }
    /**
     * Get fransiza value
     * @return float|null
     */
    public function getFransiza()
    {
        return $this->fransiza;
    }
    /**
     * Set fransiza value
     * @param float $fransiza
     * @return \StructType\RiskInfo
     */
    public function setFransiza($fransiza = null)
    {
        // validation for constraint: float
        if (!is_null($fransiza) && !(is_float($fransiza) || is_numeric($fransiza))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fransiza, true), gettype($fransiza)), __LINE__);
        }
        $this->fransiza = $fransiza;
        return $this;
    }
    /**
     * Get fransizaCurrCode value
     * @return string|null
     */
    public function getFransizaCurrCode()
    {
        return $this->fransizaCurrCode;
    }
    /**
     * Set fransizaCurrCode value
     * @param string $fransizaCurrCode
     * @return \StructType\RiskInfo
     */
    public function setFransizaCurrCode($fransizaCurrCode = null)
    {
        // validation for constraint: string
        if (!is_null($fransizaCurrCode) && !is_string($fransizaCurrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fransizaCurrCode, true), gettype($fransizaCurrCode)), __LINE__);
        }
        $this->fransizaCurrCode = $fransizaCurrCode;
        return $this;
    }
    /**
     * Get koefficients value
     * @return \StructType\KoeffInfoList|null
     */
    public function getKoefficients()
    {
        return $this->koefficients;
    }
    /**
     * Set koefficients value
     * @param \StructType\KoeffInfoList $koefficients
     * @return \StructType\RiskInfo
     */
    public function setKoefficients(\StructType\KoeffInfoList $koefficients = null)
    {
        $this->koefficients = $koefficients;
        return $this;
    }
    /**
     * Get franchiseType value
     * @return string|null
     */
    public function getFranchiseType()
    {
        return $this->franchiseType;
    }
    /**
     * Set franchiseType value
     * @uses \EnumType\FranchiseType::valueIsValid()
     * @uses \EnumType\FranchiseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $franchiseType
     * @return \StructType\RiskInfo
     */
    public function setFranchiseType($franchiseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FranchiseType::valueIsValid($franchiseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FranchiseType', is_array($franchiseType) ? implode(', ', $franchiseType) : var_export($franchiseType, true), implode(', ', \EnumType\FranchiseType::getValidValues())), __LINE__);
        }
        $this->franchiseType = $franchiseType;
        return $this;
    }
}
