<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintPolicyResponse StructType
 * @subpackage Structs
 */
class PrintPolicyResponse extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $errors;
    /**
     * The warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $warnings;
    /**
     * Constructor method for PrintPolicyResponse
     * @uses PrintPolicyResponse::setAccID()
     * @uses PrintPolicyResponse::setNumber()
     * @uses PrintPolicyResponse::setUrl()
     * @uses PrintPolicyResponse::setErrors()
     * @uses PrintPolicyResponse::setWarnings()
     * @param string $accID
     * @param string $number
     * @param string $url
     * @param \StructType\ErrorList $errors
     * @param \StructType\ErrorList $warnings
     */
    public function __construct($accID = null, $number = null, $url = null, \StructType\ErrorList $errors = null, \StructType\ErrorList $warnings = null)
    {
        $this
            ->setAccID($accID)
            ->setNumber($number)
            ->setUrl($url)
            ->setErrors($errors)
            ->setWarnings($warnings);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\PrintPolicyResponse
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\PrintPolicyResponse
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\PrintPolicyResponse
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\PrintPolicyResponse
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Get warnings value
     * @return \StructType\ErrorList|null
     */
    public function getWarnings()
    {
        return $this->warnings;
    }
    /**
     * Set warnings value
     * @param \StructType\ErrorList $warnings
     * @return \StructType\PrintPolicyResponse
     */
    public function setWarnings(\StructType\ErrorList $warnings = null)
    {
        $this->warnings = $warnings;
        return $this;
    }
}
