<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointOfSale StructType
 * Meta information extracted from the WSDL
 * - type: tns:PointOfSale
 * @subpackage Structs
 */
class PointOfSale extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The subdivisionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subdivisionId;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressInfo
     */
    public $address;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParametrList
     */
    public $parameters;
    /**
     * Constructor method for PointOfSale
     * @uses PointOfSale::setId()
     * @uses PointOfSale::setSubdivisionId()
     * @uses PointOfSale::setName()
     * @uses PointOfSale::setCode()
     * @uses PointOfSale::setPhone()
     * @uses PointOfSale::setAddress()
     * @uses PointOfSale::setParameters()
     * @param string $id
     * @param string $subdivisionId
     * @param string $name
     * @param string $code
     * @param string $phone
     * @param \StructType\AddressInfo $address
     * @param \StructType\ParametrList $parameters
     */
    public function __construct($id = null, $subdivisionId = null, $name = null, $code = null, $phone = null, \StructType\AddressInfo $address = null, \StructType\ParametrList $parameters = null)
    {
        $this
            ->setId($id)
            ->setSubdivisionId($subdivisionId)
            ->setName($name)
            ->setCode($code)
            ->setPhone($phone)
            ->setAddress($address)
            ->setParameters($parameters);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\PointOfSale
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get subdivisionId value
     * @return string|null
     */
    public function getSubdivisionId()
    {
        return $this->subdivisionId;
    }
    /**
     * Set subdivisionId value
     * @param string $subdivisionId
     * @return \StructType\PointOfSale
     */
    public function setSubdivisionId($subdivisionId = null)
    {
        // validation for constraint: string
        if (!is_null($subdivisionId) && !is_string($subdivisionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subdivisionId, true), gettype($subdivisionId)), __LINE__);
        }
        $this->subdivisionId = $subdivisionId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PointOfSale
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\PointOfSale
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\PointOfSale
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\AddressInfo|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\AddressInfo $address
     * @return \StructType\PointOfSale
     */
    public function setAddress(\StructType\AddressInfo $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\ParametrList|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\ParametrList $parameters
     * @return \StructType\PointOfSale
     */
    public function setParameters(\StructType\ParametrList $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
}
