<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentList StructType
 * @subpackage Structs
 */
class PaymentList extends AbstractStructBase
{
    /**
     * The payment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:payment
     * @var \StructType\Payment[]
     */
    public $payment;
    /**
     * Constructor method for PaymentList
     * @uses PaymentList::setPayment()
     * @param \StructType\Payment[] $payment
     */
    public function __construct(array $payment = array())
    {
        $this
            ->setPayment($payment);
    }
    /**
     * Get payment value
     * @return \StructType\Payment[]|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * This method is responsible for validating the values passed to the setPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentForArrayConstraintsFromSetPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentListPaymentItem) {
            // validation for constraint: itemType
            if (!$paymentListPaymentItem instanceof \StructType\Payment) {
                $invalidValues[] = is_object($paymentListPaymentItem) ? get_class($paymentListPaymentItem) : sprintf('%s(%s)', gettype($paymentListPaymentItem), var_export($paymentListPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The payment property can only contain items of type \StructType\Payment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set payment value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment[] $payment
     * @return \StructType\PaymentList
     */
    public function setPayment(array $payment = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentArrayErrorMessage = self::validatePaymentForArrayConstraintsFromSetPayment($payment))) {
            throw new \InvalidArgumentException($paymentArrayErrorMessage, __LINE__);
        }
        $this->payment = $payment;
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment $item
     * @return \StructType\PaymentList
     */
    public function addToPayment(\StructType\Payment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payment) {
            throw new \InvalidArgumentException(sprintf('The payment property can only contain items of type \StructType\Payment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->payment[] = $item;
        return $this;
    }
}
