<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The payer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectInfo
     */
    public $payer;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubjectInfo
     */
    public $owner;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $number;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The invoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoiceNumber;
    /**
     * The invoiceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $invoiceDate;
    /**
     * The sum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sum;
    /**
     * The paymentDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentDocument
     */
    public $paymentDocument;
    /**
     * The sumRur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sumRur;
    /**
     * The paymentRecepient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentRecepient;
    /**
     * The paymentMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentMethod;
    /**
     * The pointOfSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PointOfSale
     */
    public $pointOfSale;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParametrList
     */
    public $parameters;
    /**
     * The paymentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentDate;
    /**
     * The dateConfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateConfirmed;
    /**
     * The dateChanged
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateChanged;
    /**
     * The financial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $financial;
    /**
     * The cancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $cancelled;
    /**
     * The dateCancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateCancelled;
    /**
     * The agent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AgentSubject
     */
    public $agent;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The percentAV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentAV;
    /**
     * The percentDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentDiscount;
    /**
     * The percentAddAV
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentAddAV;
    /**
     * Constructor method for Payment
     * @uses Payment::setPolicyID()
     * @uses Payment::setPayer()
     * @uses Payment::setOwner()
     * @uses Payment::setNumber()
     * @uses Payment::setDate()
     * @uses Payment::setInvoiceNumber()
     * @uses Payment::setInvoiceDate()
     * @uses Payment::setSum()
     * @uses Payment::setPaymentDocument()
     * @uses Payment::setSumRur()
     * @uses Payment::setPaymentRecepient()
     * @uses Payment::setPaymentMethod()
     * @uses Payment::setPointOfSale()
     * @uses Payment::setParameters()
     * @uses Payment::setPaymentDate()
     * @uses Payment::setDateConfirmed()
     * @uses Payment::setDateChanged()
     * @uses Payment::setFinancial()
     * @uses Payment::setCancelled()
     * @uses Payment::setDateCancelled()
     * @uses Payment::setAgent()
     * @uses Payment::setCurrency()
     * @uses Payment::setExchangeRate()
     * @uses Payment::setType()
     * @uses Payment::setPercentAV()
     * @uses Payment::setPercentDiscount()
     * @uses Payment::setPercentAddAV()
     * @param string $policyID
     * @param \StructType\SubjectInfo $payer
     * @param \StructType\SubjectInfo $owner
     * @param int $number
     * @param string $date
     * @param string $invoiceNumber
     * @param string $invoiceDate
     * @param float $sum
     * @param \StructType\PaymentDocument $paymentDocument
     * @param float $sumRur
     * @param string $paymentRecepient
     * @param string $paymentMethod
     * @param \StructType\PointOfSale $pointOfSale
     * @param \StructType\ParametrList $parameters
     * @param string $paymentDate
     * @param string $dateConfirmed
     * @param string $dateChanged
     * @param bool $financial
     * @param bool $cancelled
     * @param string $dateCancelled
     * @param \StructType\AgentSubject $agent
     * @param string $currency
     * @param float $exchangeRate
     * @param string $type
     * @param float $percentAV
     * @param float $percentDiscount
     * @param float $percentAddAV
     */
    public function __construct($policyID = null, \StructType\SubjectInfo $payer = null, \StructType\SubjectInfo $owner = null, $number = null, $date = null, $invoiceNumber = null, $invoiceDate = null, $sum = null, \StructType\PaymentDocument $paymentDocument = null, $sumRur = null, $paymentRecepient = null, $paymentMethod = null, \StructType\PointOfSale $pointOfSale = null, \StructType\ParametrList $parameters = null, $paymentDate = null, $dateConfirmed = null, $dateChanged = null, $financial = null, $cancelled = null, $dateCancelled = null, \StructType\AgentSubject $agent = null, $currency = null, $exchangeRate = null, $type = null, $percentAV = null, $percentDiscount = null, $percentAddAV = null)
    {
        $this
            ->setPolicyID($policyID)
            ->setPayer($payer)
            ->setOwner($owner)
            ->setNumber($number)
            ->setDate($date)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDate($invoiceDate)
            ->setSum($sum)
            ->setPaymentDocument($paymentDocument)
            ->setSumRur($sumRur)
            ->setPaymentRecepient($paymentRecepient)
            ->setPaymentMethod($paymentMethod)
            ->setPointOfSale($pointOfSale)
            ->setParameters($parameters)
            ->setPaymentDate($paymentDate)
            ->setDateConfirmed($dateConfirmed)
            ->setDateChanged($dateChanged)
            ->setFinancial($financial)
            ->setCancelled($cancelled)
            ->setDateCancelled($dateCancelled)
            ->setAgent($agent)
            ->setCurrency($currency)
            ->setExchangeRate($exchangeRate)
            ->setType($type)
            ->setPercentAV($percentAV)
            ->setPercentDiscount($percentDiscount)
            ->setPercentAddAV($percentAddAV);
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \StructType\Payment
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: string
        if (!is_null($policyID) && !is_string($policyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get payer value
     * @return \StructType\SubjectInfo|null
     */
    public function getPayer()
    {
        return $this->payer;
    }
    /**
     * Set payer value
     * @param \StructType\SubjectInfo $payer
     * @return \StructType\Payment
     */
    public function setPayer(\StructType\SubjectInfo $payer = null)
    {
        $this->payer = $payer;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\SubjectInfo|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\SubjectInfo $owner
     * @return \StructType\Payment
     */
    public function setOwner(\StructType\SubjectInfo $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\Payment
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\Payment
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\Payment
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get invoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }
    /**
     * Set invoiceDate value
     * @param string $invoiceDate
     * @return \StructType\Payment
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->invoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get sum value
     * @return float|null
     */
    public function getSum()
    {
        return $this->sum;
    }
    /**
     * Set sum value
     * @param float $sum
     * @return \StructType\Payment
     */
    public function setSum($sum = null)
    {
        // validation for constraint: float
        if (!is_null($sum) && !(is_float($sum) || is_numeric($sum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sum, true), gettype($sum)), __LINE__);
        }
        $this->sum = $sum;
        return $this;
    }
    /**
     * Get paymentDocument value
     * @return \StructType\PaymentDocument|null
     */
    public function getPaymentDocument()
    {
        return $this->paymentDocument;
    }
    /**
     * Set paymentDocument value
     * @param \StructType\PaymentDocument $paymentDocument
     * @return \StructType\Payment
     */
    public function setPaymentDocument(\StructType\PaymentDocument $paymentDocument = null)
    {
        $this->paymentDocument = $paymentDocument;
        return $this;
    }
    /**
     * Get sumRur value
     * @return float|null
     */
    public function getSumRur()
    {
        return $this->sumRur;
    }
    /**
     * Set sumRur value
     * @param float $sumRur
     * @return \StructType\Payment
     */
    public function setSumRur($sumRur = null)
    {
        // validation for constraint: float
        if (!is_null($sumRur) && !(is_float($sumRur) || is_numeric($sumRur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sumRur, true), gettype($sumRur)), __LINE__);
        }
        $this->sumRur = $sumRur;
        return $this;
    }
    /**
     * Get paymentRecepient value
     * @return string|null
     */
    public function getPaymentRecepient()
    {
        return $this->paymentRecepient;
    }
    /**
     * Set paymentRecepient value
     * @uses \EnumType\PaymentRecepient::valueIsValid()
     * @uses \EnumType\PaymentRecepient::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentRecepient
     * @return \StructType\Payment
     */
    public function setPaymentRecepient($paymentRecepient = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentRecepient::valueIsValid($paymentRecepient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentRecepient', is_array($paymentRecepient) ? implode(', ', $paymentRecepient) : var_export($paymentRecepient, true), implode(', ', \EnumType\PaymentRecepient::getValidValues())), __LINE__);
        }
        $this->paymentRecepient = $paymentRecepient;
        return $this;
    }
    /**
     * Get paymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }
    /**
     * Set paymentMethod value
     * @param string $paymentMethod
     * @return \StructType\Payment
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->paymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get pointOfSale value
     * @return \StructType\PointOfSale|null
     */
    public function getPointOfSale()
    {
        return $this->pointOfSale;
    }
    /**
     * Set pointOfSale value
     * @param \StructType\PointOfSale $pointOfSale
     * @return \StructType\Payment
     */
    public function setPointOfSale(\StructType\PointOfSale $pointOfSale = null)
    {
        $this->pointOfSale = $pointOfSale;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\ParametrList|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\ParametrList $parameters
     * @return \StructType\Payment
     */
    public function setParameters(\StructType\ParametrList $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get paymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->paymentDate;
    }
    /**
     * Set paymentDate value
     * @param string $paymentDate
     * @return \StructType\Payment
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        $this->paymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get dateConfirmed value
     * @return string|null
     */
    public function getDateConfirmed()
    {
        return $this->dateConfirmed;
    }
    /**
     * Set dateConfirmed value
     * @param string $dateConfirmed
     * @return \StructType\Payment
     */
    public function setDateConfirmed($dateConfirmed = null)
    {
        // validation for constraint: string
        if (!is_null($dateConfirmed) && !is_string($dateConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateConfirmed, true), gettype($dateConfirmed)), __LINE__);
        }
        $this->dateConfirmed = $dateConfirmed;
        return $this;
    }
    /**
     * Get dateChanged value
     * @return string|null
     */
    public function getDateChanged()
    {
        return $this->dateChanged;
    }
    /**
     * Set dateChanged value
     * @param string $dateChanged
     * @return \StructType\Payment
     */
    public function setDateChanged($dateChanged = null)
    {
        // validation for constraint: string
        if (!is_null($dateChanged) && !is_string($dateChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateChanged, true), gettype($dateChanged)), __LINE__);
        }
        $this->dateChanged = $dateChanged;
        return $this;
    }
    /**
     * Get financial value
     * @return bool|null
     */
    public function getFinancial()
    {
        return $this->financial;
    }
    /**
     * Set financial value
     * @param bool $financial
     * @return \StructType\Payment
     */
    public function setFinancial($financial = null)
    {
        // validation for constraint: boolean
        if (!is_null($financial) && !is_bool($financial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($financial, true), gettype($financial)), __LINE__);
        }
        $this->financial = $financial;
        return $this;
    }
    /**
     * Get cancelled value
     * @return bool|null
     */
    public function getCancelled()
    {
        return $this->cancelled;
    }
    /**
     * Set cancelled value
     * @param bool $cancelled
     * @return \StructType\Payment
     */
    public function setCancelled($cancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancelled) && !is_bool($cancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancelled, true), gettype($cancelled)), __LINE__);
        }
        $this->cancelled = $cancelled;
        return $this;
    }
    /**
     * Get dateCancelled value
     * @return string|null
     */
    public function getDateCancelled()
    {
        return $this->dateCancelled;
    }
    /**
     * Set dateCancelled value
     * @param string $dateCancelled
     * @return \StructType\Payment
     */
    public function setDateCancelled($dateCancelled = null)
    {
        // validation for constraint: string
        if (!is_null($dateCancelled) && !is_string($dateCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCancelled, true), gettype($dateCancelled)), __LINE__);
        }
        $this->dateCancelled = $dateCancelled;
        return $this;
    }
    /**
     * Get agent value
     * @return \StructType\AgentSubject|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \StructType\AgentSubject $agent
     * @return \StructType\Payment
     */
    public function setAgent(\StructType\AgentSubject $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\Payment
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Payment
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Payment
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get percentAV value
     * @return float|null
     */
    public function getPercentAV()
    {
        return $this->percentAV;
    }
    /**
     * Set percentAV value
     * @param float $percentAV
     * @return \StructType\Payment
     */
    public function setPercentAV($percentAV = null)
    {
        // validation for constraint: float
        if (!is_null($percentAV) && !(is_float($percentAV) || is_numeric($percentAV))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentAV, true), gettype($percentAV)), __LINE__);
        }
        $this->percentAV = $percentAV;
        return $this;
    }
    /**
     * Get percentDiscount value
     * @return float|null
     */
    public function getPercentDiscount()
    {
        return $this->percentDiscount;
    }
    /**
     * Set percentDiscount value
     * @param float $percentDiscount
     * @return \StructType\Payment
     */
    public function setPercentDiscount($percentDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($percentDiscount) && !(is_float($percentDiscount) || is_numeric($percentDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentDiscount, true), gettype($percentDiscount)), __LINE__);
        }
        $this->percentDiscount = $percentDiscount;
        return $this;
    }
    /**
     * Get percentAddAV value
     * @return float|null
     */
    public function getPercentAddAV()
    {
        return $this->percentAddAV;
    }
    /**
     * Set percentAddAV value
     * @param float $percentAddAV
     * @return \StructType\Payment
     */
    public function setPercentAddAV($percentAddAV = null)
    {
        // validation for constraint: float
        if (!is_null($percentAddAV) && !(is_float($percentAddAV) || is_numeric($percentAddAV))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentAddAV, true), gettype($percentAddAV)), __LINE__);
        }
        $this->percentAddAV = $percentAddAV;
        return $this;
    }
}
