<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KoeffInfoList StructType
 * @subpackage Structs
 */
class KoeffInfoList extends AbstractStructBase
{
    /**
     * The koefficient
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KoeffInfo[]
     */
    public $koefficient;
    /**
     * Constructor method for KoeffInfoList
     * @uses KoeffInfoList::setKoefficient()
     * @param \StructType\KoeffInfo[] $koefficient
     */
    public function __construct(array $koefficient = array())
    {
        $this
            ->setKoefficient($koefficient);
    }
    /**
     * Get koefficient value
     * @return \StructType\KoeffInfo[]|null
     */
    public function getKoefficient()
    {
        return $this->koefficient;
    }
    /**
     * This method is responsible for validating the values passed to the setKoefficient method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKoefficient method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKoefficientForArrayConstraintsFromSetKoefficient(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $koeffInfoListKoefficientItem) {
            // validation for constraint: itemType
            if (!$koeffInfoListKoefficientItem instanceof \StructType\KoeffInfo) {
                $invalidValues[] = is_object($koeffInfoListKoefficientItem) ? get_class($koeffInfoListKoefficientItem) : sprintf('%s(%s)', gettype($koeffInfoListKoefficientItem), var_export($koeffInfoListKoefficientItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The koefficient property can only contain items of type \StructType\KoeffInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set koefficient value
     * @throws \InvalidArgumentException
     * @param \StructType\KoeffInfo[] $koefficient
     * @return \StructType\KoeffInfoList
     */
    public function setKoefficient(array $koefficient = array())
    {
        // validation for constraint: array
        if ('' !== ($koefficientArrayErrorMessage = self::validateKoefficientForArrayConstraintsFromSetKoefficient($koefficient))) {
            throw new \InvalidArgumentException($koefficientArrayErrorMessage, __LINE__);
        }
        $this->koefficient = $koefficient;
        return $this;
    }
    /**
     * Add item to koefficient value
     * @throws \InvalidArgumentException
     * @param \StructType\KoeffInfo $item
     * @return \StructType\KoeffInfoList
     */
    public function addToKoefficient(\StructType\KoeffInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KoeffInfo) {
            throw new \InvalidArgumentException(sprintf('The koefficient property can only contain items of type \StructType\KoeffInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->koefficient[] = $item;
        return $this;
    }
}
