<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssuePolicyResponse StructType
 * @subpackage Structs
 */
class IssuePolicyResponse extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $errors;
    /**
     * Constructor method for IssuePolicyResponse
     * @uses IssuePolicyResponse::setAccID()
     * @uses IssuePolicyResponse::setPolicyID()
     * @uses IssuePolicyResponse::setErrors()
     * @param string $accID
     * @param string $policyID
     * @param \StructType\ErrorList $errors
     */
    public function __construct($accID = null, $policyID = null, \StructType\ErrorList $errors = null)
    {
        $this
            ->setAccID($accID)
            ->setPolicyID($policyID)
            ->setErrors($errors);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\IssuePolicyResponse
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \StructType\IssuePolicyResponse
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: string
        if (!is_null($policyID) && !is_string($policyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\IssuePolicyResponse
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
}
