<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IssuePolicyAsyncResponse StructType
 * @subpackage Structs
 */
class IssuePolicyAsyncResponse extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorWithCodeList
     */
    public $errors;
    /**
     * The acceptedForProcessing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $acceptedForProcessing;
    /**
     * The isError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isError;
    /**
     * Constructor method for IssuePolicyAsyncResponse
     * @uses IssuePolicyAsyncResponse::setAccID()
     * @uses IssuePolicyAsyncResponse::setPolicyID()
     * @uses IssuePolicyAsyncResponse::setErrors()
     * @uses IssuePolicyAsyncResponse::setAcceptedForProcessing()
     * @uses IssuePolicyAsyncResponse::setIsError()
     * @param string $accID
     * @param string $policyID
     * @param \StructType\ErrorWithCodeList $errors
     * @param bool $acceptedForProcessing
     * @param bool $isError
     */
    public function __construct($accID = null, $policyID = null, \StructType\ErrorWithCodeList $errors = null, $acceptedForProcessing = null, $isError = null)
    {
        $this
            ->setAccID($accID)
            ->setPolicyID($policyID)
            ->setErrors($errors)
            ->setAcceptedForProcessing($acceptedForProcessing)
            ->setIsError($isError);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\IssuePolicyAsyncResponse
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \StructType\IssuePolicyAsyncResponse
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: string
        if (!is_null($policyID) && !is_string($policyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorWithCodeList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorWithCodeList $errors
     * @return \StructType\IssuePolicyAsyncResponse
     */
    public function setErrors(\StructType\ErrorWithCodeList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Get acceptedForProcessing value
     * @return bool|null
     */
    public function getAcceptedForProcessing()
    {
        return $this->acceptedForProcessing;
    }
    /**
     * Set acceptedForProcessing value
     * @param bool $acceptedForProcessing
     * @return \StructType\IssuePolicyAsyncResponse
     */
    public function setAcceptedForProcessing($acceptedForProcessing = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptedForProcessing) && !is_bool($acceptedForProcessing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acceptedForProcessing, true), gettype($acceptedForProcessing)), __LINE__);
        }
        $this->acceptedForProcessing = $acceptedForProcessing;
        return $this;
    }
    /**
     * Get isError value
     * @return bool|null
     */
    public function getIsError()
    {
        return $this->isError;
    }
    /**
     * Set isError value
     * @param bool $isError
     * @return \StructType\IssuePolicyAsyncResponse
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isError, true), gettype($isError)), __LINE__);
        }
        $this->isError = $isError;
        return $this;
    }
}
