<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceObjectList StructType
 * @subpackage Structs
 */
class InsuranceObjectList extends AbstractStructBase
{
    /**
     * The object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InsuranceObject[]
     */
    public $object;
    /**
     * Constructor method for InsuranceObjectList
     * @uses InsuranceObjectList::setObject()
     * @param \StructType\InsuranceObject[] $object
     */
    public function __construct(array $object = array())
    {
        $this
            ->setObject($object);
    }
    /**
     * Get object value
     * @return \StructType\InsuranceObject[]|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * This method is responsible for validating the values passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectForArrayConstraintsFromSetObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $insuranceObjectListObjectItem) {
            // validation for constraint: itemType
            if (!$insuranceObjectListObjectItem instanceof \StructType\InsuranceObject) {
                $invalidValues[] = is_object($insuranceObjectListObjectItem) ? get_class($insuranceObjectListObjectItem) : sprintf('%s(%s)', gettype($insuranceObjectListObjectItem), var_export($insuranceObjectListObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The object property can only contain items of type \StructType\InsuranceObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set object value
     * @throws \InvalidArgumentException
     * @param \StructType\InsuranceObject[] $object
     * @return \StructType\InsuranceObjectList
     */
    public function setObject(array $object = array())
    {
        // validation for constraint: array
        if ('' !== ($objectArrayErrorMessage = self::validateObjectForArrayConstraintsFromSetObject($object))) {
            throw new \InvalidArgumentException($objectArrayErrorMessage, __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Add item to object value
     * @throws \InvalidArgumentException
     * @param \StructType\InsuranceObject $item
     * @return \StructType\InsuranceObjectList
     */
    public function addToObject(\StructType\InsuranceObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InsuranceObject) {
            throw new \InvalidArgumentException(sprintf('The object property can only contain items of type \StructType\InsuranceObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->object[] = $item;
        return $this;
    }
}
