<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceObject StructType
 * @subpackage Structs
 */
class InsuranceObject extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParametrList
     */
    public $parameters;
    /**
     * The riskInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RiskInfoList
     */
    public $riskInfo;
    /**
     * The alias
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $alias;
    /**
     * Constructor method for InsuranceObject
     * @uses InsuranceObject::setName()
     * @uses InsuranceObject::setParameters()
     * @uses InsuranceObject::setRiskInfo()
     * @uses InsuranceObject::setAlias()
     * @param string $name
     * @param \StructType\ParametrList $parameters
     * @param \StructType\RiskInfoList $riskInfo
     * @param string $alias
     */
    public function __construct($name = null, \StructType\ParametrList $parameters = null, \StructType\RiskInfoList $riskInfo = null, $alias = null)
    {
        $this
            ->setName($name)
            ->setParameters($parameters)
            ->setRiskInfo($riskInfo)
            ->setAlias($alias);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\InsuranceObject
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\ParametrList|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\ParametrList $parameters
     * @return \StructType\InsuranceObject
     */
    public function setParameters(\StructType\ParametrList $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get riskInfo value
     * @return \StructType\RiskInfoList|null
     */
    public function getRiskInfo()
    {
        return $this->riskInfo;
    }
    /**
     * Set riskInfo value
     * @param \StructType\RiskInfoList $riskInfo
     * @return \StructType\InsuranceObject
     */
    public function setRiskInfo(\StructType\RiskInfoList $riskInfo = null)
    {
        $this->riskInfo = $riskInfo;
        return $this;
    }
    /**
     * Get alias value
     * @return string|null
     */
    public function getAlias()
    {
        return $this->alias;
    }
    /**
     * Set alias value
     * @param string $alias
     * @return \StructType\InsuranceObject
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alias, true), gettype($alias)), __LINE__);
        }
        $this->alias = $alias;
        return $this;
    }
}
