<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceByPeriod StructType
 * @subpackage Structs
 */
class InsuranceByPeriod extends AbstractStructBase
{
    /**
     * The dateStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateStart;
    /**
     * The dateEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateEnd;
    /**
     * The insSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insSum;
    /**
     * The insPrem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insPrem;
    /**
     * The insTarif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insTarif;
    /**
     * The risk
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $risk;
    /**
     * Constructor method for InsuranceByPeriod
     * @uses InsuranceByPeriod::setDateStart()
     * @uses InsuranceByPeriod::setDateEnd()
     * @uses InsuranceByPeriod::setInsSum()
     * @uses InsuranceByPeriod::setInsPrem()
     * @uses InsuranceByPeriod::setInsTarif()
     * @uses InsuranceByPeriod::setRisk()
     * @param string $dateStart
     * @param string $dateEnd
     * @param float $insSum
     * @param float $insPrem
     * @param float $insTarif
     * @param string $risk
     */
    public function __construct($dateStart = null, $dateEnd = null, $insSum = null, $insPrem = null, $insTarif = null, $risk = null)
    {
        $this
            ->setDateStart($dateStart)
            ->setDateEnd($dateEnd)
            ->setInsSum($insSum)
            ->setInsPrem($insPrem)
            ->setInsTarif($insTarif)
            ->setRisk($risk);
    }
    /**
     * Get dateStart value
     * @return string|null
     */
    public function getDateStart()
    {
        return $this->dateStart;
    }
    /**
     * Set dateStart value
     * @param string $dateStart
     * @return \StructType\InsuranceByPeriod
     */
    public function setDateStart($dateStart = null)
    {
        // validation for constraint: string
        if (!is_null($dateStart) && !is_string($dateStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateStart, true), gettype($dateStart)), __LINE__);
        }
        $this->dateStart = $dateStart;
        return $this;
    }
    /**
     * Get dateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->dateEnd;
    }
    /**
     * Set dateEnd value
     * @param string $dateEnd
     * @return \StructType\InsuranceByPeriod
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEnd, true), gettype($dateEnd)), __LINE__);
        }
        $this->dateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get insSum value
     * @return float|null
     */
    public function getInsSum()
    {
        return $this->insSum;
    }
    /**
     * Set insSum value
     * @param float $insSum
     * @return \StructType\InsuranceByPeriod
     */
    public function setInsSum($insSum = null)
    {
        // validation for constraint: float
        if (!is_null($insSum) && !(is_float($insSum) || is_numeric($insSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insSum, true), gettype($insSum)), __LINE__);
        }
        $this->insSum = $insSum;
        return $this;
    }
    /**
     * Get insPrem value
     * @return float|null
     */
    public function getInsPrem()
    {
        return $this->insPrem;
    }
    /**
     * Set insPrem value
     * @param float $insPrem
     * @return \StructType\InsuranceByPeriod
     */
    public function setInsPrem($insPrem = null)
    {
        // validation for constraint: float
        if (!is_null($insPrem) && !(is_float($insPrem) || is_numeric($insPrem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insPrem, true), gettype($insPrem)), __LINE__);
        }
        $this->insPrem = $insPrem;
        return $this;
    }
    /**
     * Get insTarif value
     * @return float|null
     */
    public function getInsTarif()
    {
        return $this->insTarif;
    }
    /**
     * Set insTarif value
     * @param float $insTarif
     * @return \StructType\InsuranceByPeriod
     */
    public function setInsTarif($insTarif = null)
    {
        // validation for constraint: float
        if (!is_null($insTarif) && !(is_float($insTarif) || is_numeric($insTarif))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insTarif, true), gettype($insTarif)), __LINE__);
        }
        $this->insTarif = $insTarif;
        return $this;
    }
    /**
     * Get risk value
     * @return string|null
     */
    public function getRisk()
    {
        return $this->risk;
    }
    /**
     * Set risk value
     * @param string $risk
     * @return \StructType\InsuranceByPeriod
     */
    public function setRisk($risk = null)
    {
        // validation for constraint: string
        if (!is_null($risk) && !is_string($risk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($risk, true), gettype($risk)), __LINE__);
        }
        $this->risk = $risk;
        return $this;
    }
}
