<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportPolicyResponse StructType
 * @subpackage Structs
 */
class ImportPolicyResponse extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Policy
     */
    public $policy;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $errors;
    /**
     * The warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $warnings;
    /**
     * Constructor method for ImportPolicyResponse
     * @uses ImportPolicyResponse::setAccID()
     * @uses ImportPolicyResponse::setPolicy()
     * @uses ImportPolicyResponse::setErrors()
     * @uses ImportPolicyResponse::setWarnings()
     * @param string $accID
     * @param \StructType\Policy $policy
     * @param \StructType\ErrorList $errors
     * @param \StructType\ErrorList $warnings
     */
    public function __construct($accID = null, \StructType\Policy $policy = null, \StructType\ErrorList $errors = null, \StructType\ErrorList $warnings = null)
    {
        $this
            ->setAccID($accID)
            ->setPolicy($policy)
            ->setErrors($errors)
            ->setWarnings($warnings);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\ImportPolicyResponse
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \StructType\Policy $policy
     * @return \StructType\ImportPolicyResponse
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\ImportPolicyResponse
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Get warnings value
     * @return \StructType\ErrorList|null
     */
    public function getWarnings()
    {
        return $this->warnings;
    }
    /**
     * Set warnings value
     * @param \StructType\ErrorList $warnings
     * @return \StructType\ImportPolicyResponse
     */
    public function setWarnings(\StructType\ErrorList $warnings = null)
    {
        $this->warnings = $warnings;
        return $this;
    }
}
