<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportPolicyRequest StructType
 * Meta information extracted from the WSDL
 * - type: tns:ImportPolicyRequest
 * @subpackage Structs
 */
class ImportPolicyRequest extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The extUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalSysUser
     */
    public $extUser;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Policy
     */
    public $policy;
    /**
     * Constructor method for ImportPolicyRequest
     * @uses ImportPolicyRequest::setAccID()
     * @uses ImportPolicyRequest::setExtUser()
     * @uses ImportPolicyRequest::setPolicy()
     * @param string $accID
     * @param \StructType\ExternalSysUser $extUser
     * @param \StructType\Policy $policy
     */
    public function __construct($accID = null, \StructType\ExternalSysUser $extUser = null, \StructType\Policy $policy = null)
    {
        $this
            ->setAccID($accID)
            ->setExtUser($extUser)
            ->setPolicy($policy);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\ImportPolicyRequest
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get extUser value
     * @return \StructType\ExternalSysUser|null
     */
    public function getExtUser()
    {
        return $this->extUser;
    }
    /**
     * Set extUser value
     * @param \StructType\ExternalSysUser $extUser
     * @return \StructType\ImportPolicyRequest
     */
    public function setExtUser(\StructType\ExternalSysUser $extUser = null)
    {
        $this->extUser = $extUser;
        return $this;
    }
    /**
     * Get policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \StructType\Policy $policy
     * @return \StructType\ImportPolicyRequest
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
}
