<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HideLoginRequest StructType
 * @subpackage Structs
 */
class HideLoginRequest extends AbstractStructBase
{
    /**
     * The loginInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LoginRequest
     */
    public $loginInfo;
    /**
     * The startWorkWithProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $startWorkWithProduct;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * Constructor method for HideLoginRequest
     * @uses HideLoginRequest::setLoginInfo()
     * @uses HideLoginRequest::setStartWorkWithProduct()
     * @uses HideLoginRequest::setProduct()
     * @param \StructType\LoginRequest $loginInfo
     * @param bool $startWorkWithProduct
     * @param string $product
     */
    public function __construct(\StructType\LoginRequest $loginInfo = null, $startWorkWithProduct = null, $product = null)
    {
        $this
            ->setLoginInfo($loginInfo)
            ->setStartWorkWithProduct($startWorkWithProduct)
            ->setProduct($product);
    }
    /**
     * Get loginInfo value
     * @return \StructType\LoginRequest|null
     */
    public function getLoginInfo()
    {
        return $this->loginInfo;
    }
    /**
     * Set loginInfo value
     * @param \StructType\LoginRequest $loginInfo
     * @return \StructType\HideLoginRequest
     */
    public function setLoginInfo(\StructType\LoginRequest $loginInfo = null)
    {
        $this->loginInfo = $loginInfo;
        return $this;
    }
    /**
     * Get startWorkWithProduct value
     * @return bool|null
     */
    public function getStartWorkWithProduct()
    {
        return $this->startWorkWithProduct;
    }
    /**
     * Set startWorkWithProduct value
     * @param bool $startWorkWithProduct
     * @return \StructType\HideLoginRequest
     */
    public function setStartWorkWithProduct($startWorkWithProduct = null)
    {
        // validation for constraint: boolean
        if (!is_null($startWorkWithProduct) && !is_bool($startWorkWithProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($startWorkWithProduct, true), gettype($startWorkWithProduct)), __LINE__);
        }
        $this->startWorkWithProduct = $startWorkWithProduct;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\HideLoginRequest
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
}
