<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPolicyRequest StructType
 * @subpackage Structs
 */
class GetPolicyRequest extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The calcID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calcID;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * Constructor method for GetPolicyRequest
     * @uses GetPolicyRequest::setAccID()
     * @uses GetPolicyRequest::setCalcID()
     * @uses GetPolicyRequest::setPolicyID()
     * @param string $accID
     * @param string $calcID
     * @param string $policyID
     */
    public function __construct($accID = null, $calcID = null, $policyID = null)
    {
        $this
            ->setAccID($accID)
            ->setCalcID($calcID)
            ->setPolicyID($policyID);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\GetPolicyRequest
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get calcID value
     * @return string|null
     */
    public function getCalcID()
    {
        return $this->calcID;
    }
    /**
     * Set calcID value
     * @param string $calcID
     * @return \StructType\GetPolicyRequest
     */
    public function setCalcID($calcID = null)
    {
        // validation for constraint: string
        if (!is_null($calcID) && !is_string($calcID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calcID, true), gettype($calcID)), __LINE__);
        }
        $this->calcID = $calcID;
        return $this;
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \StructType\GetPolicyRequest
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: string
        if (!is_null($policyID) && !is_string($policyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
}
