<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinancInformation StructType
 * @subpackage Structs
 */
class FinancInformation extends AbstractStructBase
{
    /**
     * The financInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DirectoryElemStrInfo[]
     */
    public $financInfo;
    /**
     * Constructor method for FinancInformation
     * @uses FinancInformation::setFinancInfo()
     * @param \StructType\DirectoryElemStrInfo[] $financInfo
     */
    public function __construct(array $financInfo = array())
    {
        $this
            ->setFinancInfo($financInfo);
    }
    /**
     * Get financInfo value
     * @return \StructType\DirectoryElemStrInfo[]|null
     */
    public function getFinancInfo()
    {
        return $this->financInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setFinancInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFinancInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFinancInfoForArrayConstraintsFromSetFinancInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $financInformationFinancInfoItem) {
            // validation for constraint: itemType
            if (!$financInformationFinancInfoItem instanceof \StructType\DirectoryElemStrInfo) {
                $invalidValues[] = is_object($financInformationFinancInfoItem) ? get_class($financInformationFinancInfoItem) : sprintf('%s(%s)', gettype($financInformationFinancInfoItem), var_export($financInformationFinancInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The financInfo property can only contain items of type \StructType\DirectoryElemStrInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set financInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectoryElemStrInfo[] $financInfo
     * @return \StructType\FinancInformation
     */
    public function setFinancInfo(array $financInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($financInfoArrayErrorMessage = self::validateFinancInfoForArrayConstraintsFromSetFinancInfo($financInfo))) {
            throw new \InvalidArgumentException($financInfoArrayErrorMessage, __LINE__);
        }
        $this->financInfo = $financInfo;
        return $this;
    }
    /**
     * Add item to financInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectoryElemStrInfo $item
     * @return \StructType\FinancInformation
     */
    public function addToFinancInfo(\StructType\DirectoryElemStrInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DirectoryElemStrInfo) {
            throw new \InvalidArgumentException(sprintf('The financInfo property can only contain items of type \StructType\DirectoryElemStrInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->financInfo[] = $item;
        return $this;
    }
}
