<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcelDictionaryResult StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcelDictionaryResult
 * @subpackage Structs
 */
class ExcelDictionaryResult extends AbstractStructBase
{
    /**
     * The ExcelUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExcelUrl;
    /**
     * The StreamBase64
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreamBase64;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Zip
     * @var bool
     */
    public $Zip;
    /**
     * Constructor method for ExcelDictionaryResult
     * @uses ExcelDictionaryResult::setExcelUrl()
     * @uses ExcelDictionaryResult::setStreamBase64()
     * @uses ExcelDictionaryResult::setErrorMessage()
     * @uses ExcelDictionaryResult::setZip()
     * @param string $excelUrl
     * @param string $streamBase64
     * @param string $errorMessage
     * @param bool $zip
     */
    public function __construct($excelUrl = null, $streamBase64 = null, $errorMessage = null, $zip = null)
    {
        $this
            ->setExcelUrl($excelUrl)
            ->setStreamBase64($streamBase64)
            ->setErrorMessage($errorMessage)
            ->setZip($zip);
    }
    /**
     * Get ExcelUrl value
     * @return string|null
     */
    public function getExcelUrl()
    {
        return $this->ExcelUrl;
    }
    /**
     * Set ExcelUrl value
     * @param string $excelUrl
     * @return \StructType\ExcelDictionaryResult
     */
    public function setExcelUrl($excelUrl = null)
    {
        // validation for constraint: string
        if (!is_null($excelUrl) && !is_string($excelUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($excelUrl, true), gettype($excelUrl)), __LINE__);
        }
        $this->ExcelUrl = $excelUrl;
        return $this;
    }
    /**
     * Get StreamBase64 value
     * @return string|null
     */
    public function getStreamBase64()
    {
        return $this->StreamBase64;
    }
    /**
     * Set StreamBase64 value
     * @param string $streamBase64
     * @return \StructType\ExcelDictionaryResult
     */
    public function setStreamBase64($streamBase64 = null)
    {
        // validation for constraint: string
        if (!is_null($streamBase64) && !is_string($streamBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streamBase64, true), gettype($streamBase64)), __LINE__);
        }
        $this->StreamBase64 = $streamBase64;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\ExcelDictionaryResult
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Zip value
     * @return bool|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param bool $zip
     * @return \StructType\ExcelDictionaryResult
     */
    public function setZip($zip = null)
    {
        // validation for constraint: boolean
        if (!is_null($zip) && !is_bool($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
}
