<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcelDictionaryParameter StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcelDictionaryParameter
 * @subpackage Structs
 */
class ExcelDictionaryParameter extends AbstractStructBase
{
    /**
     * The ZipExcel
     * @var bool
     */
    public $ZipExcel;
    /**
     * The UseBase64
     * @var bool
     */
    public $UseBase64;
    /**
     * The DictionaryCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExcelDictionaryCodes
     */
    public $DictionaryCodes;
    /**
     * Constructor method for ExcelDictionaryParameter
     * @uses ExcelDictionaryParameter::setZipExcel()
     * @uses ExcelDictionaryParameter::setUseBase64()
     * @uses ExcelDictionaryParameter::setDictionaryCodes()
     * @param bool $zipExcel
     * @param bool $useBase64
     * @param \StructType\ExcelDictionaryCodes $dictionaryCodes
     */
    public function __construct($zipExcel = null, $useBase64 = null, \StructType\ExcelDictionaryCodes $dictionaryCodes = null)
    {
        $this
            ->setZipExcel($zipExcel)
            ->setUseBase64($useBase64)
            ->setDictionaryCodes($dictionaryCodes);
    }
    /**
     * Get ZipExcel value
     * @return bool|null
     */
    public function getZipExcel()
    {
        return $this->ZipExcel;
    }
    /**
     * Set ZipExcel value
     * @param bool $zipExcel
     * @return \StructType\ExcelDictionaryParameter
     */
    public function setZipExcel($zipExcel = null)
    {
        // validation for constraint: boolean
        if (!is_null($zipExcel) && !is_bool($zipExcel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zipExcel, true), gettype($zipExcel)), __LINE__);
        }
        $this->ZipExcel = $zipExcel;
        return $this;
    }
    /**
     * Get UseBase64 value
     * @return bool|null
     */
    public function getUseBase64()
    {
        return $this->UseBase64;
    }
    /**
     * Set UseBase64 value
     * @param bool $useBase64
     * @return \StructType\ExcelDictionaryParameter
     */
    public function setUseBase64($useBase64 = null)
    {
        // validation for constraint: boolean
        if (!is_null($useBase64) && !is_bool($useBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useBase64, true), gettype($useBase64)), __LINE__);
        }
        $this->UseBase64 = $useBase64;
        return $this;
    }
    /**
     * Get DictionaryCodes value
     * @return \StructType\ExcelDictionaryCodes|null
     */
    public function getDictionaryCodes()
    {
        return $this->DictionaryCodes;
    }
    /**
     * Set DictionaryCodes value
     * @param \StructType\ExcelDictionaryCodes $dictionaryCodes
     * @return \StructType\ExcelDictionaryParameter
     */
    public function setDictionaryCodes(\StructType\ExcelDictionaryCodes $dictionaryCodes = null)
    {
        $this->DictionaryCodes = $dictionaryCodes;
        return $this;
    }
}
