<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentInfo StructType
 * @subpackage Structs
 */
class DocumentInfo extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The series
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $series;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The placeOfIssue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $placeOfIssue;
    /**
     * The dateOfIssue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateOfIssue;
    /**
     * The kodPodrazd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kodPodrazd;
    /**
     * The typeStr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $typeStr;
    /**
     * The dateBegin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateBegin;
    /**
     * The dateEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateEnd;
    /**
     * Constructor method for DocumentInfo
     * @uses DocumentInfo::setType()
     * @uses DocumentInfo::setSeries()
     * @uses DocumentInfo::setNumber()
     * @uses DocumentInfo::setPlaceOfIssue()
     * @uses DocumentInfo::setDateOfIssue()
     * @uses DocumentInfo::setKodPodrazd()
     * @uses DocumentInfo::setTypeStr()
     * @uses DocumentInfo::setDateBegin()
     * @uses DocumentInfo::setDateEnd()
     * @param string $type
     * @param string $series
     * @param string $number
     * @param string $placeOfIssue
     * @param string $dateOfIssue
     * @param string $kodPodrazd
     * @param string $typeStr
     * @param string $dateBegin
     * @param string $dateEnd
     */
    public function __construct($type = null, $series = null, $number = null, $placeOfIssue = null, $dateOfIssue = null, $kodPodrazd = null, $typeStr = null, $dateBegin = null, $dateEnd = null)
    {
        $this
            ->setType($type)
            ->setSeries($series)
            ->setNumber($number)
            ->setPlaceOfIssue($placeOfIssue)
            ->setDateOfIssue($dateOfIssue)
            ->setKodPodrazd($kodPodrazd)
            ->setTypeStr($typeStr)
            ->setDateBegin($dateBegin)
            ->setDateEnd($dateEnd);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\DocumentType::valueIsValid()
     * @uses \EnumType\DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DocumentInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DocumentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DocumentType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\DocumentType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get series value
     * @return string|null
     */
    public function getSeries()
    {
        return $this->series;
    }
    /**
     * Set series value
     * @param string $series
     * @return \StructType\DocumentInfo
     */
    public function setSeries($series = null)
    {
        // validation for constraint: string
        if (!is_null($series) && !is_string($series)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($series, true), gettype($series)), __LINE__);
        }
        $this->series = $series;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\DocumentInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get placeOfIssue value
     * @return string|null
     */
    public function getPlaceOfIssue()
    {
        return $this->placeOfIssue;
    }
    /**
     * Set placeOfIssue value
     * @param string $placeOfIssue
     * @return \StructType\DocumentInfo
     */
    public function setPlaceOfIssue($placeOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfIssue) && !is_string($placeOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeOfIssue, true), gettype($placeOfIssue)), __LINE__);
        }
        $this->placeOfIssue = $placeOfIssue;
        return $this;
    }
    /**
     * Get dateOfIssue value
     * @return string|null
     */
    public function getDateOfIssue()
    {
        return $this->dateOfIssue;
    }
    /**
     * Set dateOfIssue value
     * @param string $dateOfIssue
     * @return \StructType\DocumentInfo
     */
    public function setDateOfIssue($dateOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfIssue) && !is_string($dateOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfIssue, true), gettype($dateOfIssue)), __LINE__);
        }
        $this->dateOfIssue = $dateOfIssue;
        return $this;
    }
    /**
     * Get kodPodrazd value
     * @return string|null
     */
    public function getKodPodrazd()
    {
        return $this->kodPodrazd;
    }
    /**
     * Set kodPodrazd value
     * @param string $kodPodrazd
     * @return \StructType\DocumentInfo
     */
    public function setKodPodrazd($kodPodrazd = null)
    {
        // validation for constraint: string
        if (!is_null($kodPodrazd) && !is_string($kodPodrazd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodPodrazd, true), gettype($kodPodrazd)), __LINE__);
        }
        $this->kodPodrazd = $kodPodrazd;
        return $this;
    }
    /**
     * Get typeStr value
     * @return string|null
     */
    public function getTypeStr()
    {
        return $this->typeStr;
    }
    /**
     * Set typeStr value
     * @param string $typeStr
     * @return \StructType\DocumentInfo
     */
    public function setTypeStr($typeStr = null)
    {
        // validation for constraint: string
        if (!is_null($typeStr) && !is_string($typeStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeStr, true), gettype($typeStr)), __LINE__);
        }
        $this->typeStr = $typeStr;
        return $this;
    }
    /**
     * Get dateBegin value
     * @return string|null
     */
    public function getDateBegin()
    {
        return $this->dateBegin;
    }
    /**
     * Set dateBegin value
     * @param string $dateBegin
     * @return \StructType\DocumentInfo
     */
    public function setDateBegin($dateBegin = null)
    {
        // validation for constraint: string
        if (!is_null($dateBegin) && !is_string($dateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateBegin, true), gettype($dateBegin)), __LINE__);
        }
        $this->dateBegin = $dateBegin;
        return $this;
    }
    /**
     * Get dateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->dateEnd;
    }
    /**
     * Set dateEnd value
     * @param string $dateEnd
     * @return \StructType\DocumentInfo
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEnd, true), gettype($dateEnd)), __LINE__);
        }
        $this->dateEnd = $dateEnd;
        return $this;
    }
}
