<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DissolutionPolicyResponse StructType
 * @subpackage Structs
 */
class DissolutionPolicyResponse extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $errors;
    /**
     * The dissolution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Dissolution
     */
    public $dissolution;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $policyID;
    /**
     * Constructor method for DissolutionPolicyResponse
     * @uses DissolutionPolicyResponse::setAccID()
     * @uses DissolutionPolicyResponse::setErrors()
     * @uses DissolutionPolicyResponse::setDissolution()
     * @uses DissolutionPolicyResponse::setPolicyID()
     * @param string $accID
     * @param \StructType\ErrorList $errors
     * @param \StructType\Dissolution $dissolution
     * @param int $policyID
     */
    public function __construct($accID = null, \StructType\ErrorList $errors = null, \StructType\Dissolution $dissolution = null, $policyID = null)
    {
        $this
            ->setAccID($accID)
            ->setErrors($errors)
            ->setDissolution($dissolution)
            ->setPolicyID($policyID);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\DissolutionPolicyResponse
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\DissolutionPolicyResponse
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Get dissolution value
     * @return \StructType\Dissolution|null
     */
    public function getDissolution()
    {
        return $this->dissolution;
    }
    /**
     * Set dissolution value
     * @param \StructType\Dissolution $dissolution
     * @return \StructType\DissolutionPolicyResponse
     */
    public function setDissolution(\StructType\Dissolution $dissolution = null)
    {
        $this->dissolution = $dissolution;
        return $this;
    }
    /**
     * Get policyID value
     * @return int|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param int $policyID
     * @return \StructType\DissolutionPolicyResponse
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: int
        if (!is_null($policyID) && !(is_int($policyID) || ctype_digit($policyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
}
