<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DissolutionPolicyRequest StructType
 * @subpackage Structs
 */
class DissolutionPolicyRequest extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The dissolution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Dissolution
     */
    public $dissolution;
    /**
     * Constructor method for DissolutionPolicyRequest
     * @uses DissolutionPolicyRequest::setAccID()
     * @uses DissolutionPolicyRequest::setDissolution()
     * @param string $accID
     * @param \StructType\Dissolution $dissolution
     */
    public function __construct($accID = null, \StructType\Dissolution $dissolution = null)
    {
        $this
            ->setAccID($accID)
            ->setDissolution($dissolution);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\DissolutionPolicyRequest
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get dissolution value
     * @return \StructType\Dissolution|null
     */
    public function getDissolution()
    {
        return $this->dissolution;
    }
    /**
     * Set dissolution value
     * @param \StructType\Dissolution $dissolution
     * @return \StructType\DissolutionPolicyRequest
     */
    public function setDissolution(\StructType\Dissolution $dissolution = null)
    {
        $this->dissolution = $dissolution;
        return $this;
    }
}
