<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryValue StructType
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryValue
 * @subpackage Structs
 */
class DictionaryValue extends AbstractStructBase
{
    /**
     * The ValueCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValueCode;
    /**
     * The Parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParameterDictionaryInfo[]
     */
    public $Parameter;
    /**
     * Constructor method for DictionaryValue
     * @uses DictionaryValue::setValueCode()
     * @uses DictionaryValue::setParameter()
     * @param string $valueCode
     * @param \StructType\ParameterDictionaryInfo[] $parameter
     */
    public function __construct($valueCode = null, array $parameter = array())
    {
        $this
            ->setValueCode($valueCode)
            ->setParameter($parameter);
    }
    /**
     * Get ValueCode value
     * @return string|null
     */
    public function getValueCode()
    {
        return $this->ValueCode;
    }
    /**
     * Set ValueCode value
     * @param string $valueCode
     * @return \StructType\DictionaryValue
     */
    public function setValueCode($valueCode = null)
    {
        // validation for constraint: string
        if (!is_null($valueCode) && !is_string($valueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueCode, true), gettype($valueCode)), __LINE__);
        }
        $this->ValueCode = $valueCode;
        return $this;
    }
    /**
     * Get Parameter value
     * @return \StructType\ParameterDictionaryInfo[]|null
     */
    public function getParameter()
    {
        return $this->Parameter;
    }
    /**
     * This method is responsible for validating the values passed to the setParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParameterForArrayConstraintsFromSetParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dictionaryValueParameterItem) {
            // validation for constraint: itemType
            if (!$dictionaryValueParameterItem instanceof \StructType\ParameterDictionaryInfo) {
                $invalidValues[] = is_object($dictionaryValueParameterItem) ? get_class($dictionaryValueParameterItem) : sprintf('%s(%s)', gettype($dictionaryValueParameterItem), var_export($dictionaryValueParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parameter property can only contain items of type \StructType\ParameterDictionaryInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\ParameterDictionaryInfo[] $parameter
     * @return \StructType\DictionaryValue
     */
    public function setParameter(array $parameter = array())
    {
        // validation for constraint: array
        if ('' !== ($parameterArrayErrorMessage = self::validateParameterForArrayConstraintsFromSetParameter($parameter))) {
            throw new \InvalidArgumentException($parameterArrayErrorMessage, __LINE__);
        }
        $this->Parameter = $parameter;
        return $this;
    }
    /**
     * Add item to Parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\ParameterDictionaryInfo $item
     * @return \StructType\DictionaryValue
     */
    public function addToParameter(\StructType\ParameterDictionaryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParameterDictionaryInfo) {
            throw new \InvalidArgumentException(sprintf('The Parameter property can only contain items of type \StructType\ParameterDictionaryInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parameter[] = $item;
        return $this;
    }
}
