<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryType StructType
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryType
 * @subpackage Structs
 */
class DictionaryType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParameterDictionaryTypeList
     */
    public $Parameters;
    /**
     * Constructor method for DictionaryType
     * @uses DictionaryType::setCode()
     * @uses DictionaryType::setName()
     * @uses DictionaryType::setParameters()
     * @param string $code
     * @param string $name
     * @param \StructType\ParameterDictionaryTypeList $parameters
     */
    public function __construct($code = null, $name = null, \StructType\ParameterDictionaryTypeList $parameters = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setParameters($parameters);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\DictionaryType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\DictionaryType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \StructType\ParameterDictionaryTypeList|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \StructType\ParameterDictionaryTypeList $parameters
     * @return \StructType\DictionaryType
     */
    public function setParameters(\StructType\ParameterDictionaryTypeList $parameters = null)
    {
        $this->Parameters = $parameters;
        return $this;
    }
}
