<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryAttributeValueList StructType
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryAttributeValueList
 * @subpackage Structs
 */
class DictionaryAttributeValueList extends AbstractStructBase
{
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DictionaryAttributeValue[]
     */
    public $Items;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $Errors;
    /**
     * Constructor method for DictionaryAttributeValueList
     * @uses DictionaryAttributeValueList::setItems()
     * @uses DictionaryAttributeValueList::setErrors()
     * @param \StructType\DictionaryAttributeValue[] $items
     * @param \StructType\ErrorList $errors
     */
    public function __construct(array $items = array(), \StructType\ErrorList $errors = null)
    {
        $this
            ->setItems($items)
            ->setErrors($errors);
    }
    /**
     * Get Items value
     * @return \StructType\DictionaryAttributeValue[]|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dictionaryAttributeValueListItemsItem) {
            // validation for constraint: itemType
            if (!$dictionaryAttributeValueListItemsItem instanceof \StructType\DictionaryAttributeValue) {
                $invalidValues[] = is_object($dictionaryAttributeValueListItemsItem) ? get_class($dictionaryAttributeValueListItemsItem) : sprintf('%s(%s)', gettype($dictionaryAttributeValueListItemsItem), var_export($dictionaryAttributeValueListItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Items property can only contain items of type \StructType\DictionaryAttributeValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Items value
     * @throws \InvalidArgumentException
     * @param \StructType\DictionaryAttributeValue[] $items
     * @return \StructType\DictionaryAttributeValueList
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->Items = $items;
        return $this;
    }
    /**
     * Add item to Items value
     * @throws \InvalidArgumentException
     * @param \StructType\DictionaryAttributeValue $item
     * @return \StructType\DictionaryAttributeValueList
     */
    public function addToItems(\StructType\DictionaryAttributeValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DictionaryAttributeValue) {
            throw new \InvalidArgumentException(sprintf('The Items property can only contain items of type \StructType\DictionaryAttributeValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Items[] = $item;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\DictionaryAttributeValueList
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
}
