<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryAttributeValue StructType
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryAttributeValue
 * @subpackage Structs
 */
class DictionaryAttributeValue extends AbstractStructBase
{
    /**
     * The DictionaryValueCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DictionaryValueCode;
    /**
     * The AttributeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AttributeCode;
    /**
     * The AttributeValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AttributeValue;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $Errors;
    /**
     * Constructor method for DictionaryAttributeValue
     * @uses DictionaryAttributeValue::setDictionaryValueCode()
     * @uses DictionaryAttributeValue::setAttributeCode()
     * @uses DictionaryAttributeValue::setAttributeValue()
     * @uses DictionaryAttributeValue::setErrors()
     * @param string $dictionaryValueCode
     * @param string $attributeCode
     * @param string $attributeValue
     * @param \StructType\ErrorList $errors
     */
    public function __construct($dictionaryValueCode = null, $attributeCode = null, $attributeValue = null, \StructType\ErrorList $errors = null)
    {
        $this
            ->setDictionaryValueCode($dictionaryValueCode)
            ->setAttributeCode($attributeCode)
            ->setAttributeValue($attributeValue)
            ->setErrors($errors);
    }
    /**
     * Get DictionaryValueCode value
     * @return string|null
     */
    public function getDictionaryValueCode()
    {
        return $this->DictionaryValueCode;
    }
    /**
     * Set DictionaryValueCode value
     * @param string $dictionaryValueCode
     * @return \StructType\DictionaryAttributeValue
     */
    public function setDictionaryValueCode($dictionaryValueCode = null)
    {
        // validation for constraint: string
        if (!is_null($dictionaryValueCode) && !is_string($dictionaryValueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictionaryValueCode, true), gettype($dictionaryValueCode)), __LINE__);
        }
        $this->DictionaryValueCode = $dictionaryValueCode;
        return $this;
    }
    /**
     * Get AttributeCode value
     * @return string|null
     */
    public function getAttributeCode()
    {
        return $this->AttributeCode;
    }
    /**
     * Set AttributeCode value
     * @param string $attributeCode
     * @return \StructType\DictionaryAttributeValue
     */
    public function setAttributeCode($attributeCode = null)
    {
        // validation for constraint: string
        if (!is_null($attributeCode) && !is_string($attributeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeCode, true), gettype($attributeCode)), __LINE__);
        }
        $this->AttributeCode = $attributeCode;
        return $this;
    }
    /**
     * Get AttributeValue value
     * @return string|null
     */
    public function getAttributeValue()
    {
        return $this->AttributeValue;
    }
    /**
     * Set AttributeValue value
     * @param string $attributeValue
     * @return \StructType\DictionaryAttributeValue
     */
    public function setAttributeValue($attributeValue = null)
    {
        // validation for constraint: string
        if (!is_null($attributeValue) && !is_string($attributeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeValue, true), gettype($attributeValue)), __LINE__);
        }
        $this->AttributeValue = $attributeValue;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\DictionaryAttributeValue
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
}
